/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.projectile;

import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.tropicraft.core.common.entity.TropicraftEntities;
import net.tropicraft.core.common.item.TropicraftItems;

public class ExplodingCoconutEntity
extends ThrowableItemProjectile {
    public static final float DEFAULT_EXPLOSION_RADIUS = 2.4f;
    public static final float MAX_EXPLOSION_RADIUS = 5.0f;
    public static final boolean DEFAULT_DESTROYS_BLOCKS = true;
    private float explosionRadius = 2.4f;
    private boolean destroysBlocks;

    public ExplodingCoconutEntity(EntityType<? extends ExplodingCoconutEntity> type, Level world) {
        super(type, world);
    }

    public ExplodingCoconutEntity(Level world, LivingEntity thrower, float explosionRadius, boolean destroysBlocks) {
        super((EntityType)TropicraftEntities.EXPLODING_COCONUT.get(), thrower, world);
        this.explosionRadius = explosionRadius;
        this.destroysBlocks = destroysBlocks;
    }

    protected void onHit(HitResult result) {
        if (!this.level().isClientSide) {
            this.level().explode((Entity)this, this.level().damageSources().explosion((Entity)this, this.getOwner()), null, this.getX(), this.getY(), this.getZ(), Mth.clamp((float)this.explosionRadius, (float)0.0f, (float)5.0f), false, this.destroysBlocks ? Level.ExplosionInteraction.BLOCK : Level.ExplosionInteraction.NONE, (ParticleOptions)ParticleTypes.EXPLOSION, (ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, (Holder)SoundEvents.GENERIC_EXPLODE);
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    protected Item getDefaultItem() {
        return (Item)TropicraftItems.EXPLODING_COCONUT.get();
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putFloat("explosion_radius", this.explosionRadius);
        tag.putBoolean("destroys_blocks", this.destroysBlocks);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("explosion_radius", 5)) {
            this.explosionRadius = tag.getFloat("explosion_radius");
        }
        this.destroysBlocks = tag.getBoolean("destroys_blocks");
    }
}

