/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.placeable;

import com.tterrag.registrate.util.entry.RegistryEntry;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public abstract class FurnitureEntity
extends Entity {
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.defineId(FurnitureEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.defineId(FurnitureEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> FORWARD_DIRECTION = SynchedEntityData.defineId(FurnitureEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> TIME_SINCE_HIT = SynchedEntityData.defineId(FurnitureEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> GLUED_DOWN = SynchedEntityData.defineId(FurnitureEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final int DAMAGE_THRESHOLD = 40;
    private final Function<DyeColor, Item> itemLookup;
    protected int lerpSteps;
    protected double lerpX;
    protected double lerpY;
    protected double lerpZ;
    protected double lerpYaw = Double.NaN;
    protected double lerpPitch;

    protected FurnitureEntity(EntityType<?> entityTypeIn, Level worldIn, Map<DyeColor, ? extends RegistryEntry<? extends Item, ? extends Item>> items) {
        this(entityTypeIn, worldIn, (DyeColor c) -> (Item)((RegistryEntry)items.get(c)).get());
    }

    protected FurnitureEntity(EntityType<?> entityTypeIn, Level worldIn, Function<DyeColor, Item> itemLookup) {
        super(entityTypeIn, worldIn);
        this.itemLookup = itemLookup;
        this.blocksBuilding = true;
    }

    public boolean isInvulnerableTo(DamageSource pSource) {
        return (Boolean)this.entityData.get(GLUED_DOWN) != false || super.isInvulnerableTo(pSource);
    }

    public void setRotation(float yaw) {
        this.lerpYaw = Mth.wrapDegrees((float)yaw);
        this.setYRot((float)this.lerpYaw);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(COLOR, (Object)0);
        builder.define(DAMAGE, (Object)Float.valueOf(0.0f));
        builder.define(FORWARD_DIRECTION, (Object)1);
        builder.define(TIME_SINCE_HIT, (Object)0);
        builder.define(GLUED_DOWN, (Object)false);
    }

    public void tick() {
        float damage;
        int timeSinceHit = this.getTimeSinceHit();
        if (timeSinceHit > 0) {
            this.setTimeSinceHit(timeSinceHit - 1);
        }
        if ((damage = this.getDamage()) > 0.0f) {
            this.setDamage(damage - 1.0f);
        }
        Vec3 currentPos = this.position();
        this.xo = currentPos.x;
        this.yo = currentPos.y;
        this.zo = currentPos.z;
        super.tick();
        this.tickLerp();
        if (this.preventMotion()) {
            this.setDeltaMovement(Vec3.ZERO);
        }
        this.checkInsideBlocks();
        List list = this.level().getEntities((Entity)this, this.getBoundingBox().inflate((double)0.2f, (double)-0.01f, (double)0.2f), EntitySelector.pushableBy((Entity)this));
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                if (entity.hasPassenger((Entity)this)) continue;
                this.push(entity);
            }
        }
    }

    protected boolean preventMotion() {
        return true;
    }

    public void lerpTo(double x, double y, double z, float yaw, float pitch, int posRotationIncrements) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        if (yaw != this.getYRot() || Double.isNaN(this.lerpYaw)) {
            this.lerpYaw = Mth.wrapDegrees((double)yaw);
        }
        this.lerpSteps = 10;
        this.setXRot(pitch);
    }

    private void tickLerp() {
        if (this.lerpSteps > 0) {
            double d0 = this.getX() + (this.lerpX - this.getX()) / (double)this.lerpSteps;
            double d1 = this.getY() + (this.lerpY - this.getY()) / (double)this.lerpSteps;
            double d2 = this.getZ() + (this.lerpZ - this.getZ()) / (double)this.lerpSteps;
            double d3 = Mth.wrapDegrees((double)(this.lerpYaw - (double)this.getYRot()));
            this.setYRot((float)((double)this.getYRot() + d3 / (double)this.lerpSteps));
            this.setXRot((float)((double)this.getXRot() + (this.lerpPitch - (double)this.getXRot()) / (double)this.lerpSteps));
            --this.lerpSteps;
            this.setPos(d0, d1, d2);
            this.setRot(this.getYRot(), this.getXRot());
        }
    }

    public InteractionResult interact(Player pPlayer, InteractionHand pHand) {
        if (this.invulnerablityCheck(pPlayer, pHand) == InteractionResult.SUCCESS) {
            return InteractionResult.SUCCESS;
        }
        return super.interact(pPlayer, pHand);
    }

    public InteractionResult invulnerablityCheck(Player pPlayer, InteractionHand pHand) {
        if (pPlayer.getItemInHand(pHand).is(Items.DEBUG_STICK)) {
            if (!this.level().isClientSide) {
                this.entityData.set(GLUED_DOWN, (Object)((Boolean)this.entityData.get(GLUED_DOWN) == false ? 1 : 0));
                pPlayer.sendSystemMessage((Component)Component.translatable((String)("Invulnerability Mode: " + ((Boolean)this.entityData.get(GLUED_DOWN) != false ? "On" : "Off"))));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public boolean hurt(DamageSource damageSource, float amount) {
        if (this.isInvulnerableTo(damageSource)) {
            Entity entity = damageSource.getEntity();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                return player.getMainHandItem().is(Items.DEBUG_STICK);
            }
            return false;
        }
        if (!this.level().isClientSide && this.isAlive()) {
            boolean flag;
            this.setForwardDirection(-this.getForwardDirection());
            this.setTimeSinceHit(10);
            this.setDamage(this.getDamage() + amount * 10.0f);
            this.markHurt();
            boolean bl = flag = damageSource.getEntity() instanceof Player && ((Player)damageSource.getEntity()).getAbilities().instabuild;
            if (flag || this.getDamage() > 40.0f) {
                LivingEntity rider = this.getControllingPassenger();
                if (rider != null) {
                    rider.startRiding((Entity)this);
                }
                if (!flag) {
                    this.spawnAtLocation(this.getItemStack(), 0.0f);
                }
                this.remove(Entity.RemovalReason.KILLED);
            }
        }
        return true;
    }

    private ItemStack getItemStack() {
        return new ItemStack((ItemLike)this.itemLookup.apply(this.getColor()));
    }

    public void animateHurt(float direction) {
        this.setForwardDirection(-1 * this.getForwardDirection());
        this.setTimeSinceHit(10);
        this.setDamage(this.getDamage() * 10.0f);
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    public boolean isPickable() {
        return true;
    }

    protected void readAdditionalSaveData(CompoundTag nbt) {
        this.setColor(DyeColor.byId((int)nbt.getInt("Color")));
        if (nbt.contains("GluedDown")) {
            this.entityData.set(GLUED_DOWN, (Object)nbt.getBoolean("GluedDown"));
        }
    }

    protected void addAdditionalSaveData(CompoundTag nbt) {
        nbt.putInt("Color", this.getColor().ordinal());
        nbt.putBoolean("GluedDown", ((Boolean)this.entityData.get(GLUED_DOWN)).booleanValue());
    }

    public void setColor(DyeColor color) {
        this.entityData.set(COLOR, (Object)color.ordinal());
    }

    public DyeColor getColor() {
        return DyeColor.byId((int)((Integer)this.entityData.get(COLOR)));
    }

    public void setForwardDirection(int dir) {
        this.entityData.set(FORWARD_DIRECTION, (Object)dir);
    }

    public int getForwardDirection() {
        return (Integer)this.entityData.get(FORWARD_DIRECTION);
    }

    public void setDamage(float damageTaken) {
        this.entityData.set(DAMAGE, (Object)Float.valueOf(damageTaken));
    }

    public float getDamage() {
        return ((Float)this.entityData.get(DAMAGE)).floatValue();
    }

    public void setTimeSinceHit(int timeSinceHit) {
        this.entityData.set(TIME_SINCE_HIT, (Object)timeSinceHit);
    }

    public int getTimeSinceHit() {
        return (Integer)this.entityData.get(TIME_SINCE_HIT);
    }
}

