/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.placeable;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;
import net.tropicraft.core.common.entity.placeable.FurnitureEntity;
import net.tropicraft.core.common.item.TropicraftItems;

public class BeachFloatEntity
extends FurnitureEntity
implements IEntityWithComplexSpawn {
    @Nonnull
    private static final RandomSource rand = RandomSource.create((long)298457L);
    @Nonnull
    private static final PerlinSimplexNoise windNoise = new PerlinSimplexNoise((RandomSource)new WorldgenRandom((RandomSource)new LegacyRandomSource(298457L)), (List)ImmutableList.of((Object)0));
    private double windModifier = 0.0;
    public final boolean isEmpty;
    public float rotationSpeed;
    private double prevMotionY;

    public BeachFloatEntity(EntityType<BeachFloatEntity> type, Level worldIn) {
        super(type, worldIn, TropicraftItems.BEACH_FLOATS);
        this.isEmpty = true;
        this.blocksBuilding = true;
        this.setId(this.getId());
    }

    public void setId(int id) {
        super.setId(id);
        rand.setSeed((long)id);
        this.windModifier = 1.0 + rand.nextGaussian() * 0.1 - 0.05;
    }

    @Override
    public void tick() {
        double eps;
        double center;
        double water;
        LivingEntity rider = this.getControllingPassenger();
        if (this.level().isClientSide && rider instanceof Player) {
            Player controller = (Player)rider;
            float move = controller.zza;
            float rot = -controller.xxa;
            this.rotationSpeed += rot * 0.25f;
            float ang = this.getYRot();
            float moveX = Mth.sin((float)(-ang * ((float)Math.PI / 180))) * move * 0.0035f;
            float moveZ = Mth.cos((float)(ang * ((float)Math.PI / 180))) * move * 0.0035f;
            this.setDeltaMovement(this.getDeltaMovement().add((double)moveX, 0.0, (double)moveZ));
        }
        if (this.wasTouchingWater) {
            double windAng = (windNoise.getValue(this.getX() / 1000.0, this.getZ() / 1000.0, false) + 1.0) * Math.PI;
            double windX = Math.sin(windAng) * 5.0E-4 * this.windModifier;
            double windZ = Math.cos(windAng) * 5.0E-4 * this.windModifier;
            this.setDeltaMovement(this.getDeltaMovement().add(windX, 0.0, windZ));
            double targetYaw = Math.toDegrees(windAng) + (this.windModifier - 1.0) * 45.0;
            double yaw = (Mth.wrapDegrees((float)this.getYRot()) + 180.0f - 35.0f) % 360.0f;
            double angleDiff = targetYaw - yaw;
            this.rotationSpeed = angleDiff > 0.0 ? (float)((double)this.rotationSpeed + Math.min(0.005 * this.windModifier, angleDiff)) : (float)((double)this.rotationSpeed + Math.max(-0.005 * this.windModifier, angleDiff));
        }
        if ((water = (double)this.getWaterLevel()) < (center = this.getCenterY()) - (eps = 0.0)) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -Mth.clamp((double)(center - water), (double)0.0, (double)0.04), 0.0));
        } else if (water > center + eps) {
            double floatpush = Mth.clamp((double)(water - center), (double)0.0, (double)0.02);
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, floatpush, 0.0));
        } else if (Math.abs(this.getDeltaMovement().y) < 0.02) {
            if (this.getDeltaMovement().y != 0.0) {
                this.lerpY = water - 0.011;
            }
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.0, 1.0));
            this.prevMotionY = 0.0;
        }
        super.tick();
        this.setYRot(this.getYRot() + this.rotationSpeed);
        this.move(MoverType.PLAYER, this.getDeltaMovement());
        this.setDeltaMovement(this.getDeltaMovement().multiply(0.9, 0.9, 0.9));
        this.rotationSpeed *= 0.9f;
        if (!this.level().isClientSide) {
            List list = this.level().getEntities((Entity)this, this.getBoundingBox().inflate((double)0.2f, 0.0, (double)0.2f));
            for (Entity entity : list) {
                if (entity == this.getControllingPassenger() || !entity.isPushable()) continue;
                entity.push((Entity)this);
            }
            if (this.getControllingPassenger() != null && !this.getControllingPassenger().isAlive()) {
                this.ejectPassengers();
            }
        }
    }

    @Override
    protected boolean preventMotion() {
        return false;
    }

    private double getCenterY() {
        AABB bb = this.getBoundingBox();
        return bb.minY + (bb.maxY - bb.minY) * 0.5;
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        this.prevMotionY = this.getDeltaMovement().y;
        super.checkFallDamage(y, onGroundIn, state, pos);
    }

    protected boolean updateInWaterStateAndDoFluidPushing() {
        this.fluidHeight.clear();
        this.updateWaterState();
        boolean lava = this.updateFluidHeightAndDoFluidPushing(FluidTags.LAVA, this.level().dimensionType().ultraWarm() ? 0.007 : 0.0023333333333333335);
        return this.isInWater() || lava;
    }

    void updateWaterState() {
        AABB temp = this.getBoundingBox();
        this.setBoundingBox(temp.contract(1.0, 0.0, 1.0).contract(-1.0, 0.125, -1.0));
        try {
            if (this.updateFluidHeightAndDoFluidPushing(FluidTags.WATER, 0.014)) {
                if (!this.wasTouchingWater && !this.firstTick) {
                    this.doWaterSplashEffect();
                }
                this.fallDistance = 0.0f;
                this.wasTouchingWater = true;
                this.clearFire();
            } else {
                this.wasTouchingWater = false;
            }
        }
        finally {
            this.setBoundingBox(temp);
        }
    }

    @Override
    public InteractionResult interact(Player player, InteractionHand hand) {
        if (this.invulnerablityCheck(player, hand) == InteractionResult.SUCCESS) {
            return InteractionResult.SUCCESS;
        }
        if (!this.level().isClientSide && !player.isShiftKeyDown()) {
            player.startRiding((Entity)this);
            return InteractionResult.SUCCESS;
        }
        return !player.isPassengerOfSameVehicle((Entity)this) ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    protected void positionRider(Entity passenger, Entity.MoveFunction move) {
        super.positionRider(passenger, move);
        if (!passenger.getType().is(EntityTypeTags.CAN_TURN_IN_BOATS)) {
            passenger.setYRot(passenger.getYRot() + this.rotationSpeed);
            passenger.setYHeadRot(passenger.getYHeadRot() + this.rotationSpeed);
            this.applyYawToEntity(passenger);
        }
    }

    protected void removePassenger(Entity passenger) {
        super.removePassenger(passenger);
        if (passenger instanceof Player) {
            passenger.refreshDimensions();
        }
    }

    protected void applyYawToEntity(Entity entityToUpdate) {
        if (!entityToUpdate.level().isClientSide || BeachFloatEntity.isClientFirstPerson(entityToUpdate)) {
            entityToUpdate.setYBodyRot(this.getYRot());
            float yaw = Mth.wrapDegrees((float)(entityToUpdate.getYRot() - this.getYRot()));
            float pitch = Mth.wrapDegrees((float)(entityToUpdate.getXRot() - this.getXRot()));
            float clampedYaw = Mth.clamp((float)yaw, (float)-105.0f, (float)105.0f);
            float clampedPitch = Mth.clamp((float)pitch, (float)-100.0f, (float)0.0f);
            float yawClampDelta = clampedYaw - yaw;
            float pitchClampDelta = clampedPitch - pitch;
            entityToUpdate.yRotO += yawClampDelta;
            entityToUpdate.setYRot(entityToUpdate.getYRot() + yawClampDelta);
            entityToUpdate.xRotO += pitchClampDelta;
            entityToUpdate.setXRot(entityToUpdate.getXRot() + pitchClampDelta);
            entityToUpdate.setYHeadRot(entityToUpdate.getYRot());
        }
    }

    public void onPassengerTurned(@Nonnull Entity entityToUpdate) {
        this.applyYawToEntity(entityToUpdate);
    }

    private static boolean isClientFirstPerson(Entity entity) {
        Minecraft client = Minecraft.getInstance();
        return client.cameraEntity == entity && client.options.getCameraType() == CameraType.FIRST_PERSON;
    }

    private float getWaterLevel() {
        AABB axisalignedbb = this.getBoundingBox();
        int minX = Mth.floor((double)axisalignedbb.minX);
        int maxX = Mth.ceil((double)axisalignedbb.maxX);
        int minY = Mth.floor((double)(axisalignedbb.minY - this.prevMotionY));
        int maxY = minY + 1;
        int minZ = Mth.floor((double)axisalignedbb.minZ);
        int maxZ = Mth.ceil((double)axisalignedbb.maxZ);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        float waterHeight = minY - 1;
        for (int y = maxY; y >= minY; --y) {
            for (int x = minX; x < maxX; ++x) {
                for (int z = minZ; z < maxZ; ++z) {
                    pos.set(x, y, z);
                    FluidState fluidstate = this.level().getFluidState((BlockPos)pos);
                    if (fluidstate.getType().isSame((Fluid)Fluids.WATER)) {
                        waterHeight = Math.max(waterHeight, (float)pos.getY() + fluidstate.getHeight((BlockGetter)this.level(), (BlockPos)pos));
                    }
                    if (!(waterHeight >= (float)maxY)) continue;
                    return waterHeight;
                }
            }
        }
        return waterHeight;
    }

    public boolean isPushable() {
        return true;
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        LivingEntity living;
        Entity entity = this.getFirstPassenger();
        return entity instanceof LivingEntity ? (living = (LivingEntity)entity) : null;
    }

    public Direction getMotionDirection() {
        return this.getDirection().getClockWise();
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public void writeSpawnData(RegistryFriendlyByteBuf buffer) {
        buffer.writeDouble(this.lerpYaw);
    }

    public void readSpawnData(RegistryFriendlyByteBuf additionalData) {
        this.lerpYaw = Mth.wrapDegrees((double)additionalData.readDouble());
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)TropicraftItems.BEACH_FLOATS.get(DyeColor.byId((int)this.getColor().getId())).get());
    }

    public AABB getBoundingBoxForCulling() {
        return this.getBoundingBox().inflate(0.1, 0.1, 0.1);
    }
}

