/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.passive;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.IShearable;
import net.tropicraft.core.common.TropicraftRegistries;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.block.TropicraftFlower;
import net.tropicraft.core.common.block.TropicsFlowerBlock;
import net.tropicraft.core.common.entity.TropicraftEntities;
import net.tropicraft.core.common.item.CocktailItem;
import net.tropicraft.core.common.item.TropicraftItems;

public class CowktailEntity
extends Cow
implements IShearable {
    private static final EntityDataAccessor<String> COWKTAIL_TYPE = SynchedEntityData.defineId(CowktailEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);

    public CowktailEntity(EntityType<? extends CowktailEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader worldIn) {
        return worldIn.getBlockState(pos.below()).is(Blocks.MYCELIUM) ? 10.0f : worldIn.getPathfindingCostFromLightLevels(pos);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(COWKTAIL_TYPE, (Object)Type.IRIS.name);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.getItem() == TropicraftItems.BAMBOO_MUG.get() && !this.isBaby()) {
            itemStack.consume(1, (LivingEntity)player);
            Registry drinks = this.registryAccess().registryOrThrow(TropicraftRegistries.DRINK);
            ItemStack cocktailItem = drinks.getRandom(this.random).map(CocktailItem::makeDrink).orElse(ItemStack.EMPTY);
            if (itemStack.isEmpty()) {
                player.setItemInHand(hand, cocktailItem);
            } else if (!player.getInventory().add(cocktailItem)) {
                player.drop(cocktailItem, false);
            }
            this.playSound(SoundEvents.MOOSHROOM_MILK_SUSPICIOUSLY, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("Type", this.getCowktailType().name);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setCowktailType(Type.getTypeByName(compound.getString("Type")));
    }

    private void setCowktailType(Type typeIn) {
        this.entityData.set(COWKTAIL_TYPE, (Object)typeIn.name);
    }

    public Type getCowktailType() {
        return Type.getTypeByName((String)this.entityData.get(COWKTAIL_TYPE));
    }

    public CowktailEntity getBreedOffspring(ServerLevel world, AgeableMob ageable) {
        CowktailEntity child = (CowktailEntity)((EntityType)TropicraftEntities.COWKTAIL.get()).create(this.level());
        child.setCowktailType(this.getOffspringType((CowktailEntity)ageable));
        return child;
    }

    private Type getOffspringType(CowktailEntity cowktail) {
        Type CowktailEntity$type1;
        Type CowktailEntity$type = this.getCowktailType();
        Type CowktailEntity$type2 = CowktailEntity$type == (CowktailEntity$type1 = cowktail.getCowktailType()) && this.random.nextInt(1024) == 0 ? Type.getRandomType(this.random) : (this.random.nextBoolean() ? CowktailEntity$type : CowktailEntity$type1);
        return CowktailEntity$type2;
    }

    public boolean isShearable(@Nullable Player player, ItemStack item, Level level, BlockPos pos) {
        return !this.isBaby();
    }

    public List<ItemStack> onSheared(@Nullable Player player, ItemStack item, Level level, BlockPos pos) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION, this.getX(), this.getY(0.5), this.getZ(), 0.0, 0.0, 0.0);
        if (!this.level().isClientSide) {
            this.remove(Entity.RemovalReason.DISCARDED);
            Cow cowentity = (Cow)EntityType.COW.create(this.level());
            cowentity.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), this.getXRot());
            cowentity.setHealth(this.getHealth());
            cowentity.yBodyRot = this.yBodyRot;
            if (this.hasCustomName()) {
                cowentity.setCustomName(this.getCustomName());
                cowentity.setCustomNameVisible(this.isCustomNameVisible());
            }
            this.level().addFreshEntity((Entity)cowentity);
            for (int i = 0; i < 5; ++i) {
                ret.add(new ItemStack((ItemLike)this.getCowktailType().renderState.getBlock()));
            }
            this.playSound(SoundEvents.MOOSHROOM_SHEAR, 1.0f, 1.0f);
        }
        return ret;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficultyInstance, MobSpawnType spawnReason, @Nullable SpawnGroupData data) {
        this.setCowktailType(Type.getRandomType(this.random));
        return super.finalizeSpawn(world, difficultyInstance, spawnReason, data);
    }

    public static enum Type {
        IRIS("iris", (BlockState)((TallFlowerBlock)TropicraftBlocks.IRIS.get()).defaultBlockState().setValue((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER)),
        ANEMONE("anemone", ((TropicsFlowerBlock)((Object)TropicraftBlocks.FLOWERS.get(TropicraftFlower.ANEMONE).get())).defaultBlockState());

        private final String name;
        private final BlockState renderState;

        private Type(String nameIn, BlockState renderStateIn) {
            this.name = nameIn;
            this.renderState = renderStateIn;
        }

        public static Type getRandomType(RandomSource rand) {
            return (Type)((Object)Util.getRandom((Object[])Type.values(), (RandomSource)rand));
        }

        @OnlyIn(value=Dist.CLIENT)
        public BlockState getRenderState() {
            return this.renderState;
        }

        private static Type getTypeByName(String nameIn) {
            for (Type CowktailEntity$type : Type.values()) {
                if (!CowktailEntity$type.name.equals(nameIn)) continue;
                return CowktailEntity$type;
            }
            return IRIS;
        }
    }
}

