/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.neutral;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.tropicraft.core.common.entity.TropicraftEntities;
import net.tropicraft.core.common.entity.projectile.PoisonBlotEntity;
import net.tropicraft.core.common.sound.Sounds;

public class TreeFrogEntity
extends PathfinderMob
implements Enemy,
RangedAttackMob {
    private static final EntityDataAccessor<Integer> TYPE = SynchedEntityData.defineId(TreeFrogEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    @Nullable
    private NearestAttackableTargetGoal<Player> hostileAI;
    public int jumpDelay = 0;
    private int attackTime;

    public TreeFrogEntity(EntityType<? extends PathfinderMob> type, Level world) {
        super(type, world);
        this.xpReward = 5;
    }

    public boolean removeWhenFarAway(double pDistanceToClosestPlayer) {
        return false;
    }

    public void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 60, 10.0f));
        this.goalSelector.addGoal(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return PathfinderMob.createMobAttributes().add(Attributes.MAX_HEALTH, 5.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        if (!(this.getNavigation().isDone() && this.getTarget() == null || !this.onGround() && !this.isInWater())) {
            if (this.jumpDelay > 0) {
                --this.jumpDelay;
            }
            if (this.jumpDelay <= 0) {
                this.jumpDelay = 5 + this.random.nextInt(4);
                Vec3 motion = this.getDeltaMovement();
                double speed = Math.sqrt(motion.x * motion.x + motion.z * motion.z);
                if (speed > 0.02) {
                    double motionY = motion.y + 0.4;
                    double motionX = motion.x * 1.1;
                    double motionZ = motion.z * 1.1;
                    this.setDeltaMovement(motionX, motionY, motionZ);
                }
            }
        }
        if (this.attackTime > 0) {
            --this.attackTime;
        }
    }

    public void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TYPE, (Object)0);
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putInt("Type", this.getFrogType());
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.setFrogType(nbt.getInt("Type"));
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData) {
        int type = this.random.nextInt(Type.values().length);
        this.setFrogType(type);
        if (type != 0) {
            this.hostileAI = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
            this.targetSelector.addGoal(1, this.hostileAI);
        }
        return super.finalizeSpawn(world, difficulty, reason, spawnData);
    }

    public void setFrogType(int i) {
        this.entityData.set(TYPE, (Object)i);
    }

    public int getFrogType() {
        return (Integer)this.entityData.get(TYPE);
    }

    public String getColor() {
        return Type.values()[this.getFrogType()].getColor();
    }

    public void performRangedAttack(LivingEntity entity, float dist) {
        if (dist < 4.0f && !this.level().isClientSide && this.attackTime == 0 && this.level().getDifficulty() != Difficulty.PEACEFUL) {
            double d = entity.getX() - this.getX();
            double d1 = entity.getZ() - this.getZ();
            PoisonBlotEntity poison = new PoisonBlotEntity((EntityType<? extends ThrowableProjectile>)((EntityType)TropicraftEntities.POISON_BLOT.get()), (LivingEntity)this, this.level());
            poison.setPos(poison.getX(), poison.getY() + (double)1.4f, poison.getZ());
            double shotHeight = entity.getY() + (double)entity.getEyeHeight() - (double)0.2f - poison.getY();
            float f1 = Mth.sqrt((float)((float)(d * d + d1 * d1))) * 0.2f;
            entity.getCommandSenderWorld().playSound(null, entity.blockPosition(), (SoundEvent)Sounds.FROG_SPIT.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            this.level().addFreshEntity((Entity)poison);
            poison.shoot(d, shotHeight + (double)f1, d1, 0.6f, 12.0f);
            this.attackTime = 50;
            this.setYRot((float)(Math.atan2(d1, d) * 180.0 / Math.PI) - 90.0f);
        }
    }

    public static enum Type {
        GREEN("green"),
        RED("red"),
        BLUE("blue"),
        YELLOW("yellow");

        final String color;

        private Type(String s) {
            this.color = s;
        }

        public String getColor() {
            return this.color;
        }
    }
}

