/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.hostile;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.tropicraft.core.common.entity.TropicraftEntities;
import net.tropicraft.core.common.entity.ai.ashen.AIAshenChaseAndPickupLostMask;
import net.tropicraft.core.common.entity.ai.ashen.AIAshenShootDart;
import net.tropicraft.core.common.entity.ai.ashen.EntityAIMeleeAndRangedAttack;
import net.tropicraft.core.common.entity.passive.EntityKoaBase;
import net.tropicraft.core.common.entity.placeable.AshenMaskEntity;
import net.tropicraft.core.common.item.AshenMaskItem;
import net.tropicraft.core.common.item.AshenMasks;
import net.tropicraft.core.common.item.BlowGunItem;
import net.tropicraft.core.common.item.TropicraftItems;

public class AshenEntity
extends PathfinderMob
implements RangedAttackMob {
    private static final EntityDataAccessor<Byte> MASK_TYPE = SynchedEntityData.defineId(AshenEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Byte> ACTION_STATE = SynchedEntityData.defineId(AshenEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    @Nullable
    public AshenMaskEntity maskToTrack;

    public AshenEntity(EntityType<? extends PathfinderMob> type, Level world) {
        super(type, world);
        this.setActionState(AshenState.HOSTILE);
    }

    public HumanoidArm getMainArm() {
        return HumanoidArm.RIGHT;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData) {
        this.setItemInHand(InteractionHand.OFF_HAND, new ItemStack((ItemLike)TropicraftItems.BLOW_GUN.get()));
        this.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)TropicraftItems.DAGGER.get()));
        this.setMaskType((byte)AshenMasks.VALUES[world.getRandom().nextInt(AshenMasks.VALUES.length)].ordinal());
        this.setActionState(AshenState.HOSTILE);
        return super.finalizeSpawn(world, difficulty, reason, spawnData);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(MASK_TYPE, (Object)0);
        builder.define(ACTION_STATE, (Object)((byte)AshenState.HOSTILE.ordinal()));
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new AIAshenChaseAndPickupLostMask(this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new AIAshenShootDart(this));
        this.goalSelector.addGoal(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new EntityAIMeleeAndRangedAttack(this, 1.0, 40, 200, 5.0f));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, EntityKoaBase.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return PathfinderMob.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.35).add(Attributes.ATTACK_DAMAGE, 3.0);
    }

    public boolean hasMask() {
        return this.getActionState() != AshenState.LOST_MASK;
    }

    public void setMaskType(byte type) {
        this.getEntityData().set(MASK_TYPE, (Object)type);
    }

    public byte getMaskType() {
        return (Byte)this.getEntityData().get(MASK_TYPE);
    }

    public void setActionState(AshenState state) {
        this.getEntityData().set(ACTION_STATE, (Object)((byte)state.ordinal()));
    }

    public AshenState getActionState() {
        return AshenState.VALUES[this.getActionStateValue()];
    }

    private byte getActionStateValue() {
        return (Byte)this.getEntityData().get(ACTION_STATE);
    }

    public void performRangedAttack(LivingEntity target, float velocity) {
        ItemStack headGear = target.getItemBySlot(EquipmentSlot.HEAD);
        if (headGear.getItem() instanceof AshenMaskItem) {
            return;
        }
        Arrow tippedArrow = BlowGunItem.createArrow(this.level(), (LivingEntity)this, BlowGunItem.getProjectile(), new ItemStack((ItemLike)TropicraftItems.BLOW_GUN.get()));
        double d0 = target.getX() - this.getX();
        double d1 = target.getBoundingBox().minY + (double)(target.getBbHeight() / 3.0f) - tippedArrow.getY();
        double d2 = target.getZ() - this.getZ();
        double d3 = Mth.sqrt((float)((float)(d0 * d0 + d2 * d2)));
        tippedArrow.shoot(d0, d1 + d3 * (double)0.2f, d2, 1.6f, velocity);
        tippedArrow.setBaseDamage(1.0);
        this.playSound(SoundEvents.CROSSBOW_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        this.level().addFreshEntity((Entity)tippedArrow);
    }

    public boolean hurt(DamageSource source, float amt) {
        boolean wasHit = super.hurt(source, amt);
        if (!this.level().isClientSide && this.hasMask() && wasHit && !source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            this.dropMask();
        }
        return wasHit;
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putByte("MaskType", this.getMaskType());
        nbt.putByte("ActionState", this.getActionStateValue());
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.setMaskType(nbt.getByte("MaskType"));
        this.setActionState(AshenState.VALUES[nbt.getByte("ActionState")]);
    }

    public void dropMask() {
        this.setActionState(AshenState.LOST_MASK);
        this.maskToTrack = new AshenMaskEntity((EntityType)TropicraftEntities.ASHEN_MASK.get(), this.level());
        this.maskToTrack.setMaskType(this.getMaskType());
        this.maskToTrack.absMoveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
        this.level().addFreshEntity((Entity)this.maskToTrack);
    }

    public void pickupMask(AshenMaskEntity mask) {
        this.setActionState(AshenState.HOSTILE);
        this.maskToTrack = null;
        this.setMaskType(mask.getMaskType());
        mask.remove(Entity.RemovalReason.DISCARDED);
    }

    public static enum AshenState {
        PEACEFUL,
        LOST_MASK,
        HOSTILE;

        public static final AshenState[] VALUES;

        static {
            VALUES = AshenState.values();
        }
    }
}

