/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.egg;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.tropicraft.core.common.entity.TropicraftEntities;
import net.tropicraft.core.common.entity.egg.EggEntity;
import net.tropicraft.core.common.entity.hostile.TropiSpiderEntity;
import net.tropicraft.core.common.item.TropicraftItems;

public class TropiSpiderEggEntity
extends EggEntity {
    protected static final EntityDataAccessor<Optional<UUID>> MOTHER_UNIQUE_ID = SynchedEntityData.defineId(TropiSpiderEggEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);

    public TropiSpiderEggEntity(EntityType<? extends EggEntity> type, Level world) {
        super(type, world);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(MOTHER_UNIQUE_ID, Optional.empty());
    }

    @Nullable
    public UUID getMotherId() {
        return ((Optional)this.entityData.get(MOTHER_UNIQUE_ID)).orElse(null);
    }

    public void setMotherId(@Nullable UUID uuid) {
        this.entityData.set(MOTHER_UNIQUE_ID, Optional.ofNullable(uuid));
    }

    @Override
    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        if (this.getMotherId() == null) {
            nbt.putString("MotherUUID", "");
        } else {
            nbt.putString("MotherUUID", this.getMotherId().toString());
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        String motherUUID = "";
        if (nbt.contains("MotherUUID", 8)) {
            motherUUID = nbt.getString("MotherUUID");
        }
        if (!motherUUID.isEmpty()) {
            this.setMotherId(UUID.fromString(motherUUID));
        }
    }

    @Override
    public boolean shouldEggRenderFlat() {
        return false;
    }

    @Override
    public String getEggTexture() {
        return "spideregg";
    }

    @Override
    public Entity onHatch() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            Entity e;
            ServerLevel serverWorld = (ServerLevel)level;
            if (this.getMotherId() != null && (e = serverWorld.getEntity(this.getMotherId())) instanceof TropiSpiderEntity) {
                return TropiSpiderEntity.haveBaby((TropiSpiderEntity)e);
            }
        }
        return ((EntityType)TropicraftEntities.TROPI_SPIDER.get()).create(this.level());
    }

    @Override
    public int getHatchTime() {
        return 2000;
    }

    @Override
    public int getPreHatchMovement() {
        return 20;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)TropicraftItems.TROPI_SPIDER_SPAWN_EGG.get());
    }
}

