/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.ai.vmonkey;

import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.tropicraft.core.common.drinks.TropicraftDrinks;
import net.tropicraft.core.common.entity.neutral.VMonkeyEntity;
import net.tropicraft.core.common.item.CocktailItem;

public class MonkeyStealDrinkGoal
extends Goal {
    private final VMonkeyEntity entity;

    public MonkeyStealDrinkGoal(VMonkeyEntity monkey) {
        this.entity = monkey;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    public boolean canContinueToUse() {
        return this.entity.getOwner() == null && VMonkeyEntity.FOLLOW_PREDICATE.test((Object)this.entity.getFollowing()) && !this.entity.selfHoldingDrink(TropicraftDrinks.PINA_COLADA);
    }

    public boolean canUse() {
        return this.entity.getOwner() == null && VMonkeyEntity.FOLLOW_PREDICATE.test((Object)this.entity.getFollowing()) && !this.entity.selfHoldingDrink(TropicraftDrinks.PINA_COLADA) && this.entity.isAggressive();
    }

    private void leapTowardTarget() {
        LivingEntity leapTarget = this.entity.getTarget();
        if (leapTarget == null) {
            return;
        }
        double d0 = leapTarget.getX() - this.entity.getX();
        double d1 = leapTarget.getZ() - this.entity.getZ();
        float f = Mth.sqrt((float)((float)(d0 * d0 + d1 * d1)));
        Vec3 motion = this.entity.getDeltaMovement();
        if ((double)f >= 1.0E-4) {
            this.entity.setDeltaMovement(motion.add(d0 / (double)f * 0.5 * (double)0.8f + motion.x * (double)0.2f, 0.0, d1 / (double)f * 0.5 * (double)0.8f + motion.z * (double)0.2f));
        }
        this.entity.setDeltaMovement(new Vec3(motion.x, 0.25, motion.z));
    }

    public void tick() {
        if (this.entity.distanceToSqr((Entity)this.entity.getFollowing()) < 4.0) {
            for (InteractionHand hand : InteractionHand.values()) {
                ItemStack heldItem = this.entity.getFollowing().getItemInHand(hand);
                if (!CocktailItem.hasDrink(heldItem, TropicraftDrinks.PINA_COLADA)) continue;
                this.leapTowardTarget();
                this.entity.setItemInHand(hand, heldItem.split(heldItem.getCount()));
                this.entity.getFollowing().setItemInHand(hand, ItemStack.EMPTY);
            }
        }
    }
}

