/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.ai.vmonkey;

import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.PathType;
import net.tropicraft.core.common.drinks.TropicraftDrinks;
import net.tropicraft.core.common.entity.neutral.VMonkeyEntity;

public class MonkeyFollowNearestPinaColadaHolderGoal
extends Goal {
    private final VMonkeyEntity monkey;
    private final float areaSize;
    private final double speedModifier;
    private final PathNavigation navigation;
    private int timeToRecalcPath;
    private final float stopDistance;
    private float oldWaterCost;

    public MonkeyFollowNearestPinaColadaHolderGoal(VMonkeyEntity entity, double speedModifier, float stopDistance, float areaSize) {
        this.monkey = entity;
        this.speedModifier = speedModifier;
        this.stopDistance = stopDistance;
        this.areaSize = areaSize;
        this.navigation = this.monkey.getNavigation();
    }

    public boolean canUse() {
        if (this.monkey.isOrderedToSit()) {
            return false;
        }
        if (this.monkey.isTame()) {
            return false;
        }
        if (this.monkey.selfHoldingDrink(TropicraftDrinks.PINA_COLADA)) {
            return false;
        }
        List list = this.monkey.level().getEntitiesOfClass(Player.class, this.monkey.getBoundingBox().inflate((double)this.areaSize), VMonkeyEntity.FOLLOW_PREDICATE);
        if (!list.isEmpty()) {
            for (Player entityliving : list) {
                if (entityliving.isInvisible()) continue;
                this.monkey.setFollowing((LivingEntity)entityliving);
                return true;
            }
        }
        return false;
    }

    public boolean canContinueToUse() {
        if (this.monkey.getFollowing() == null) {
            return false;
        }
        return VMonkeyEntity.FOLLOW_PREDICATE.test((Object)this.monkey.getFollowing()) && this.canUse() && !this.navigation.isDone() && this.monkey.distanceToSqr((Entity)this.monkey.getFollowing()) > (double)(this.stopDistance * this.stopDistance);
    }

    public void start() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.monkey.getPathfindingMalus(PathType.WATER);
        this.monkey.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    public void stop() {
        this.monkey.setFollowing(null);
        this.navigation.stop();
        this.monkey.setPathfindingMalus(PathType.WATER, this.oldWaterCost);
    }

    public void tick() {
        LivingEntity following = this.monkey.getFollowing();
        if (following != null && !this.monkey.isLeashed()) {
            this.monkey.getLookControl().setLookAt((Entity)following, 10.0f, (float)this.monkey.getMaxHeadXRot());
            if (--this.timeToRecalcPath <= 0) {
                double zDist;
                double yDist;
                this.timeToRecalcPath = 10;
                double xDist = this.monkey.getX() - following.getX();
                double sqrDist = xDist * xDist + (yDist = this.monkey.getY() - following.getY()) * yDist + (zDist = this.monkey.getZ() - following.getZ()) * zDist;
                if (sqrDist > (double)(this.stopDistance * this.stopDistance)) {
                    this.navigation.moveTo((Entity)following, this.speedModifier);
                } else {
                    this.navigation.stop();
                    if (sqrDist <= (double)this.stopDistance) {
                        double xDist2 = following.getX() - this.monkey.getX();
                        double zDist2 = following.getZ() - this.monkey.getZ();
                        this.navigation.moveTo(this.monkey.getX() - xDist2, this.monkey.getY(), this.monkey.getZ() - zDist2, this.speedModifier);
                    }
                }
            }
        }
    }
}

