/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.ai.fishies;

import java.util.EnumSet;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ai.goal.Goal;
import net.tropicraft.core.common.entity.underdasea.TropicraftFishEntity;

public class RandomSwimGoal
extends Goal {
    public final TropicraftFishEntity entity;
    public final RandomSource rand;

    public RandomSwimGoal(EnumSet<Goal.Flag> flags, TropicraftFishEntity entityObjIn) {
        this.entity = entityObjIn;
        this.rand = this.entity.getRandom();
        this.setFlags(flags);
    }

    public boolean canUse() {
        return this.entity.isInWater() && this.entity.tickCount % 10 + this.rand.nextInt(20) == 0;
    }

    public void tick() {
        super.tick();
        this.entity.setRandomTargetHeading();
        if (this.entity.eatenFishAmount > 0 && this.rand.nextInt(10) == 0) {
            --this.entity.eatenFishAmount;
        }
    }

    public boolean canContinueToUse() {
        return this.entity.targetVector == null;
    }
}

