/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.ai.ashen;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.item.ItemStack;
import net.tropicraft.core.common.entity.hostile.AshenEntity;
import net.tropicraft.core.common.item.AshenMaskItem;

public class EntityAIMeleeAndRangedAttack
extends Goal {
    private final AshenEntity entityHost;
    private final RangedAttackMob rangedAttackEntityHost;
    @Nullable
    private LivingEntity attackTarget;
    private int rangedAttackTime = -1;
    private final double entityMoveSpeed;
    private int seeTime;
    private final int maxMeleeAttackTime;
    private final int maxRangedAttackTime;
    private final float shootCutoffRange;
    private final float shootCutoffRangeSqr;
    private float meleeHitRange = 2.0f;

    public EntityAIMeleeAndRangedAttack(AshenEntity attacker, double movespeed, int maxMeleeAttackTime, int maxRangedAttackTime, float maxAttackDistanceIn) {
        this(attacker, movespeed, maxMeleeAttackTime, maxRangedAttackTime, maxAttackDistanceIn, 2.0f);
    }

    public EntityAIMeleeAndRangedAttack(AshenEntity attacker, double movespeed, int maxMeleeAttackTime, int maxRangedAttackTime, float maxAttackDistanceIn, float meleeHitRange) {
        this.rangedAttackEntityHost = attacker;
        this.entityHost = attacker;
        this.entityMoveSpeed = movespeed;
        this.maxMeleeAttackTime = maxMeleeAttackTime;
        this.maxRangedAttackTime = maxRangedAttackTime;
        this.shootCutoffRange = maxAttackDistanceIn;
        this.shootCutoffRangeSqr = maxAttackDistanceIn * maxAttackDistanceIn;
        this.meleeHitRange = meleeHitRange;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        LivingEntity entitylivingbase = this.entityHost.getLastHurtByMob();
        if (entitylivingbase == null) {
            return false;
        }
        this.attackTarget = entitylivingbase;
        return true;
    }

    public boolean canContinueToUse() {
        return this.canUse() || !this.entityHost.getNavigation().isDone();
    }

    public void stop() {
        this.attackTarget = null;
        this.seeTime = 0;
        this.rangedAttackTime = -1;
    }

    public void tick() {
        ItemStack headGear;
        if (this.attackTarget != null && (headGear = this.attackTarget.getItemBySlot(EquipmentSlot.HEAD)).getItem() instanceof AshenMaskItem) {
            return;
        }
        double d0 = this.entityHost.distanceToSqr(this.attackTarget.getX(), this.attackTarget.getBoundingBox().minY, this.attackTarget.getZ());
        boolean flag = this.entityHost.getSensing().hasLineOfSight((Entity)this.attackTarget);
        this.seeTime = flag ? ++this.seeTime : 0;
        if (!(d0 <= (double)this.shootCutoffRangeSqr) || this.seeTime >= 20) {
            // empty if block
        }
        if (this.seeTime >= 20) {
            this.entityHost.getNavigation().moveTo((Entity)this.attackTarget, this.entityMoveSpeed);
        }
        this.entityHost.getLookControl().setLookAt((Entity)this.attackTarget, 30.0f, 30.0f);
        if (--this.rangedAttackTime <= 0) {
            float f;
            float f1 = f = Mth.sqrt((float)((float)d0)) / this.shootCutoffRange;
            if (f < 0.1f) {
                f1 = 0.1f;
            }
            if (f1 > 1.0f) {
                f1 = 1.0f;
            }
            if (d0 >= (double)this.shootCutoffRange * (double)this.shootCutoffRange) {
                this.rangedAttackEntityHost.performRangedAttack(this.attackTarget, f1);
                this.rangedAttackTime = this.maxRangedAttackTime;
            } else if (d0 <= (double)(this.meleeHitRange * this.meleeHitRange)) {
                this.entityHost.doHurtTarget((Entity)this.attackTarget);
                this.entityHost.swing(InteractionHand.MAIN_HAND);
                this.rangedAttackTime = this.maxMeleeAttackTime;
            }
        }
    }
}

