/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.ai.ashen;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;
import net.tropicraft.core.common.entity.hostile.AshenEntity;

public class AIAshenChaseAndPickupLostMask
extends Goal {
    public final AshenEntity ashen;
    @Nullable
    public LivingEntity target;
    public double speed = 1.0;
    public final double maskGrabDistance = 3.0;
    public int panicTime = 0;

    public AIAshenChaseAndPickupLostMask(AshenEntity ashen, double speed) {
        this.ashen = ashen;
        this.speed = speed;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        return !this.ashen.hasMask() && this.ashen.maskToTrack != null;
    }

    public boolean canContinueToUse() {
        return !this.ashen.hasMask() && this.ashen.maskToTrack != null && this.ashen.maskToTrack.isAlive();
    }

    public void tick() {
        if (this.panicTime > 0) {
            Vec3 vec3;
            --this.panicTime;
            if (this.ashen.level().getGameTime() % 10L == 0L && (vec3 = DefaultRandomPos.getPos((PathfinderMob)this.ashen, (int)10, (int)7)) != null) {
                this.ashen.getNavigation().moveTo(vec3.x, vec3.y, vec3.z, this.speed);
            }
        } else if (this.ashen.distanceToSqr(this.ashen.maskToTrack) <= 3.0) {
            if (this.ashen.maskToTrack.isAlive()) {
                this.ashen.pickupMask(this.ashen.maskToTrack);
            } else {
                this.ashen.maskToTrack = null;
            }
        } else if (this.ashen.level().getGameTime() % 40L == 0L) {
            this.ashen.getNavigation().moveTo(this.ashen.maskToTrack.getX(), this.ashen.maskToTrack.getY(), this.ashen.maskToTrack.getZ(), this.speed);
        }
    }

    public void start() {
        super.start();
        this.panicTime = 120;
    }

    public void stop() {
        this.target = null;
    }
}

