/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.ai;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.tropicraft.core.common.entity.passive.TropiCreeperEntity;

public class TropiCreeperSwellGoal
extends Goal {
    private final TropiCreeperEntity creeper;
    @Nullable
    private LivingEntity target;

    public TropiCreeperSwellGoal(TropiCreeperEntity creeper) {
        this.creeper = creeper;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        LivingEntity lvt_1_1_ = this.creeper.getTarget();
        return this.creeper.getCreeperState() > 0 || lvt_1_1_ != null && this.creeper.distanceToSqr((Entity)lvt_1_1_) < 9.0;
    }

    public void start() {
        this.creeper.getNavigation().stop();
        this.target = this.creeper.getTarget();
    }

    public void stop() {
        this.target = null;
    }

    public void tick() {
        if (this.target == null) {
            this.creeper.setCreeperState(-1);
        } else if (this.creeper.distanceToSqr((Entity)this.target) > 49.0) {
            this.creeper.setCreeperState(-1);
        } else if (!this.creeper.getSensing().hasLineOfSight((Entity)this.target)) {
            this.creeper.setCreeperState(-1);
        } else {
            this.creeper.setCreeperState(1);
        }
    }
}

