/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.ai;

import com.tterrag.registrate.util.entry.ItemEntry;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.tropicraft.core.common.entity.passive.EntityKoaBase;

public class EntityAITemptHelmet
extends Goal {
    private final PathfinderMob temptedEntity;
    private final double speed;
    private double targetX;
    private double targetY;
    private double targetZ;
    private double pitch;
    private double yaw;
    @Nullable
    private Player temptingPlayer;
    private int delayTemptCounter;
    private boolean isRunning;
    private final Set<ItemEntry<? extends Item>> temptItem;
    private final boolean scaredByPlayerMovement;

    public EntityAITemptHelmet(PathfinderMob temptedEntityIn, double speedIn, ItemEntry<? extends Item> temptItemIn, boolean scaredByPlayerMovementIn) {
        this(temptedEntityIn, speedIn, scaredByPlayerMovementIn, Set.of(temptItemIn));
    }

    public EntityAITemptHelmet(PathfinderMob temptedEntityIn, double speedIn, boolean scaredByPlayerMovementIn, Set<ItemEntry<? extends Item>> temptItemIn) {
        this.temptedEntity = temptedEntityIn;
        this.speed = speedIn;
        this.temptItem = temptItemIn;
        this.scaredByPlayerMovement = scaredByPlayerMovementIn;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(temptedEntityIn.getNavigation() instanceof GroundPathNavigation)) {
            throw new IllegalArgumentException("Unsupported mob type for TemptGoal");
        }
    }

    public boolean canUse() {
        if (this.temptedEntity instanceof EntityKoaBase && ((EntityKoaBase)this.temptedEntity).druggedTime <= 0) {
            return false;
        }
        if (this.delayTemptCounter > 0) {
            --this.delayTemptCounter;
            return false;
        }
        this.temptingPlayer = this.temptedEntity.level().getNearestPlayer((Entity)this.temptedEntity, 10.0);
        if (this.temptingPlayer == null) {
            return false;
        }
        return this.isTempting((ItemStack)this.temptingPlayer.getInventory().armor.get(3));
    }

    protected boolean isTempting(ItemStack stack) {
        for (ItemEntry<? extends Item> items : this.temptItem) {
            if (!items.isBound() || ((Item)items.get()).asItem() != stack.getItem()) continue;
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        if (this.scaredByPlayerMovement) {
            if (this.temptedEntity.distanceToSqr((Entity)this.temptingPlayer) < 36.0) {
                if (this.temptingPlayer.distanceToSqr(this.targetX, this.targetY, this.targetZ) > 0.010000000000000002) {
                    return false;
                }
                if (Math.abs((double)this.temptingPlayer.getXRot() - this.pitch) > 5.0 || Math.abs((double)this.temptingPlayer.getYRot() - this.yaw) > 5.0) {
                    return false;
                }
            } else {
                this.targetX = this.temptingPlayer.getX();
                this.targetY = this.temptingPlayer.getY();
                this.targetZ = this.temptingPlayer.getZ();
            }
            this.pitch = this.temptingPlayer.getXRot();
            this.yaw = this.temptingPlayer.getYRot();
        }
        return this.canUse();
    }

    public void start() {
        this.targetX = this.temptingPlayer.getX();
        this.targetY = this.temptingPlayer.getY();
        this.targetZ = this.temptingPlayer.getZ();
        this.isRunning = true;
    }

    public void stop() {
        this.temptingPlayer = null;
        this.temptedEntity.getNavigation().stop();
        this.delayTemptCounter = 100;
        this.isRunning = false;
    }

    public void tick() {
        this.temptedEntity.getLookControl().setLookAt((Entity)this.temptingPlayer, (float)(this.temptedEntity.getMaxHeadYRot() + 20), (float)this.temptedEntity.getMaxHeadXRot());
        if (this.temptedEntity.distanceToSqr((Entity)this.temptingPlayer) < 6.25) {
            this.temptedEntity.getNavigation().stop();
        } else {
            this.temptedEntity.getNavigation().moveTo((Entity)this.temptingPlayer, this.speed);
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

