/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.ai;

import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;
import net.tropicraft.core.common.entity.passive.EntityKoaBase;

public class EntityAIPlayKoa
extends Goal {
    private final EntityKoaBase villagerObj;
    @Nullable
    private LivingEntity targetVillager;
    private final double speed;
    private int playTime;

    public EntityAIPlayKoa(EntityKoaBase villagerObjIn, double speedIn) {
        this.villagerObj = villagerObjIn;
        this.speed = speedIn;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (this.villagerObj.getAge() >= 0) {
            return false;
        }
        if (this.villagerObj.getRandom().nextInt(200) != 0) {
            return false;
        }
        List list = this.villagerObj.level().getEntitiesOfClass(EntityKoaBase.class, this.villagerObj.getBoundingBox().inflate(6.0, 3.0, 6.0));
        double d0 = Double.MAX_VALUE;
        for (EntityKoaBase entityvillager : list) {
            double d1;
            if (entityvillager == this.villagerObj || entityvillager.isPlaying() || entityvillager.getAge() >= 0 || !((d1 = entityvillager.distanceToSqr((Entity)this.villagerObj)) <= d0)) continue;
            d0 = d1;
            this.targetVillager = entityvillager;
        }
        if (this.targetVillager == null) {
            Vec3 vec = DefaultRandomPos.getPos((PathfinderMob)this.villagerObj, (int)16, (int)3);
            return vec != null;
        }
        return true;
    }

    public boolean canContinueToUse() {
        return this.playTime > 0;
    }

    public void start() {
        if (this.targetVillager != null) {
            this.villagerObj.setPlaying(true);
        }
        this.playTime = 1000;
    }

    public void stop() {
        this.villagerObj.setPlaying(false);
        this.targetVillager = null;
    }

    public void tick() {
        --this.playTime;
        if (this.villagerObj.onGround() && this.villagerObj.level().random.nextInt(30) == 0) {
            this.villagerObj.getJumpControl().jump();
        }
        if (this.targetVillager != null) {
            if (this.villagerObj.distanceToSqr((Entity)this.targetVillager) > 4.0) {
                this.villagerObj.getNavigation().moveTo((Entity)this.targetVillager, this.speed);
            }
        } else if (this.villagerObj.getNavigation().isDone()) {
            Vec3 vec = DefaultRandomPos.getPos((PathfinderMob)this.villagerObj, (int)16, (int)3);
            if (vec == null) {
                return;
            }
            this.villagerObj.getNavigation().moveTo(vec.x, vec.y, vec.z, this.speed);
        }
    }
}

