/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;
import net.tropicraft.core.common.entity.TropicraftEntities;
import net.tropicraft.core.common.item.TropicraftItems;

public class BambooItemFrame
extends ItemFrame
implements IEntityWithComplexSpawn {
    public BambooItemFrame(EntityType<? extends ItemFrame> type, Level world) {
        super(type, world);
    }

    public BambooItemFrame(Level worldIn, BlockPos pos, Direction direction) {
        this((EntityType<? extends BambooItemFrame>)((EntityType)TropicraftEntities.BAMBOO_ITEM_FRAME.get()), worldIn, pos, direction);
    }

    protected BambooItemFrame(EntityType<? extends BambooItemFrame> type, Level world, BlockPos pos, Direction direction) {
        super(type, world);
        this.pos = pos;
        this.setDirection(direction);
    }

    public ItemStack getFrameItemStack() {
        return new ItemStack((ItemLike)TropicraftItems.BAMBOO_ITEM_FRAME.get());
    }

    public void writeSpawnData(RegistryFriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeByte(this.direction.get3DDataValue());
    }

    public void readSpawnData(RegistryFriendlyByteBuf additionalData) {
        this.pos = additionalData.readBlockPos();
        this.setDirection(Direction.from3DDataValue((int)additionalData.readByte()));
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)TropicraftItems.BAMBOO_ITEM_FRAME.get());
    }
}

