/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.drinks.action;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.tropicraft.core.common.dimension.TropicraftDimension;
import net.tropicraft.core.common.drinks.action.DrinkAction;

public record PortalDrinkAction(ResourceKey<Level> dimension, Optional<HolderSet<EntityType<?>>> whileRiding, int minTimeOfDay, int maxTimeOfDay) implements DrinkAction
{
    public static final MapCodec<PortalDrinkAction> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)ResourceKey.codec((ResourceKey)Registries.DIMENSION).fieldOf("dimension").forGetter(PortalDrinkAction::dimension), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.ENTITY_TYPE).optionalFieldOf("while_riding").forGetter(PortalDrinkAction::whileRiding), (App)Codec.intRange((int)0, (int)24000).fieldOf("min_time_of_day").forGetter(PortalDrinkAction::minTimeOfDay), (App)Codec.intRange((int)0, (int)24000).fieldOf("max_time_of_day").forGetter(PortalDrinkAction::maxTimeOfDay)).apply((Applicative)i, PortalDrinkAction::new));

    @Override
    public void onDrink(ServerPlayer player) {
        Entity vehicle;
        if (this.whileRiding.isPresent() && ((vehicle = player.getVehicle()) == null || !this.whileRiding.get().contains((Holder)vehicle.getType().builtInRegistryHolder()))) {
            return;
        }
        if (this.timeMatches(player.level())) {
            TropicraftDimension.teleportPlayerWithPortal(player, this.dimension);
        }
    }

    private boolean timeMatches(Level level) {
        long timeDay = level.getDayTime() % 24000L;
        return timeDay > (long)this.minTimeOfDay && timeDay < (long)this.maxTimeOfDay;
    }

    public MapCodec<PortalDrinkAction> codec() {
        return CODEC;
    }
}

