/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.noise;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseRouterData;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.common.dimension.TropicraftTerrainProvider;

public final class TropicraftNoiseRouterData {
    private static final DensityFunction BLENDING_FACTOR = DensityFunctions.constant((double)10.0);
    private static final DensityFunction BLENDING_JAGGEDNESS = DensityFunctions.zero();
    private static final ResourceKey<DensityFunction> Y = TropicraftNoiseRouterData.vanillaKey("y");
    private static final ResourceKey<DensityFunction> SHIFT_X = TropicraftNoiseRouterData.vanillaKey("shift_x");
    private static final ResourceKey<DensityFunction> SHIFT_Z = TropicraftNoiseRouterData.vanillaKey("shift_z");
    private static final ResourceKey<DensityFunction> BASE_3D_NOISE_OVERWORLD = TropicraftNoiseRouterData.vanillaKey("overworld/base_3d_noise");
    private static final ResourceKey<DensityFunction> SPAGHETTI_ROUGHNESS_FUNCTION = TropicraftNoiseRouterData.vanillaKey("overworld/caves/spaghetti_roughness_function");
    private static final ResourceKey<DensityFunction> ENTRANCES = TropicraftNoiseRouterData.vanillaKey("overworld/caves/entrances");
    private static final ResourceKey<DensityFunction> NOODLE = TropicraftNoiseRouterData.vanillaKey("overworld/caves/noodle");
    private static final ResourceKey<DensityFunction> PILLARS = TropicraftNoiseRouterData.vanillaKey("overworld/caves/pillars");
    private static final ResourceKey<DensityFunction> SPAGHETTI_2D = TropicraftNoiseRouterData.vanillaKey("overworld/caves/spaghetti_2d");
    public static final ResourceKey<DensityFunction> OFFSET = TropicraftNoiseRouterData.createKey("tropics/offset");
    public static final ResourceKey<DensityFunction> FACTOR = TropicraftNoiseRouterData.createKey("tropics/factor");
    public static final ResourceKey<DensityFunction> DEPTH = TropicraftNoiseRouterData.createKey("tropics/depth");
    public static final ResourceKey<DensityFunction> JAGGEDNESS = TropicraftNoiseRouterData.createKey("tropics/jaggedness");
    public static final ResourceKey<DensityFunction> SLOPED_CHEESE = TropicraftNoiseRouterData.createKey("tropics/sloped_cheese");

    public static void bootstrap(BootstrapContext<DensityFunction> context) {
        HolderGetter densityFunctions = context.lookup(Registries.DENSITY_FUNCTION);
        DensityFunctions.Spline.Coordinate continents = new DensityFunctions.Spline.Coordinate((Holder)densityFunctions.getOrThrow(NoiseRouterData.CONTINENTS));
        DensityFunctions.Spline.Coordinate erosion = new DensityFunctions.Spline.Coordinate((Holder)densityFunctions.getOrThrow(NoiseRouterData.EROSION));
        DensityFunctions.Spline.Coordinate ridgesFolded = new DensityFunctions.Spline.Coordinate((Holder)densityFunctions.getOrThrow(NoiseRouterData.RIDGES_FOLDED));
        DensityFunctions.Spline.Coordinate weirdness = new DensityFunctions.Spline.Coordinate((Holder)densityFunctions.getOrThrow(NoiseRouterData.RIDGES));
        Holder.Reference offset = context.register(OFFSET, (Object)TropicraftNoiseRouterData.splineWithBlending(DensityFunctions.add((DensityFunction)DensityFunctions.constant((double)-0.50375f), (DensityFunction)DensityFunctions.spline(TropicraftTerrainProvider.offset(continents, erosion, ridgesFolded))), DensityFunctions.blendOffset()));
        Holder.Reference factor = context.register(FACTOR, (Object)TropicraftNoiseRouterData.splineWithBlending(DensityFunctions.spline(TropicraftTerrainProvider.factor(continents, erosion, weirdness, ridgesFolded)), BLENDING_FACTOR));
        Holder.Reference depth = context.register(DEPTH, (Object)DensityFunctions.add((DensityFunction)DensityFunctions.yClampedGradient((int)-64, (int)320, (double)1.5, (double)-1.5), (DensityFunction)TropicraftNoiseRouterData.wrap((Holder.Reference<DensityFunction>)offset)));
        Holder.Reference jaggedness = context.register(JAGGEDNESS, (Object)TropicraftNoiseRouterData.splineWithBlending(DensityFunctions.spline(TropicraftTerrainProvider.jaggedness(continents, erosion, weirdness, ridgesFolded)), BLENDING_JAGGEDNESS));
        DensityFunction jagged = DensityFunctions.mul((DensityFunction)TropicraftNoiseRouterData.wrap((Holder.Reference<DensityFunction>)jaggedness), (DensityFunction)DensityFunctions.noise((Holder)context.lookup(Registries.NOISE).getOrThrow(Noises.JAGGED), (double)1500.0, (double)0.0).halfNegative());
        context.register(SLOPED_CHEESE, (Object)DensityFunctions.add((DensityFunction)TropicraftNoiseRouterData.noiseGradientDensity((DensityFunction)TropicraftNoiseRouterData.wrap((Holder.Reference<DensityFunction>)factor), DensityFunctions.add((DensityFunction)TropicraftNoiseRouterData.wrap((Holder.Reference<DensityFunction>)depth), (DensityFunction)jagged)), (DensityFunction)TropicraftNoiseRouterData.wrap((Holder.Reference<DensityFunction>)densityFunctions.getOrThrow(BASE_3D_NOISE_OVERWORLD))));
    }

    private static DensityFunction splineWithBlending(DensityFunction p_224454_, DensityFunction p_224455_) {
        DensityFunction densityfunction = DensityFunctions.lerp((DensityFunction)DensityFunctions.blendAlpha(), (DensityFunction)p_224455_, (DensityFunction)p_224454_);
        return DensityFunctions.flatCache((DensityFunction)DensityFunctions.cache2d((DensityFunction)densityfunction));
    }

    public static NoiseRouter tropics(HolderGetter<DensityFunction> densityFunctions, HolderGetter<NormalNoise.NoiseParameters> noiseParameters) {
        DensityFunction aquiferBarrier = DensityFunctions.noise((Holder)noiseParameters.getOrThrow(Noises.AQUIFER_BARRIER), (double)0.5);
        DensityFunction aquiferFluidLevelFloodedness = DensityFunctions.noise((Holder)noiseParameters.getOrThrow(Noises.AQUIFER_FLUID_LEVEL_FLOODEDNESS), (double)0.67);
        DensityFunction aquiferFluidLevelSpread = DensityFunctions.noise((Holder)noiseParameters.getOrThrow(Noises.AQUIFER_FLUID_LEVEL_SPREAD), (double)0.7142857142857143);
        DensityFunction aquiferLava = DensityFunctions.noise((Holder)noiseParameters.getOrThrow(Noises.AQUIFER_LAVA));
        DensityFunction shiftX = TropicraftNoiseRouterData.getFunction(densityFunctions, SHIFT_X);
        DensityFunction shiftZ = TropicraftNoiseRouterData.getFunction(densityFunctions, SHIFT_Z);
        DensityFunction temperature = DensityFunctions.shiftedNoise2d((DensityFunction)shiftX, (DensityFunction)shiftZ, (double)0.25, (Holder)noiseParameters.getOrThrow(Noises.TEMPERATURE));
        DensityFunction vegetation = DensityFunctions.shiftedNoise2d((DensityFunction)shiftX, (DensityFunction)shiftZ, (double)0.25, (Holder)noiseParameters.getOrThrow(Noises.VEGETATION));
        DensityFunction factor = TropicraftNoiseRouterData.getFunction(densityFunctions, FACTOR);
        DensityFunction depth = TropicraftNoiseRouterData.getFunction(densityFunctions, DEPTH);
        DensityFunction initialDensityWithoutJaggedness = TropicraftNoiseRouterData.noiseGradientDensity(DensityFunctions.cache2d((DensityFunction)factor), depth);
        DensityFunction slopedCheese = TropicraftNoiseRouterData.getFunction(densityFunctions, SLOPED_CHEESE);
        DensityFunction densityfunction12 = DensityFunctions.min((DensityFunction)slopedCheese, (DensityFunction)DensityFunctions.mul((DensityFunction)DensityFunctions.constant((double)5.0), (DensityFunction)TropicraftNoiseRouterData.getFunction(densityFunctions, ENTRANCES)));
        DensityFunction densityfunction13 = DensityFunctions.rangeChoice((DensityFunction)slopedCheese, (double)-1000000.0, (double)1.5625, (DensityFunction)densityfunction12, (DensityFunction)TropicraftNoiseRouterData.underground(densityFunctions, noiseParameters, slopedCheese));
        DensityFunction finalDensity = DensityFunctions.min((DensityFunction)TropicraftNoiseRouterData.postProcess(TropicraftNoiseRouterData.slideTropics(densityfunction13)), (DensityFunction)TropicraftNoiseRouterData.getFunction(densityFunctions, NOODLE));
        DensityFunction y = TropicraftNoiseRouterData.getFunction(densityFunctions, Y);
        int j = -60;
        int k = 50;
        DensityFunction veinToggle = TropicraftNoiseRouterData.yLimitedInterpolatable(y, DensityFunctions.noise((Holder)noiseParameters.getOrThrow(Noises.ORE_VEININESS), (double)1.5, (double)1.5), j, k, 0);
        DensityFunction oreVeinA = TropicraftNoiseRouterData.yLimitedInterpolatable(y, DensityFunctions.noise((Holder)noiseParameters.getOrThrow(Noises.ORE_VEIN_A), (double)4.0, (double)4.0), j, k, 0).abs();
        DensityFunction oreVeinB = TropicraftNoiseRouterData.yLimitedInterpolatable(y, DensityFunctions.noise((Holder)noiseParameters.getOrThrow(Noises.ORE_VEIN_B), (double)4.0, (double)4.0), j, k, 0).abs();
        DensityFunction veinRidged = DensityFunctions.add((DensityFunction)DensityFunctions.constant((double)-0.08f), (DensityFunction)DensityFunctions.max((DensityFunction)oreVeinA, (DensityFunction)oreVeinB));
        DensityFunction veinGap = DensityFunctions.noise((Holder)noiseParameters.getOrThrow(Noises.ORE_GAP));
        return new NoiseRouter(aquiferBarrier, aquiferFluidLevelFloodedness, aquiferFluidLevelSpread, aquiferLava, temperature, vegetation, TropicraftNoiseRouterData.getFunction(densityFunctions, (ResourceKey<DensityFunction>)NoiseRouterData.CONTINENTS), TropicraftNoiseRouterData.getFunction(densityFunctions, (ResourceKey<DensityFunction>)NoiseRouterData.EROSION), depth, TropicraftNoiseRouterData.getFunction(densityFunctions, (ResourceKey<DensityFunction>)NoiseRouterData.RIDGES), initialDensityWithoutJaggedness, finalDensity, veinToggle, veinRidged, veinGap);
    }

    private static DensityFunction postProcess(DensityFunction function) {
        DensityFunction blendedFunction = DensityFunctions.blendDensity((DensityFunction)function);
        return DensityFunctions.mul((DensityFunction)DensityFunctions.interpolated((DensityFunction)blendedFunction), (DensityFunction)DensityFunctions.constant((double)0.64)).squeeze();
    }

    private static DensityFunction slideTropics(DensityFunction function) {
        return TropicraftNoiseRouterData.slide(function, -64, 384, 80, 64, -0.078125, 0, 24, 0.1171875);
    }

    private static DensityFunction slide(DensityFunction function, int minY, int height, int topSliderLowerOffset, int topSlideUpperOffset, double topSlideTarget, int bottomSlideLowerOffset, int bottomSlideUpperOffset, double bottomSlideTarget) {
        DensityFunction topSlideFactor = DensityFunctions.yClampedGradient((int)(minY + height - topSliderLowerOffset), (int)(minY + height - topSlideUpperOffset), (double)1.0, (double)0.0);
        DensityFunction bottomSlideFactor = DensityFunctions.yClampedGradient((int)(minY + bottomSlideLowerOffset), (int)(minY + bottomSlideUpperOffset), (double)0.0, (double)1.0);
        return DensityFunctions.lerp((DensityFunction)bottomSlideFactor, (double)bottomSlideTarget, (DensityFunction)DensityFunctions.lerp((DensityFunction)topSlideFactor, (double)topSlideTarget, (DensityFunction)function));
    }

    private static DensityFunction getFunction(HolderGetter<DensityFunction> registry, ResourceKey<DensityFunction> key) {
        return TropicraftNoiseRouterData.wrap((Holder.Reference<DensityFunction>)registry.getOrThrow(key));
    }

    private static DensityFunctions.HolderHolder wrap(Holder.Reference<DensityFunction> holder) {
        return new DensityFunctions.HolderHolder(holder);
    }

    private static DensityFunction yLimitedInterpolatable(DensityFunction p_209472_, DensityFunction p_209473_, int p_209474_, int p_209475_, int p_209476_) {
        return DensityFunctions.interpolated((DensityFunction)DensityFunctions.rangeChoice((DensityFunction)p_209472_, (double)p_209474_, (double)(p_209475_ + 1), (DensityFunction)p_209473_, (DensityFunction)DensityFunctions.constant((double)p_209476_)));
    }

    private static DensityFunction noiseGradientDensity(DensityFunction p_212272_, DensityFunction p_212273_) {
        DensityFunction densityfunction = DensityFunctions.mul((DensityFunction)p_212273_, (DensityFunction)p_212272_);
        return DensityFunctions.mul((DensityFunction)DensityFunctions.constant((double)4.0), (DensityFunction)densityfunction.quarterNegative());
    }

    private static DensityFunction underground(HolderGetter<DensityFunction> densityFunctions, HolderGetter<NormalNoise.NoiseParameters> noiseParameters, DensityFunction slopedCheese) {
        DensityFunction spaghetti2d = TropicraftNoiseRouterData.getFunction(densityFunctions, SPAGHETTI_2D);
        DensityFunction spaghettiRoughness = TropicraftNoiseRouterData.getFunction(densityFunctions, SPAGHETTI_ROUGHNESS_FUNCTION);
        DensityFunction caveLayer = DensityFunctions.noise((Holder)noiseParameters.getOrThrow(Noises.CAVE_LAYER), (double)8.0);
        DensityFunction densityfunction3 = DensityFunctions.mul((DensityFunction)DensityFunctions.constant((double)4.0), (DensityFunction)caveLayer.square());
        DensityFunction caveCheese = DensityFunctions.noise((Holder)noiseParameters.getOrThrow(Noises.CAVE_CHEESE), (double)0.6666666666666666);
        DensityFunction densityfunction5 = DensityFunctions.add((DensityFunction)DensityFunctions.add((DensityFunction)DensityFunctions.constant((double)0.27), (DensityFunction)caveCheese).clamp(-1.0, 1.0), (DensityFunction)DensityFunctions.add((DensityFunction)DensityFunctions.constant((double)1.5), (DensityFunction)DensityFunctions.mul((DensityFunction)DensityFunctions.constant((double)-0.64), (DensityFunction)slopedCheese)).clamp(0.0, 0.5));
        DensityFunction densityfunction6 = DensityFunctions.add((DensityFunction)densityfunction3, (DensityFunction)densityfunction5);
        DensityFunction caves = DensityFunctions.min((DensityFunction)DensityFunctions.min((DensityFunction)densityfunction6, (DensityFunction)TropicraftNoiseRouterData.getFunction(densityFunctions, ENTRANCES)), (DensityFunction)DensityFunctions.add((DensityFunction)spaghetti2d, (DensityFunction)spaghettiRoughness));
        DensityFunction pillars = TropicraftNoiseRouterData.getFunction(densityFunctions, PILLARS);
        DensityFunction pillarsThreshold = DensityFunctions.rangeChoice((DensityFunction)pillars, (double)-1000000.0, (double)0.03, (DensityFunction)DensityFunctions.constant((double)-1000000.0), (DensityFunction)pillars);
        return DensityFunctions.max((DensityFunction)caves, (DensityFunction)pillarsThreshold);
    }

    private static ResourceKey<DensityFunction> vanillaKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.DENSITY_FUNCTION, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)name));
    }

    private static ResourceKey<DensityFunction> createKey(String name) {
        return Tropicraft.resourceKey(Registries.DENSITY_FUNCTION, name);
    }
}

