/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.tree.mangrove;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.stateproviders.RuleBasedBlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.tropicraft.core.common.Util;
import net.tropicraft.core.common.dimension.feature.tree.TropicraftTreeDecorators;

public class ReplaceInSoilDecorator
extends TreeDecorator {
    public static final MapCodec<ReplaceInSoilDecorator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("count").forGetter(c -> c.count), (App)Codec.INT.fieldOf("spread").forGetter(c -> c.spread), (App)RuleBasedBlockStateProvider.CODEC.fieldOf("state_provider").forGetter(c -> c.stateProvider), (App)BlockPredicate.CODEC.fieldOf("target").forGetter(c -> c.target)).apply((Applicative)instance, ReplaceInSoilDecorator::new));
    private final int count;
    private final int spread;
    private final RuleBasedBlockStateProvider stateProvider;
    private final BlockPredicate target;

    public ReplaceInSoilDecorator(int count, int spread, RuleBasedBlockStateProvider stateProvider, BlockPredicate target) {
        this.count = count;
        this.spread = spread;
        this.stateProvider = stateProvider;
        this.target = target;
    }

    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)TropicraftTreeDecorators.REPLACE_IN_SOIL.get();
    }

    public void place(TreeDecorator.Context context) {
        BlockPos lowestLog = Util.findLowestBlock((List<BlockPos>)context.logs());
        if (lowestLog == null) {
            return;
        }
        WorldGenLevel level = (WorldGenLevel)context.level();
        RandomSource random = context.random();
        for (int i = 0; i < this.count; ++i) {
            int x = lowestLog.getX() + random.nextInt(this.spread) - random.nextInt(this.spread);
            int z = lowestLog.getZ() + random.nextInt(this.spread) - random.nextInt(this.spread);
            int y = lowestLog.getY() - random.nextInt(this.spread);
            BlockPos pos = new BlockPos(x, y, z);
            if (!this.target.test((Object)level, (Object)pos)) continue;
            context.setBlock(pos, this.stateProvider.getState(level, random, pos));
        }
    }
}

