/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.tree.mangrove;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedRW;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.tropicraft.core.common.Util;
import net.tropicraft.core.common.dimension.feature.tree.TropicraftTreeDecorators;
import net.tropicraft.core.common.dimension.feature.tree.mangrove.MangroveTrunkPlacer;

public class PneumatophoresTreeDecorator
extends TreeDecorator {
    public static final MapCodec<PneumatophoresTreeDecorator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockStateProvider.CODEC.fieldOf("roots_block").forGetter(c -> c.rootsBlock), (App)Codec.INT.fieldOf("min_count").forGetter(c -> c.minCount), (App)Codec.INT.fieldOf("max_count").forGetter(c -> c.maxCount), (App)Codec.INT.fieldOf("spread").forGetter(c -> c.spread)).apply((Applicative)instance, PneumatophoresTreeDecorator::new));
    private final BlockStateProvider rootsBlock;
    private final int minCount;
    private final int maxCount;
    private final int spread;

    public PneumatophoresTreeDecorator(BlockStateProvider rootsBlock, int minCount, int maxCount, int spread) {
        this.rootsBlock = rootsBlock;
        this.minCount = minCount;
        this.maxCount = maxCount;
        this.spread = spread;
    }

    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)TropicraftTreeDecorators.PNEUMATOPHORES.get();
    }

    public void place(TreeDecorator.Context context) {
        BlockPos origin = Util.findLowestBlock((List<BlockPos>)context.logs());
        if (origin == null) {
            return;
        }
        LevelSimulatedReader level = context.level();
        RandomSource random = context.random();
        int spread = this.spread;
        int count = random.nextInt(this.maxCount - this.minCount + 1) + this.minCount;
        int maxTopY = origin.getY() + 3;
        int minBottomY = origin.getY() - 6;
        BlockPos.MutableBlockPos mutablePos = origin.mutable();
        while (MangroveTrunkPlacer.isWaterAt(level, (BlockPos)mutablePos) && mutablePos.getY() < maxTopY) {
            mutablePos.move(Direction.UP);
        }
        int topY = mutablePos.getY();
        for (int i = 0; i < count; ++i) {
            int y;
            int dx = random.nextInt(spread) - random.nextInt(spread);
            int dz = random.nextInt(spread) - random.nextInt(spread);
            if (dx == 0 && dz == 0) continue;
            mutablePos.setWithOffset((Vec3i)origin, dx, 0, dz);
            boolean canGenerate = false;
            int minY = minBottomY;
            for (y = topY; y >= minBottomY; --y) {
                mutablePos.setY(y);
                if (TreeFeature.validTreePos((LevelSimulatedReader)level, (BlockPos)mutablePos)) continue;
                canGenerate = true;
                minY = y;
                break;
            }
            if (!canGenerate) continue;
            y = topY;
            while (y >= minY) {
                mutablePos.setY(y--);
                MangroveTrunkPlacer.setRootsAt((LevelSimulatedRW)level, (BlockPos)mutablePos, this.rootsBlock.getState(random, (BlockPos)mutablePos));
            }
        }
    }
}

