/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.tree;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedRW;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.tropicraft.core.common.dimension.feature.TropicraftFeatureUtil;
import net.tropicraft.core.common.dimension.feature.tree.RainforestTreeFeature;
import net.tropicraft.core.common.dimension.feature.tree.TropicraftLeavesFixer;

public class UpTreeFeature
extends RainforestTreeFeature {
    public UpTreeFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel world = context.level();
        RandomSource rand = context.random();
        BlockPos pos = context.origin();
        pos = pos.immutable();
        int height = rand.nextInt(4) + 6;
        int i = pos.getX();
        int j = pos.getY();
        int k = pos.getZ();
        if (TropicraftFeatureUtil.goesBeyondWorldSize(world, pos.getY(), height)) {
            return false;
        }
        if (!TropicraftFeatureUtil.isBBAvailable(world, pos, height)) {
            return false;
        }
        if (!this.getSapling().defaultBlockState().canSurvive((LevelReader)world, pos)) {
            return false;
        }
        HashSet logs = Sets.newHashSet();
        HashSet leaves = Sets.newHashSet();
        world.setBlock(pos.below(), Blocks.DIRT.defaultBlockState(), 3);
        for (int y = j; y < j + height; ++y) {
            this.placeLog(logs, (LevelSimulatedRW)world, i, y, k);
            if (rand.nextInt(5) == 0) {
                int x = rand.nextInt(3) - 1 + i;
                int z = k;
                if (x - i == 0) {
                    z += rand.nextBoolean() ? 1 : -1;
                }
                this.setState(leaves, (LevelWriter)world, new BlockPos(x, y, z), this.getLeaf());
            }
            if (y != j + height - 1) continue;
            this.placeLog(logs, (LevelSimulatedRW)world, i + 1, y, k);
            this.placeLog(logs, (LevelSimulatedRW)world, i - 1, y, k);
            this.placeLog(logs, (LevelSimulatedRW)world, i, y, k + 1);
            this.placeLog(logs, (LevelSimulatedRW)world, i, y, k - 1);
        }
        int radius = rand.nextInt(2) + 3;
        this.genCircle(leaves, (LevelSimulatedRW)world, i, j + height, k, radius, 0.0, this.getLeaf(), false);
        this.genCircle(leaves, (LevelSimulatedRW)world, i, j + height + 1, k, radius + 2, radius, this.getLeaf(), false);
        this.genCircle(leaves, (LevelSimulatedRW)world, i, j + height + 2, k, radius + 3, radius + 2, this.getLeaf(), false);
        return TropicraftLeavesFixer.updateLeaves((LevelAccessor)world, logs, leaves, this.getLeaf());
    }
}

