/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.pools;

import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.common.dimension.feature.jigsaw.TropicraftProcessorLists;
import net.tropicraft.core.common.dimension.feature.jigsaw.piece.HomeTreeBranchPiece;
import net.tropicraft.core.common.dimension.feature.jigsaw.piece.NoRotateSingleJigsawPiece;
import net.tropicraft.core.common.dimension.feature.jigsaw.piece.SingleNoAirJigsawPiece;

public final class TropicraftTemplatePools {
    public static final ResourceKey<StructureTemplatePool> KOA_TOWN_CENTERS = TropicraftTemplatePools.createKey("koa_village/town_centers");
    public static final ResourceKey<StructureTemplatePool> KOA_HUTS = TropicraftTemplatePools.createKey("koa_village/huts");
    public static final ResourceKey<StructureTemplatePool> KOA_STREETS = TropicraftTemplatePools.createKey("koa_village/streets");
    public static final ResourceKey<StructureTemplatePool> KOA_TERMINATORS = TropicraftTemplatePools.createKey("koa_village/terminators");
    public static final ResourceKey<StructureTemplatePool> KOA_VILLAGERS = TropicraftTemplatePools.createKey("koa_village/villagers");
    public static final ResourceKey<StructureTemplatePool> KOA_FISH = TropicraftTemplatePools.createKey("koa_village/fish");
    public static final ResourceKey<StructureTemplatePool> HOME_TREE_STARTS = TropicraftTemplatePools.createKey("home_tree/starts");
    public static final ResourceKey<StructureTemplatePool> HOME_TREE_ROOFS = TropicraftTemplatePools.createKey("home_tree/roofs");
    public static final ResourceKey<StructureTemplatePool> HOME_TREE_DUMMY = TropicraftTemplatePools.createKey("home_tree/dummy");
    public static final ResourceKey<StructureTemplatePool> HOME_TREE_TRUNK_MIDDLE = TropicraftTemplatePools.createKey("home_tree/trunks/middle");
    public static final ResourceKey<StructureTemplatePool> HOME_TREE_TRUNK_TOP = TropicraftTemplatePools.createKey("home_tree/trunks/top");
    public static final ResourceKey<StructureTemplatePool> HOME_TREE_BRANCHES_SOUTH = TropicraftTemplatePools.createKey("home_tree/branches/south");
    public static final ResourceKey<StructureTemplatePool> HOME_TREE_BRANCHES_SOUTH_EAST = TropicraftTemplatePools.createKey("home_tree/branches/southeast");
    public static final ResourceKey<StructureTemplatePool> HOME_TREE_BRANCHES_EAST = TropicraftTemplatePools.createKey("home_tree/branches/east");
    public static final ResourceKey<StructureTemplatePool> HOME_TREE_BRANCHES_NORTH_EAST = TropicraftTemplatePools.createKey("home_tree/branches/northeast");
    public static final ResourceKey<StructureTemplatePool> HOME_TREE_BRANCHES_NORTH = TropicraftTemplatePools.createKey("home_tree/branches/north");
    public static final ResourceKey<StructureTemplatePool> HOME_TREE_BRANCHES_NORTH_WEST = TropicraftTemplatePools.createKey("home_tree/branches/northwest");
    public static final ResourceKey<StructureTemplatePool> HOME_TREE_BRANCHES_WEST = TropicraftTemplatePools.createKey("home_tree/branches/west");
    public static final ResourceKey<StructureTemplatePool> HOME_TREE_BRANCHES_SOUTH_WEST = TropicraftTemplatePools.createKey("home_tree/branches/southwest");

    public static void bootstrap(BootstrapContext<StructureTemplatePool> context) {
        HolderGetter processorLists = context.lookup(Registries.PROCESSOR_LIST);
        Holder.Reference koaTownCenterProcessors = processorLists.getOrThrow(TropicraftProcessorLists.KOA_TOWN_CENTERS);
        Holder.Reference koaBuildingProcessors = processorLists.getOrThrow(TropicraftProcessorLists.KOA_BUILDINGS);
        Holder.Reference koaPathProcessors = processorLists.getOrThrow(TropicraftProcessorLists.KOA_PATH);
        TropicraftTemplatePools.register(context, KOA_TOWN_CENTERS, StructureTemplatePool.Projection.RIGID, TropicraftTemplatePools.noAirSingle("koa_village/town_centers/firepit_01", (Holder<StructureProcessorList>)koaTownCenterProcessors, 1));
        TropicraftTemplatePools.register(context, KOA_HUTS, StructureTemplatePool.Projection.RIGID, TropicraftTemplatePools.noAirSingle("koa_village/huts/hut_01", (Holder<StructureProcessorList>)koaBuildingProcessors, 5), TropicraftTemplatePools.noAirSingle("koa_village/huts/hut_02", (Holder<StructureProcessorList>)koaBuildingProcessors, 2), TropicraftTemplatePools.noAirSingle("koa_village/huts/hut_03", (Holder<StructureProcessorList>)koaBuildingProcessors, 3), TropicraftTemplatePools.noAirSingle("koa_village/huts/hut_04", (Holder<StructureProcessorList>)koaBuildingProcessors, 4), TropicraftTemplatePools.noAirSingle("koa_village/huts/hut_05", (Holder<StructureProcessorList>)koaBuildingProcessors, 10), TropicraftTemplatePools.noAirSingle("koa_village/huts/bongo_hut_01", (Holder<StructureProcessorList>)koaBuildingProcessors, 2), TropicraftTemplatePools.noAirSingle("koa_village/huts/trade_hut_01", (Holder<StructureProcessorList>)koaBuildingProcessors, 2));
        Holder.Reference<StructureTemplatePool> koaTerminators = TropicraftTemplatePools.register(context, KOA_TERMINATORS, StructureTemplatePool.Projection.TERRAIN_MATCHING, TropicraftTemplatePools.koaPath("koa_village/terminators/terminator_01", 1, (Holder<StructureProcessorList>)koaPathProcessors));
        TropicraftTemplatePools.register(context, KOA_STREETS, koaTerminators, StructureTemplatePool.Projection.TERRAIN_MATCHING, new WeightedPiece[]{TropicraftTemplatePools.koaPath("koa_village/streets/straight_01", 3, (Holder<StructureProcessorList>)koaPathProcessors), TropicraftTemplatePools.koaPath("koa_village/streets/straight_02", 4, (Holder<StructureProcessorList>)koaPathProcessors), TropicraftTemplatePools.koaPath("koa_village/streets/straight_03", 10, (Holder<StructureProcessorList>)koaPathProcessors), TropicraftTemplatePools.koaPath("koa_village/streets/straight_04", 2, (Holder<StructureProcessorList>)koaPathProcessors), TropicraftTemplatePools.koaPath("koa_village/streets/straight_05", 3, (Holder<StructureProcessorList>)koaPathProcessors), TropicraftTemplatePools.koaPath("koa_village/streets/straight_06", 2, (Holder<StructureProcessorList>)koaPathProcessors), TropicraftTemplatePools.koaPath("koa_village/streets/corner_01", 2, (Holder<StructureProcessorList>)koaPathProcessors), TropicraftTemplatePools.koaPath("koa_village/streets/corner_02", 4, (Holder<StructureProcessorList>)koaPathProcessors), TropicraftTemplatePools.koaPath("koa_village/streets/corner_03", 6, (Holder<StructureProcessorList>)koaPathProcessors), TropicraftTemplatePools.koaPath("koa_village/streets/corner_04", 2, (Holder<StructureProcessorList>)koaPathProcessors), TropicraftTemplatePools.koaPath("koa_village/streets/crossroad_01", 5, (Holder<StructureProcessorList>)koaPathProcessors), TropicraftTemplatePools.koaPath("koa_village/streets/crossroad_02", 2, (Holder<StructureProcessorList>)koaPathProcessors), TropicraftTemplatePools.koaPath("koa_village/streets/crossroad_03", 1, (Holder<StructureProcessorList>)koaPathProcessors), TropicraftTemplatePools.koaPath("koa_village/streets/crossroad_04", 2, (Holder<StructureProcessorList>)koaPathProcessors)});
        TropicraftTemplatePools.register(context, KOA_VILLAGERS, StructureTemplatePool.Projection.RIGID, TropicraftTemplatePools.noAirSingle("koa_village/villagers/unemployed", 1));
        TropicraftTemplatePools.register(context, KOA_FISH, StructureTemplatePool.Projection.RIGID, TropicraftTemplatePools.noAirSingle("koa_village/fish/fish_01", 1));
        Holder.Reference homeTreeStartProcessors = processorLists.getOrThrow(TropicraftProcessorLists.HOME_TREE_START);
        Holder.Reference homeTreeBaseProcessors = processorLists.getOrThrow(TropicraftProcessorLists.HOME_TREE_BASE);
        TropicraftTemplatePools.register(context, HOME_TREE_STARTS, StructureTemplatePool.Projection.RIGID, TropicraftTemplatePools.singlePiece("home_tree/trunks/bottom/trunk_0", (Holder<StructureProcessorList>)homeTreeStartProcessors, 1), TropicraftTemplatePools.singlePiece("home_tree/trunks/bottom/trunk_1", (Holder<StructureProcessorList>)homeTreeStartProcessors, 1));
        TropicraftTemplatePools.register(context, HOME_TREE_ROOFS, StructureTemplatePool.Projection.RIGID, TropicraftTemplatePools.singlePiece("home_tree/roofs/roof_0", (Holder<StructureProcessorList>)homeTreeBaseProcessors, 1));
        TropicraftTemplatePools.register(context, HOME_TREE_DUMMY, StructureTemplatePool.Projection.RIGID, TropicraftTemplatePools.singlePiece("home_tree/dummy", (Holder<StructureProcessorList>)homeTreeBaseProcessors, 1), TropicraftTemplatePools.singlePiece("home_tree/outer_dummy", (Holder<StructureProcessorList>)homeTreeBaseProcessors, 1));
        TropicraftTemplatePools.register(context, HOME_TREE_TRUNK_MIDDLE, StructureTemplatePool.Projection.RIGID, TropicraftTemplatePools.singlePiece("home_tree/trunks/middle/trunk_0", (Holder<StructureProcessorList>)homeTreeBaseProcessors, 1), TropicraftTemplatePools.singlePiece("home_tree/trunks/middle/trunk_1", (Holder<StructureProcessorList>)homeTreeBaseProcessors, 1), TropicraftTemplatePools.singlePiece("home_tree/trunks/middle/trunk_1_iguanas", (Holder<StructureProcessorList>)homeTreeBaseProcessors, 1), TropicraftTemplatePools.singlePiece("home_tree/trunks/middle/trunk_1_ashen", (Holder<StructureProcessorList>)homeTreeBaseProcessors, 1));
        TropicraftTemplatePools.register(context, HOME_TREE_TRUNK_TOP, StructureTemplatePool.Projection.RIGID, TropicraftTemplatePools.noRotateSingle("home_tree/trunks/top/trunk_0", (Holder<StructureProcessorList>)homeTreeBaseProcessors, 1), TropicraftTemplatePools.noRotateSingle("home_tree/trunks/top/trunk_1", (Holder<StructureProcessorList>)homeTreeBaseProcessors, 1), TropicraftTemplatePools.noRotateSingle("home_tree/trunks/top/trunk_2", (Holder<StructureProcessorList>)homeTreeBaseProcessors, 1), TropicraftTemplatePools.noRotateSingle("home_tree/trunks/top/trunk_3", (Holder<StructureProcessorList>)homeTreeBaseProcessors, 1));
        TropicraftTemplatePools.register(context, HOME_TREE_BRANCHES_SOUTH, StructureTemplatePool.Projection.RIGID, TropicraftTemplatePools.homeTreeBranch(-30.0f, 30.0f, 4), TropicraftTemplatePools.homeTreeBranch(0.0f, 0.0f, 1));
        TropicraftTemplatePools.register(context, HOME_TREE_BRANCHES_SOUTH_EAST, StructureTemplatePool.Projection.RIGID, TropicraftTemplatePools.homeTreeBranch(30.0f, 60.0f, 4), TropicraftTemplatePools.homeTreeBranch(45.0f, 45.0f, 1));
        TropicraftTemplatePools.register(context, HOME_TREE_BRANCHES_EAST, StructureTemplatePool.Projection.RIGID, TropicraftTemplatePools.homeTreeBranch(60.0f, 120.0f, 4), TropicraftTemplatePools.homeTreeBranch(90.0f, 90.0f, 1));
        TropicraftTemplatePools.register(context, HOME_TREE_BRANCHES_NORTH_EAST, StructureTemplatePool.Projection.RIGID, TropicraftTemplatePools.homeTreeBranch(120.0f, 150.0f, 4), TropicraftTemplatePools.homeTreeBranch(135.0f, 135.0f, 1));
        TropicraftTemplatePools.register(context, HOME_TREE_BRANCHES_NORTH, StructureTemplatePool.Projection.RIGID, TropicraftTemplatePools.homeTreeBranch(150.0f, 210.0f, 4), TropicraftTemplatePools.homeTreeBranch(180.0f, 180.0f, 1));
        TropicraftTemplatePools.register(context, HOME_TREE_BRANCHES_NORTH_WEST, StructureTemplatePool.Projection.RIGID, TropicraftTemplatePools.homeTreeBranch(210.0f, 240.0f, 4), TropicraftTemplatePools.homeTreeBranch(225.0f, 225.0f, 1));
        TropicraftTemplatePools.register(context, HOME_TREE_BRANCHES_WEST, StructureTemplatePool.Projection.RIGID, TropicraftTemplatePools.homeTreeBranch(240.0f, 300.0f, 4), TropicraftTemplatePools.homeTreeBranch(270.0f, 270.0f, 1));
        TropicraftTemplatePools.register(context, HOME_TREE_BRANCHES_SOUTH_WEST, StructureTemplatePool.Projection.RIGID, TropicraftTemplatePools.homeTreeBranch(300.0f, 330.0f, 4), TropicraftTemplatePools.homeTreeBranch(315.0f, 315.0f, 1));
    }

    private static WeightedPiece singlePiece(String path, Holder<StructureProcessorList> processors, int weight) {
        return new WeightedPiece(() -> StructurePoolElement.single((String)("tropicraft:" + path), (Holder)processors), weight);
    }

    private static WeightedPiece noAirSingle(String path, Holder<StructureProcessorList> processors, int weight) {
        return new WeightedPiece(() -> SingleNoAirJigsawPiece.create(Tropicraft.location(path), processors, false), weight);
    }

    private static WeightedPiece noAirSingle(String path, int weight) {
        return new WeightedPiece(() -> SingleNoAirJigsawPiece.create(Tropicraft.location(path)), weight);
    }

    private static WeightedPiece noRotateSingle(String path, Holder<StructureProcessorList> processors, int weight) {
        return new WeightedPiece(() -> NoRotateSingleJigsawPiece.createNoRotate(Tropicraft.location(path), processors), weight);
    }

    private static WeightedPiece homeTreeBranch(float minAngle, float maxAngle, int weight) {
        return new WeightedPiece(() -> HomeTreeBranchPiece.create(minAngle, maxAngle), weight);
    }

    private static WeightedPiece koaPath(String path, int weight, Holder<StructureProcessorList> processorList) {
        return new WeightedPiece(() -> SingleNoAirJigsawPiece.create(Tropicraft.location(path), processorList, true), weight);
    }

    private static Holder.Reference<StructureTemplatePool> register(BootstrapContext<StructureTemplatePool> context, ResourceKey<StructureTemplatePool> key, StructureTemplatePool.Projection placementBehaviour, WeightedPiece ... pieces) {
        Holder.Reference empty = context.lookup(Registries.TEMPLATE_POOL).getOrThrow(Pools.EMPTY);
        return TropicraftTemplatePools.register(context, key, (Holder<StructureTemplatePool>)empty, placementBehaviour, pieces);
    }

    private static Holder.Reference<StructureTemplatePool> register(BootstrapContext<StructureTemplatePool> context, ResourceKey<StructureTemplatePool> key, Holder<StructureTemplatePool> fallback, StructureTemplatePool.Projection placementBehaviour, WeightedPiece ... pieces) {
        return context.register(key, (Object)new StructureTemplatePool(fallback, Arrays.stream(pieces).map(WeightedPiece::resolve).toList(), placementBehaviour));
    }

    private static ResourceKey<StructureTemplatePool> createKey(String name) {
        return Tropicraft.resourceKey(Registries.TEMPLATE_POOL, name);
    }

    private record WeightedPiece(Supplier<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>> factory, int weight) {
        public Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer> resolve() {
            return new Pair(this.factory.get(), (Object)this.weight);
        }
    }
}

