/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.jigsaw;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.dimension.feature.jigsaw.PathStructureProcessor;
import net.tropicraft.core.common.dimension.feature.jigsaw.TropicraftProcessorTypes;

public class SteepPathProcessor
extends PathStructureProcessor {
    public static final MapCodec<SteepPathProcessor> CODEC = MapCodec.unit((Object)((Object)new SteepPathProcessor()));

    public StructureTemplate.StructureBlockInfo process(LevelReader level, BlockPos seedPos, BlockPos pos2, StructureTemplate.StructureBlockInfo originalBlockInfo, StructureTemplate.StructureBlockInfo blockInfo, StructurePlaceSettings placementSettingsIn, @Nullable StructureTemplate template) {
        BlockPos pos = blockInfo.pos();
        if (originalBlockInfo.pos().getY() != 1 || originalBlockInfo.state().is(TropicraftBlocks.BAMBOO_STAIRS) || originalBlockInfo.state().isAir()) {
            return blockInfo;
        }
        Direction.Axis axis = this.getPathDirection(level, seedPos, blockInfo, placementSettingsIn, template);
        if (axis == null) {
            return blockInfo;
        }
        int bridgeTo = -1;
        BlockState ladder = null;
        for (Direction.AxisDirection axisDir : Direction.AxisDirection.values()) {
            Direction dir = Direction.get((Direction.AxisDirection)axisDir, (Direction.Axis)axis);
            BlockPos nextHeight = level.getHeightmapPos(Heightmap.Types.WORLD_SURFACE_WG, pos.relative(dir)).below();
            if (nextHeight.getY() > pos.getY()) {
                ladder = this.getLadderState(dir);
                bridgeTo = nextHeight.getY();
            }
            if (ladder != null) break;
        }
        if (ladder == null) {
            return blockInfo;
        }
        Direction dir = ((Direction)ladder.getValue((Property)LadderBlock.FACING)).getOpposite();
        if (bridgeTo == (pos = pos.above()).getY() && this.canPlaceLadderAt(level, pos.above(), dir) == null) {
            if (pos.getY() > 127) {
                this.setBlockState(level, pos, (BlockState)((StairBlock)TropicraftBlocks.THATCH_STAIRS.get()).defaultBlockState().setValue((Property)StairBlock.FACING, (Comparable)dir));
            }
        } else {
            while (bridgeTo >= pos.getY() || this.canPlaceLadderAt(level, pos, dir) != null) {
                this.setBlockState(level, pos, ladder);
                this.setBlockState(level, pos.relative(dir), ((RotatedPillarBlock)TropicraftBlocks.THATCH_BUNDLE.get()).defaultBlockState());
                pos = pos.above();
            }
        }
        return blockInfo;
    }

    @Nullable
    private BlockState canPlaceLadderAt(LevelReader level, BlockPos pos, Direction dir) {
        BlockState ladderState;
        BlockPos check = pos.relative(dir);
        BlockState state = level.getBlockState(check);
        if (!state.isAir() && (ladderState = this.getLadderState(dir)).canSurvive(level, pos)) {
            return ladderState;
        }
        return null;
    }

    private BlockState getLadderState(Direction dir) {
        return (BlockState)((LadderBlock)TropicraftBlocks.BAMBOO_LADDER.get()).defaultBlockState().setValue((Property)LadderBlock.FACING, (Comparable)dir.getOpposite());
    }

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)TropicraftProcessorTypes.STEEP_PATH.get();
    }
}

