/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.block_state_provider;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProviderType;
import net.tropicraft.core.common.dimension.feature.block_state_provider.TropicraftBlockStateProviders;

public final class NoiseFromTagBlockStateProvider
extends BlockStateProvider {
    public static final MapCodec<NoiseFromTagBlockStateProvider> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BLOCK).fieldOf("blocks").forGetter(o -> o.blocks)).apply((Applicative)i, NoiseFromTagBlockStateProvider::new));
    public final HolderSet<Block> blocks;

    public NoiseFromTagBlockStateProvider(HolderSet<Block> blocks) {
        this.blocks = blocks;
    }

    public NoiseFromTagBlockStateProvider(TagKey<Block> blocks) {
        this((HolderSet<Block>)BuiltInRegistries.BLOCK.getOrCreateTag(blocks));
    }

    protected BlockStateProviderType<?> type() {
        return (BlockStateProviderType)TropicraftBlockStateProviders.NOISE_FROM_TAG.get();
    }

    public BlockState getState(RandomSource random, BlockPos pos) {
        double noise = Biome.BIOME_INFO_NOISE.getValue((double)pos.getX() / 48.0, (double)pos.getZ() / 48.0, false);
        noise = Mth.clamp((double)((1.0 + noise) / 2.0), (double)0.0, (double)0.9999);
        Holder block = this.blocks.get(Mth.floor((double)(noise * (double)this.blocks.size())));
        return ((Block)block.value()).defaultBlockState();
    }
}

