/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.AquaticFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CarvingMaskPlacement;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightmapPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.NoiseBasedCountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.common.dimension.feature.TropicraftPlacementUtil;
import net.tropicraft.core.common.dimension.feature.TropicraftVegetationFeatures;

public final class TropicraftVegetationPlacements {
    public static final ResourceKey<PlacedFeature> RAINFOREST_VINES = TropicraftVegetationPlacements.createKey("rainforest_vines");
    public static final ResourceKey<PlacedFeature> SMALL_GOLDEN_LEATHER_FERN = TropicraftVegetationPlacements.createKey("small_golden_leather_fern");
    public static final ResourceKey<PlacedFeature> TALL_GOLDEN_LEATHER_FERN = TropicraftVegetationPlacements.createKey("tall_golden_leather_fern");
    public static final ResourceKey<PlacedFeature> HUGE_GOLDEN_LEATHER_FERN = TropicraftVegetationPlacements.createKey("huge_golden_leather_fern");
    public static final ResourceKey<PlacedFeature> OVERGROWN_SMALL_GOLDEN_LEATHER_FERN = TropicraftVegetationPlacements.createKey("overgrown_small_golden_leather_fern");
    public static final ResourceKey<PlacedFeature> OVERGROWN_TALL_GOLDEN_LEATHER_FERN = TropicraftVegetationPlacements.createKey("overgrown_tall_golden_leather_fern");
    public static final ResourceKey<PlacedFeature> OVERGROWN_HUGE_GOLDEN_LEATHER_FERN = TropicraftVegetationPlacements.createKey("overgrown_huge_golden_leather_fern");
    public static final ResourceKey<PlacedFeature> TREES_MANGROVE = TropicraftVegetationPlacements.createKey("trees_mangrove");
    public static final ResourceKey<PlacedFeature> TREES_MANGROVE_SPARSE = TropicraftVegetationPlacements.createKey("trees_mangrove_sparse");
    public static final ResourceKey<PlacedFeature> TREES_FRUIT = TropicraftVegetationPlacements.createKey("trees_fruit");
    public static final ResourceKey<PlacedFeature> TREES_PALM = TropicraftVegetationPlacements.createKey("trees_palm");
    public static final ResourceKey<PlacedFeature> TREES_PALM_OVERWORLD = TropicraftVegetationPlacements.createKey("trees_palm_overworld");
    public static final ResourceKey<PlacedFeature> TREES_RAINFOREST = TropicraftVegetationPlacements.createKey("trees_rainforest");
    public static final ResourceKey<PlacedFeature> TREES_PLEODENDRON = TropicraftVegetationPlacements.createKey("trees_pleodendron");
    public static final ResourceKey<PlacedFeature> TREES_PAPAYA = TropicraftVegetationPlacements.createKey("trees_papaya");
    public static final ResourceKey<PlacedFeature> BUSH_FLOWERING_COMMON = TropicraftVegetationPlacements.createKey("bush_flowering_common");
    public static final ResourceKey<PlacedFeature> BUSH_FLOWERING_RARE = TropicraftVegetationPlacements.createKey("bush_flowering_rare");
    public static final ResourceKey<PlacedFeature> TROPICS_GRASS = TropicraftVegetationPlacements.createKey("tropics_grass");
    public static final ResourceKey<PlacedFeature> BAMBOO = TropicraftVegetationPlacements.createKey("bamboo");
    public static final ResourceKey<PlacedFeature> TROPI_SEAGRASS = TropicraftVegetationPlacements.createKey("tropi_seagrass");
    public static final ResourceKey<PlacedFeature> PINEAPPLE = TropicraftVegetationPlacements.createKey("pineapple");
    public static final ResourceKey<PlacedFeature> PATCH_PINEAPPLE = TropicraftVegetationPlacements.createKey("patch_pineapple");
    public static final ResourceKey<PlacedFeature> FLOWERS_TROPICS = TropicraftVegetationPlacements.createKey("flowers_tropics");
    public static final ResourceKey<PlacedFeature> FLOWERS_RAINFOREST = TropicraftVegetationPlacements.createKey("flowers_rainforest");
    public static final ResourceKey<PlacedFeature> PATCH_IRIS = TropicraftVegetationPlacements.createKey("patch_iris");
    public static final ResourceKey<PlacedFeature> COFFEE_BUSH = TropicraftVegetationPlacements.createKey("coffee_bush");
    public static final ResourceKey<PlacedFeature> UNDERGROWTH = TropicraftVegetationPlacements.createKey("undergrowth");
    public static final ResourceKey<PlacedFeature> SINGLE_UNDERGROWTH = TropicraftVegetationPlacements.createKey("single_undergrowth");
    public static final ResourceKey<PlacedFeature> SEAGRASS = TropicraftVegetationPlacements.createKey("seagrass");
    public static final ResourceKey<PlacedFeature> UNDERGROUND_SEAGRASS_ON_STONE = TropicraftVegetationPlacements.createKey("underground_seagrass_on_stone");
    public static final ResourceKey<PlacedFeature> UNDERGROUND_SEAGRASS_ON_DIRT = TropicraftVegetationPlacements.createKey("underground_seagrass_on_dirt");
    public static final ResourceKey<PlacedFeature> UNDERGROUND_SEA_PICKLES = TropicraftVegetationPlacements.createKey("underground_sea_pickles");
    public static final ResourceKey<PlacedFeature> MANGROVE_REEDS = TropicraftVegetationPlacements.createKey("mangrove_reeds");
    public static final ResourceKey<PlacedFeature> KELP = TropicraftVegetationPlacements.createKey("kelp");

    public static List<PlacementModifier> worldSurfaceSquaredWithChance(int onceEvery) {
        return List.of(RarityFilter.onAverageOnceEvery((int)onceEvery), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome());
    }

    private static List<PlacementModifier> seagrassPlacement(Supplier<? extends Block> belowBlock) {
        BlockPredicateFilter seagrassPredicate = BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.allOf((BlockPredicate[])new BlockPredicate[]{BlockPredicate.matchesBlocks((Vec3i)new BlockPos(0, -1, 0), (Block[])new Block[]{belowBlock.get()}), BlockPredicate.matchesBlocks((Vec3i)BlockPos.ZERO, (Block[])new Block[]{Blocks.WATER}), BlockPredicate.matchesBlocks((Vec3i)new BlockPos(0, 1, 0), (Block[])new Block[]{Blocks.WATER})}));
        return List.of(CarvingMaskPlacement.forStep((GenerationStep.Carving)GenerationStep.Carving.LIQUID), RarityFilter.onAverageOnceEvery((int)10), seagrassPredicate, BiomeFilter.biome());
    }

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        TropicraftPlacementUtil.register(context, RAINFOREST_VINES, TropicraftVegetationFeatures.RAINFOREST_VINES, List.of(CountPlacement.of((int)50), InSquarePlacement.spread(), BiomeFilter.biome()));
        TropicraftPlacementUtil.register(context, SMALL_GOLDEN_LEATHER_FERN, TropicraftVegetationFeatures.SMALL_GOLDEN_LEATHER_FERN, List.of(RarityFilter.onAverageOnceEvery((int)4), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()));
        TropicraftPlacementUtil.register(context, TALL_GOLDEN_LEATHER_FERN, TropicraftVegetationFeatures.TALL_GOLDEN_LEATHER_FERN, List.of(RarityFilter.onAverageOnceEvery((int)8), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()));
        TropicraftPlacementUtil.register(context, HUGE_GOLDEN_LEATHER_FERN, TropicraftVegetationFeatures.HUGE_GOLDEN_LEATHER_FERN, List.of(RarityFilter.onAverageOnceEvery((int)12), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()));
        TropicraftPlacementUtil.register(context, OVERGROWN_SMALL_GOLDEN_LEATHER_FERN, TropicraftVegetationFeatures.SMALL_GOLDEN_LEATHER_FERN, List.of(RarityFilter.onAverageOnceEvery((int)2), CountPlacement.of((int)3), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()));
        TropicraftPlacementUtil.register(context, OVERGROWN_TALL_GOLDEN_LEATHER_FERN, TropicraftVegetationFeatures.TALL_GOLDEN_LEATHER_FERN, List.of(RarityFilter.onAverageOnceEvery((int)2), CountPlacement.of((int)1), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()));
        TropicraftPlacementUtil.register(context, OVERGROWN_HUGE_GOLDEN_LEATHER_FERN, TropicraftVegetationFeatures.HUGE_GOLDEN_LEATHER_FERN, List.of(RarityFilter.onAverageOnceEvery((int)90), CountPlacement.of((int)6), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()));
        TropicraftPlacementUtil.register(context, TREES_MANGROVE, TropicraftVegetationFeatures.TREES_MANGROVE, TropicraftVegetationPlacements.mangrovePlacement(7, 200.0, 1.5));
        TropicraftPlacementUtil.register(context, TREES_MANGROVE_SPARSE, TropicraftVegetationFeatures.TREES_MANGROVE, TropicraftVegetationPlacements.mangrovePlacement(3, 200.0, 1.0));
        TropicraftPlacementUtil.register(context, TREES_FRUIT, TropicraftVegetationFeatures.TREES_FRUIT, TropicraftPlacementUtil.sparseTreePlacement(0.1f));
        TropicraftPlacementUtil.register(context, TREES_PALM, TropicraftVegetationFeatures.TREES_PALM, TropicraftPlacementUtil.sparseTreePlacement(0.5f));
        TropicraftPlacementUtil.register(context, TREES_PALM_OVERWORLD, TropicraftVegetationFeatures.TREES_PALM, TropicraftPlacementUtil.sparseTreePlacement(0.1f));
        TropicraftPlacementUtil.register(context, TREES_RAINFOREST, TropicraftVegetationFeatures.TREES_RAINFOREST, TropicraftPlacementUtil.treePlacement(1, 0.5f, 1));
        TropicraftPlacementUtil.register(context, TREES_PLEODENDRON, TropicraftVegetationFeatures.TREES_PLEODENDRON, TropicraftPlacementUtil.treePlacement(0, 0.1f, 1));
        TropicraftPlacementUtil.register(context, TREES_PAPAYA, TropicraftVegetationFeatures.TREES_PAPAYA, TropicraftPlacementUtil.treePlacement(0, 0.2f, 1));
        TropicraftPlacementUtil.register(context, BUSH_FLOWERING_COMMON, TropicraftVegetationFeatures.BUSH_FLOWERING, TropicraftPlacementUtil.treePlacement(0, 0.25f, 1));
        TropicraftPlacementUtil.register(context, BUSH_FLOWERING_RARE, TropicraftVegetationFeatures.BUSH_FLOWERING, TropicraftPlacementUtil.treePlacement(0, 0.125f, 1));
        TropicraftPlacementUtil.register(context, TROPICS_GRASS, TropicraftVegetationFeatures.PATCH_GRASS_TROPICS, VegetationPlacements.worldSurfaceSquaredWithCount((int)10));
        TropicraftPlacementUtil.register(context, BAMBOO, TropicraftVegetationFeatures.BAMBOO, List.of(NoiseBasedCountPlacement.of((int)50, (double)140.0, (double)0.5), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()));
        TropicraftPlacementUtil.register(context, TROPI_SEAGRASS, TropicraftVegetationFeatures.TROPI_SEAGRASS, List.of(NoiseBasedCountPlacement.of((int)1, (double)150.0, (double)0.0), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()));
        TropicraftPlacementUtil.register(context, PINEAPPLE, TropicraftVegetationFeatures.PINEAPPLE, List.of(CountPlacement.of((int)3), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()));
        TropicraftPlacementUtil.register(context, PATCH_PINEAPPLE, TropicraftVegetationFeatures.PATCH_PINEAPPLE, List.of(RarityFilter.onAverageOnceEvery((int)6), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()));
        TropicraftPlacementUtil.register(context, FLOWERS_TROPICS, TropicraftVegetationFeatures.FLOWERS_TROPICS, List.of(RarityFilter.onAverageOnceEvery((int)2), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()));
        TropicraftPlacementUtil.register(context, FLOWERS_RAINFOREST, TropicraftVegetationFeatures.FLOWERS_RAINFOREST, List.of(RarityFilter.onAverageOnceEvery((int)6), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()));
        TropicraftPlacementUtil.register(context, PATCH_IRIS, TropicraftVegetationFeatures.PATCH_IRIS, List.of(RarityFilter.onAverageOnceEvery((int)3), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()));
        TropicraftPlacementUtil.register(context, COFFEE_BUSH, TropicraftVegetationFeatures.COFFEE_BUSH, TropicraftVegetationPlacements.worldSurfaceSquaredWithChance(25));
        TropicraftPlacementUtil.register(context, UNDERGROWTH, TropicraftVegetationFeatures.UNDERGROWTH, TropicraftVegetationPlacements.worldSurfaceSquaredWithChance(5));
        TropicraftPlacementUtil.register(context, SINGLE_UNDERGROWTH, TropicraftVegetationFeatures.SINGLE_UNDERGROWTH, VegetationPlacements.worldSurfaceSquaredWithCount((int)2));
        TropicraftPlacementUtil.register(context, SEAGRASS, TropicraftVegetationFeatures.SEAGRASS, List.of(CountPlacement.of((int)48), InSquarePlacement.spread(), HeightmapPlacement.onHeightmap((Heightmap.Types)Heightmap.Types.OCEAN_FLOOR_WG), BiomeFilter.biome()));
        TropicraftPlacementUtil.register(context, UNDERGROUND_SEAGRASS_ON_STONE, TropicraftVegetationFeatures.UNDERGROUND_SEAGRASS, TropicraftVegetationPlacements.seagrassPlacement(() -> Blocks.STONE));
        TropicraftPlacementUtil.register(context, UNDERGROUND_SEAGRASS_ON_DIRT, TropicraftVegetationFeatures.UNDERGROUND_SEAGRASS, TropicraftVegetationPlacements.seagrassPlacement(() -> Blocks.DIRT));
        TropicraftPlacementUtil.register(context, UNDERGROUND_SEA_PICKLES, TropicraftVegetationFeatures.UNDERGROUND_SEA_PICKLES, List.of(CarvingMaskPlacement.forStep((GenerationStep.Carving)GenerationStep.Carving.LIQUID), RarityFilter.onAverageOnceEvery((int)10), BiomeFilter.biome()));
        TropicraftPlacementUtil.register(context, MANGROVE_REEDS, TropicraftVegetationFeatures.MANGROVE_REEDS, List.of(CountPlacement.of((int)2), InSquarePlacement.spread(), HeightmapPlacement.onHeightmap((Heightmap.Types)Heightmap.Types.OCEAN_FLOOR_WG), BiomeFilter.biome()));
        TropicraftPlacementUtil.register(context, KELP, AquaticFeatures.KELP, List.of(NoiseBasedCountPlacement.of((int)75, (double)80.0, (double)0.55), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_TOP_SOLID, BiomeFilter.biome()));
    }

    private static ResourceKey<PlacedFeature> createKey(String name) {
        return Tropicraft.resourceKey(Registries.PLACED_FEATURE, name);
    }

    public static void addFruitTrees(BiomeGenerationSettings.Builder generation) {
        TropicraftVegetationPlacements.addVegetalDecoration(generation, TREES_FRUIT);
    }

    public static void addFloweringBushes(BiomeGenerationSettings.Builder generation) {
        TropicraftVegetationPlacements.addVegetalDecoration(generation, BUSH_FLOWERING_COMMON);
    }

    public static void addRareFloweringBushes(BiomeGenerationSettings.Builder generation) {
        TropicraftVegetationPlacements.addVegetalDecoration(generation, BUSH_FLOWERING_RARE);
    }

    public static void addPalmTrees(BiomeGenerationSettings.Builder generation) {
        TropicraftVegetationPlacements.addVegetalDecoration(generation, TREES_PALM);
    }

    public static void addRainforestTrees(BiomeGenerationSettings.Builder generation) {
        TropicraftVegetationPlacements.addVegetalDecoration(generation, TREES_RAINFOREST);
    }

    public static void addRainforestPlants(BiomeGenerationSettings.Builder generation) {
        TropicraftVegetationPlacements.addVegetalDecoration(generation, (ResourceKey<PlacedFeature>)VegetationPlacements.PATCH_MELON);
        TropicraftVegetationPlacements.addVegetalDecoration(generation, RAINFOREST_VINES);
        TropicraftVegetationPlacements.addVegetalDecoration(generation, COFFEE_BUSH);
        TropicraftVegetationPlacements.addVegetalDecoration(generation, SINGLE_UNDERGROWTH);
        TropicraftVegetationPlacements.addVegetalDecoration(generation, FLOWERS_RAINFOREST);
    }

    public static void addUndergrowth(BiomeGenerationSettings.Builder generation) {
        TropicraftVegetationPlacements.addVegetalDecoration(generation, UNDERGROWTH);
    }

    public static void addMangroveVegetation(BiomeGenerationSettings.Builder generation, boolean sparse) {
        TropicraftVegetationPlacements.addVegetalDecoration(generation, sparse ? TREES_MANGROVE_SPARSE : TREES_MANGROVE);
    }

    public static void addOvergrownGoldenLeatherFern(BiomeGenerationSettings.Builder generation) {
        TropicraftVegetationPlacements.addVegetalDecoration(generation, OVERGROWN_SMALL_GOLDEN_LEATHER_FERN);
        TropicraftVegetationPlacements.addVegetalDecoration(generation, OVERGROWN_TALL_GOLDEN_LEATHER_FERN);
        TropicraftVegetationPlacements.addVegetalDecoration(generation, OVERGROWN_HUGE_GOLDEN_LEATHER_FERN);
    }

    public static void addGoldenLeatherFern(BiomeGenerationSettings.Builder generation) {
        TropicraftVegetationPlacements.addVegetalDecoration(generation, SMALL_GOLDEN_LEATHER_FERN);
        TropicraftVegetationPlacements.addVegetalDecoration(generation, TALL_GOLDEN_LEATHER_FERN);
        TropicraftVegetationPlacements.addVegetalDecoration(generation, HUGE_GOLDEN_LEATHER_FERN);
    }

    public static void addPleodendron(BiomeGenerationSettings.Builder generation) {
        TropicraftVegetationPlacements.addVegetalDecoration(generation, TREES_PLEODENDRON);
    }

    public static void addPapaya(BiomeGenerationSettings.Builder generation) {
        TropicraftVegetationPlacements.addVegetalDecoration(generation, TREES_PAPAYA);
    }

    public static void addMangroveReeds(BiomeGenerationSettings.Builder generation) {
        TropicraftVegetationPlacements.addVegetalDecoration(generation, MANGROVE_REEDS);
    }

    public static void addTropicsGrass(BiomeGenerationSettings.Builder generation) {
        TropicraftVegetationPlacements.addVegetalDecoration(generation, TROPICS_GRASS);
    }

    public static void addBamboo(BiomeGenerationSettings.Builder generation) {
        TropicraftVegetationPlacements.addVegetalDecoration(generation, BAMBOO);
    }

    public static void addPineapples(BiomeGenerationSettings.Builder generation) {
        TropicraftVegetationPlacements.addVegetalDecoration(generation, PATCH_PINEAPPLE);
    }

    public static void addTropicsFlowers(BiomeGenerationSettings.Builder generation) {
        TropicraftVegetationPlacements.addVegetalDecoration(generation, FLOWERS_TROPICS);
        TropicraftVegetationPlacements.addVegetalDecoration(generation, PATCH_IRIS);
    }

    public static void addUndergroundSeagrass(BiomeGenerationSettings.Builder generation) {
        TropicraftVegetationPlacements.addVegetalDecoration(generation, UNDERGROUND_SEAGRASS_ON_STONE);
        TropicraftVegetationPlacements.addVegetalDecoration(generation, UNDERGROUND_SEAGRASS_ON_DIRT);
    }

    public static void addSeagrass(BiomeGenerationSettings.Builder generation) {
        TropicraftVegetationPlacements.addVegetalDecoration(generation, TROPI_SEAGRASS);
        TropicraftVegetationPlacements.addVegetalDecoration(generation, SEAGRASS);
    }

    public static void addUndergroundPickles(BiomeGenerationSettings.Builder generation) {
        TropicraftVegetationPlacements.addVegetalDecoration(generation, UNDERGROUND_SEA_PICKLES);
    }

    public static void addKelp(BiomeGenerationSettings.Builder generation) {
        TropicraftVegetationPlacements.addVegetalDecoration(generation, KELP);
    }

    private static void addVegetalDecoration(BiomeGenerationSettings.Builder generation, ResourceKey<PlacedFeature> feature) {
        generation.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, feature);
    }

    private static List<PlacementModifier> mangrovePlacement(int noiseToCountRatio, double noiseFactor, double noiseOffset) {
        return List.of(NoiseBasedCountPlacement.of((int)noiseToCountRatio, (double)noiseFactor, (double)noiseOffset), InSquarePlacement.spread(), HeightmapPlacement.onHeightmap((Heightmap.Types)Heightmap.Types.OCEAN_FLOOR), BiomeFilter.biome());
    }
}

