/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature;

import java.util.List;
import java.util.OptionalInt;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.RandomizedIntStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.RuleBasedBlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.AttachedToLeavesDecorator;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.common.block.FruitingBranchBlock;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.dimension.feature.TropicraftFeatureUtil;
import net.tropicraft.core.common.dimension.feature.TropicraftFeatures;
import net.tropicraft.core.common.dimension.feature.tree.BranchTreeDecorator;
import net.tropicraft.core.common.dimension.feature.tree.CitrusFoliagePlacer;
import net.tropicraft.core.common.dimension.feature.tree.CitrusTrunkPlacer;
import net.tropicraft.core.common.dimension.feature.tree.PapayaFoliagePlacer;
import net.tropicraft.core.common.dimension.feature.tree.PapayaTreeDecorator;
import net.tropicraft.core.common.dimension.feature.tree.PleodendronFoliagePlacer;
import net.tropicraft.core.common.dimension.feature.tree.PleodendronTrunkPlacer;
import net.tropicraft.core.common.dimension.feature.tree.TropibeehiveDecorator;
import net.tropicraft.core.common.dimension.feature.tree.mangrove.MangroveFoliagePlacer;
import net.tropicraft.core.common.dimension.feature.tree.mangrove.MangroveTrunkPlacer;
import net.tropicraft.core.common.dimension.feature.tree.mangrove.PneumatophoresTreeDecorator;
import net.tropicraft.core.common.dimension.feature.tree.mangrove.ReplaceInSoilDecorator;
import net.tropicraft.core.common.dimension.feature.tree.mangrove.SmallMangroveFoliagePlacer;
import net.tropicraft.core.common.dimension.feature.tree.mangrove.SmallMangroveTrunkPlacer;

public final class TropicraftTreeFeatures {
    private static final TropibeehiveDecorator BEEHIVE_002 = new TropibeehiveDecorator(0.02f);
    private static final TropibeehiveDecorator BEEHIVE_005 = new TropibeehiveDecorator(0.05f);
    public static final ResourceKey<ConfiguredFeature<?, ?>> GRAPEFRUIT_TREE = TropicraftTreeFeatures.createKey("grapefruit_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORANGE_TREE = TropicraftTreeFeatures.createKey("orange_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LEMON_TREE = TropicraftTreeFeatures.createKey("lemon_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LIME_TREE = TropicraftTreeFeatures.createKey("lime_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NORMAL_PALM_TREE = TropicraftTreeFeatures.createKey("normal_palm_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CURVED_PALM_TREE = TropicraftTreeFeatures.createKey("curved_palm_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LARGE_PALM_TREE = TropicraftTreeFeatures.createKey("large_palm_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PALM_TREE = TropicraftTreeFeatures.createKey("palm_trees");
    public static final ResourceKey<ConfiguredFeature<?, ?>> RAINFOREST_UP_TREE = TropicraftTreeFeatures.createKey("rainforest_up_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> RAINFOREST_SMALL_TUALUNG = TropicraftTreeFeatures.createKey("rainforest_small_tualung");
    public static final ResourceKey<ConfiguredFeature<?, ?>> RAINFOREST_LARGE_TUALUNG = TropicraftTreeFeatures.createKey("rainforest_large_tualung");
    public static final ResourceKey<ConfiguredFeature<?, ?>> RAINFOREST_TALL_TREE = TropicraftTreeFeatures.createKey("rainforest_tall_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> RAINFOREST_TREE = TropicraftTreeFeatures.createKey("rainforest_tree");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PLEODENDRON = TropicraftTreeFeatures.createKey("pleodendron");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PAPAYA = TropicraftTreeFeatures.createKey("papaya");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PLANTAIN = TropicraftTreeFeatures.createKey("plantain");
    public static final ResourceKey<ConfiguredFeature<?, ?>> JOCOTE = TropicraftTreeFeatures.createKey("jocote");
    public static final ResourceKey<ConfiguredFeature<?, ?>> RED_MANGROVE_SHORT = TropicraftTreeFeatures.createKey("red_mangrove_short");
    public static final ResourceKey<ConfiguredFeature<?, ?>> RED_MANGROVE_SMALL = TropicraftTreeFeatures.createKey("red_mangrove_small");
    public static final ResourceKey<ConfiguredFeature<?, ?>> RED_MANGROVE = TropicraftTreeFeatures.createKey("red_mangrove");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TALL_MANGROVE = TropicraftTreeFeatures.createKey("tall_mangrove");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TEA_MANGROVE = TropicraftTreeFeatures.createKey("tea_mangrove");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BLACK_MANGROVE = TropicraftTreeFeatures.createKey("black_mangrove");
    private static final Supplier<FoliagePlacer> MANGROVE_FOLIAGE = () -> new MangroveFoliagePlacer((IntProvider)ConstantInt.of((int)0), (IntProvider)ConstantInt.of((int)0));
    private static final Supplier<MangroveTrunkPlacer> RED_MANGROVE_TRUNK = () -> new MangroveTrunkPlacer(3, 3, 0, TropicraftFeatureUtil.stateProvider(TropicraftBlocks.RED_MANGROVE_ROOTS), true, false);
    private static final TwoLayersFeatureSize MANGROVE_MINIMUM_SIZE = new TwoLayersFeatureSize(0, 0, 0, OptionalInt.of(4));

    private static TreeConfiguration fruitTree(Supplier<? extends Block> fruitLeaves) {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((BlockState)Blocks.OAK_LOG.defaultBlockState()), (TrunkPlacer)new CitrusTrunkPlacer(6, 3, 0), (BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)((LeavesBlock)TropicraftBlocks.FRUIT_LEAVES.get()).defaultBlockState(), 1).add((Object)fruitLeaves.get().defaultBlockState(), 1).build()), (FoliagePlacer)new CitrusFoliagePlacer((IntProvider)ConstantInt.of((int)0), (IntProvider)ConstantInt.of((int)0)), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2)).build();
    }

    private static ReplaceInSoilDecorator addPianguasInMud(int count, int spread) {
        return new ReplaceInSoilDecorator(count, spread, RuleBasedBlockStateProvider.simple((Block)((Block)TropicraftBlocks.MUD_WITH_PIANGUAS.get())), BlockPredicate.matchesBlocks((Block[])new Block[]{(Block)TropicraftBlocks.MUD.get()}));
    }

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        TropicraftFeatureUtil.register(context, GRAPEFRUIT_TREE, Feature.TREE, TropicraftTreeFeatures.fruitTree(TropicraftBlocks.GRAPEFRUIT_LEAVES));
        TropicraftFeatureUtil.register(context, ORANGE_TREE, Feature.TREE, TropicraftTreeFeatures.fruitTree(TropicraftBlocks.ORANGE_LEAVES));
        TropicraftFeatureUtil.register(context, LEMON_TREE, Feature.TREE, TropicraftTreeFeatures.fruitTree(TropicraftBlocks.LEMON_LEAVES));
        TropicraftFeatureUtil.register(context, LIME_TREE, Feature.TREE, TropicraftTreeFeatures.fruitTree(TropicraftBlocks.LIME_LEAVES));
        TropicraftFeatureUtil.register(context, NORMAL_PALM_TREE, TropicraftFeatures.NORMAL_PALM_TREE);
        TropicraftFeatureUtil.register(context, CURVED_PALM_TREE, TropicraftFeatures.CURVED_PALM_TREE);
        TropicraftFeatureUtil.register(context, LARGE_PALM_TREE, TropicraftFeatures.LARGE_PALM_TREE);
        TropicraftFeatureUtil.registerRandom(context, PALM_TREE, NORMAL_PALM_TREE, CURVED_PALM_TREE, LARGE_PALM_TREE);
        TropicraftFeatureUtil.register(context, RAINFOREST_UP_TREE, TropicraftFeatures.UP_TREE);
        TropicraftFeatureUtil.register(context, RAINFOREST_SMALL_TUALUNG, TropicraftFeatures.SMALL_TUALUNG);
        TropicraftFeatureUtil.register(context, RAINFOREST_LARGE_TUALUNG, TropicraftFeatures.LARGE_TUALUNG);
        TropicraftFeatureUtil.register(context, RAINFOREST_TALL_TREE, TropicraftFeatures.TALL_TREE);
        TropicraftFeatureUtil.registerRandom(context, RAINFOREST_TREE, RAINFOREST_UP_TREE, RAINFOREST_SMALL_TUALUNG, LARGE_PALM_TREE, RAINFOREST_TALL_TREE);
        TropicraftFeatureUtil.register(context, PLEODENDRON, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((BlockState)Blocks.JUNGLE_LOG.defaultBlockState()), (TrunkPlacer)new PleodendronTrunkPlacer(10, 8, 0), (BlockStateProvider)BlockStateProvider.simple((BlockState)Blocks.JUNGLE_LEAVES.defaultBlockState()), (FoliagePlacer)new PleodendronFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)0), 1), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0, OptionalInt.of(4))).build());
        TropicraftFeatureUtil.register(context, PAPAYA, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((BlockState)((RotatedPillarBlock)TropicraftBlocks.PAPAYA_LOG.get()).defaultBlockState()), (TrunkPlacer)new StraightTrunkPlacer(5, 2, 3), (BlockStateProvider)BlockStateProvider.simple((BlockState)((LeavesBlock)TropicraftBlocks.PAPAYA_LEAVES.get()).defaultBlockState()), (FoliagePlacer)new PapayaFoliagePlacer((IntProvider)ConstantInt.of((int)0), (IntProvider)ConstantInt.of((int)0)), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0, OptionalInt.of(4))).decorators(List.of(BEEHIVE_005, new PapayaTreeDecorator())).build());
        TropicraftFeatureUtil.register(context, PLANTAIN, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((BlockState)((RotatedPillarBlock)TropicraftBlocks.PLANTAIN_STEM.get()).defaultBlockState()), (TrunkPlacer)new StraightTrunkPlacer(3, 1, 1), (BlockStateProvider)BlockStateProvider.simple((BlockState)((LeavesBlock)TropicraftBlocks.PLANTAIN_LEAVES.get()).defaultBlockState()), (FoliagePlacer)new SmallMangroveFoliagePlacer((IntProvider)ConstantInt.of((int)1), (IntProvider)ConstantInt.of((int)0)), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0, OptionalInt.of(4))).decorators(List.of(new AttachedToLeavesDecorator(0.5f, 1, 0, (BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)TropicraftBlocks.YELLOW_PLANTAIN_BUNCH.getDefaultState(), 1).add((Object)TropicraftBlocks.GREEN_PLANTAIN_BUNCH.getDefaultState(), 1).build()), 2, List.of(Direction.DOWN)))).build());
        TropicraftFeatureUtil.register(context, JOCOTE, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((BlockState)((RotatedPillarBlock)TropicraftBlocks.JOCOTE_LOG.get()).defaultBlockState()), (TrunkPlacer)new StraightTrunkPlacer(3, 1, 1), (BlockStateProvider)BlockStateProvider.simple((BlockState)((LeavesBlock)TropicraftBlocks.JOCOTE_LEAVES.get()).defaultBlockState()), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0, OptionalInt.of(4))).decorators(List.of(new BranchTreeDecorator(0.1f, (BlockStateProvider)new RandomizedIntStateProvider((BlockStateProvider)BlockStateProvider.simple((BlockState)TropicraftBlocks.JOCOTE_BRANCH.getDefaultState()), FruitingBranchBlock.AGE, (IntProvider)UniformInt.of((int)0, (int)2)), 2))).build());
        TropicraftFeatureUtil.register(context, RED_MANGROVE_SHORT, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder(TropicraftFeatureUtil.stateProvider(TropicraftBlocks.RED_MANGROVE_LOG), (TrunkPlacer)RED_MANGROVE_TRUNK.get(), TropicraftFeatureUtil.stateProvider(TropicraftBlocks.RED_MANGROVE_LEAVES), MANGROVE_FOLIAGE.get(), (FeatureSize)MANGROVE_MINIMUM_SIZE).decorators(List.of(BEEHIVE_002, TropicraftTreeFeatures.addPianguasInMud(8, 4))).build());
        TropicraftFeatureUtil.register(context, RED_MANGROVE_SMALL, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder(TropicraftFeatureUtil.stateProvider(TropicraftBlocks.RED_MANGROVE_LOG), (TrunkPlacer)new SmallMangroveTrunkPlacer(2, 1, 0, (Block)TropicraftBlocks.RED_MANGROVE_ROOTS.get()), TropicraftFeatureUtil.stateProvider(TropicraftBlocks.RED_MANGROVE_LEAVES), (FoliagePlacer)new SmallMangroveFoliagePlacer((IntProvider)ConstantInt.of((int)1), (IntProvider)ConstantInt.of((int)0)), (FeatureSize)MANGROVE_MINIMUM_SIZE).decorators(List.of(BEEHIVE_002, TropicraftTreeFeatures.addPianguasInMud(2, 2))).build());
        TropicraftFeatureUtil.registerRandom(context, RED_MANGROVE, RED_MANGROVE_SHORT, RED_MANGROVE_SMALL);
        TropicraftFeatureUtil.register(context, TALL_MANGROVE, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder(TropicraftFeatureUtil.stateProvider(TropicraftBlocks.LIGHT_MANGROVE_LOG), (TrunkPlacer)new MangroveTrunkPlacer(7, 4, 2, TropicraftFeatureUtil.stateProvider(TropicraftBlocks.LIGHT_MANGROVE_ROOTS), false, false), TropicraftFeatureUtil.stateProvider(TropicraftBlocks.TALL_MANGROVE_LEAVES), MANGROVE_FOLIAGE.get(), (FeatureSize)MANGROVE_MINIMUM_SIZE).decorators(List.of(BEEHIVE_002, TropicraftTreeFeatures.addPianguasInMud(8, 4))).build());
        TropicraftFeatureUtil.register(context, TEA_MANGROVE, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder(TropicraftFeatureUtil.stateProvider(TropicraftBlocks.LIGHT_MANGROVE_LOG), (TrunkPlacer)new MangroveTrunkPlacer(5, 3, 0, TropicraftFeatureUtil.stateProvider(TropicraftBlocks.LIGHT_MANGROVE_ROOTS), false, true), TropicraftFeatureUtil.stateProvider(TropicraftBlocks.TEA_MANGROVE_LEAVES), MANGROVE_FOLIAGE.get(), (FeatureSize)MANGROVE_MINIMUM_SIZE).decorators(List.of(BEEHIVE_002, TropicraftTreeFeatures.addPianguasInMud(8, 4), new PneumatophoresTreeDecorator(TropicraftFeatureUtil.stateProvider(TropicraftBlocks.LIGHT_MANGROVE_ROOTS), 2, 6, 4))).build());
        TropicraftFeatureUtil.register(context, BLACK_MANGROVE, Feature.TREE, new TreeConfiguration.TreeConfigurationBuilder(TropicraftFeatureUtil.stateProvider(TropicraftBlocks.BLACK_MANGROVE_LOG), (TrunkPlacer)new MangroveTrunkPlacer(4, 3, 0, TropicraftFeatureUtil.stateProvider(TropicraftBlocks.BLACK_MANGROVE_ROOTS), true, false), TropicraftFeatureUtil.stateProvider(TropicraftBlocks.BLACK_MANGROVE_LEAVES), MANGROVE_FOLIAGE.get(), (FeatureSize)MANGROVE_MINIMUM_SIZE).decorators(List.of(BEEHIVE_002, TropicraftTreeFeatures.addPianguasInMud(8, 4), new PneumatophoresTreeDecorator(TropicraftFeatureUtil.stateProvider(TropicraftBlocks.BLACK_MANGROVE_ROOTS), 8, 16, 6))).build());
    }

    private static ResourceKey<ConfiguredFeature<?, ?>> createKey(String name) {
        return Tropicraft.resourceKey(Registries.CONFIGURED_FEATURE, name);
    }
}

