/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature;

import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.common.TropicraftTags;
import net.tropicraft.core.common.dimension.feature.HomeTreeStructure;
import net.tropicraft.core.common.dimension.feature.KoaVillageStructure;
import net.tropicraft.core.common.dimension.feature.pools.TropicraftTemplatePools;
import net.tropicraft.core.common.dimension.feature.volcano.VolcanoStructure;

public final class TropicraftStructures {
    public static final ResourceKey<Structure> HOME_TREE = TropicraftStructures.createKey("home_tree");
    public static final ResourceKey<Structure> KOA_VILLAGE = TropicraftStructures.createKey("koa_village");
    public static final ResourceKey<Structure> OCEAN_VOLCANO = TropicraftStructures.createKey("ocean_volcano");
    public static final ResourceKey<Structure> LAND_VOLCANO = TropicraftStructures.createKey("land_volcano");

    public static void bootstrap(BootstrapContext<Structure> context) {
        HolderGetter biomes = context.lookup(Registries.BIOME);
        HolderGetter pools = context.lookup(Registries.TEMPLATE_POOL);
        context.register(HOME_TREE, (Object)new HomeTreeStructure(new Structure.StructureSettings((HolderSet)biomes.get(TropicraftTags.Biomes.HAS_HOME_TREE).orElseThrow(), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE), (Holder<StructureTemplatePool>)pools.getOrThrow(TropicraftTemplatePools.HOME_TREE_STARTS), 7));
        context.register(KOA_VILLAGE, (Object)new KoaVillageStructure(new Structure.StructureSettings((HolderSet)biomes.get(TropicraftTags.Biomes.HAS_KOA_VILLAGE).orElseThrow(), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE), (Holder<StructureTemplatePool>)pools.getOrThrow(TropicraftTemplatePools.KOA_TOWN_CENTERS), 6));
        context.register(OCEAN_VOLCANO, (Object)new VolcanoStructure(new Structure.StructureSettings((HolderSet)biomes.get(TropicraftTags.Biomes.HAS_OCEAN_VOLCANO).orElseThrow(), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE), (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)-50)), (IntProvider)UniformInt.of((int)45, (int)64)));
        context.register(LAND_VOLCANO, (Object)new VolcanoStructure(new Structure.StructureSettings((HolderSet)biomes.get(TropicraftTags.Biomes.HAS_LAND_VOLCANO).orElseThrow(), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE), (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)0)), (IntProvider)UniformInt.of((int)45, (int)64)));
    }

    private static ResourceKey<Structure> createKey(String name) {
        return Tropicraft.resourceKey(Registries.STRUCTURE, name);
    }
}

