/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature;

import com.mojang.serialization.Codec;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.tropicraft.core.common.block.TropicraftBlocks;

public class SeagrassFeature
extends Feature<NoneFeatureConfiguration> {
    private static final BiFunction<Boolean, Boolean, SeagrassData> SEAGRASS_DATA = Util.memoize((deep, selector) -> {
        if (deep.booleanValue()) {
            return selector != false ? new SeagrassData((Block)TropicraftBlocks.SICKLE_SEAGRASS.get(), (Block)TropicraftBlocks.MATTED_SICKLE_SEAGRASS.get(), (Block)TropicraftBlocks.TALL_SICKLE_SEAGRASS.get()) : new SeagrassData((Block)TropicraftBlocks.NOODLE_SEAGRASS.get(), (Block)TropicraftBlocks.MATTED_NOODLE_SEAGRASS.get(), null);
        }
        return selector != false ? new SeagrassData((Block)TropicraftBlocks.EEL_GRASS.get(), (Block)TropicraftBlocks.MATTED_EEL_GRASS.get(), (Block)TropicraftBlocks.TALL_EEL_GRASS.get(), new SeagrassData((Block)TropicraftBlocks.FLOWERING_EEL_GRASS.get(), (Block)TropicraftBlocks.MATTED_EEL_GRASS.get(), (Block)TropicraftBlocks.FLOWERING_TALL_EEL_GRASS.get())) : new SeagrassData((Block)TropicraftBlocks.FERN_SEAGRASS.get(), (Block)TropicraftBlocks.MATTED_FERN_SEAGRASS.get(), (Block)TropicraftBlocks.TALL_FERN_SEAGRASS.get());
    });

    public SeagrassFeature(Codec<NoneFeatureConfiguration> pCodec) {
        super(pCodec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource random = context.random();
        if (random.nextInt(4) == 0) {
            return false;
        }
        int floorOrigin = level.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, pos.getX(), pos.getZ());
        int surfaceOrigin = level.getHeight(Heightmap.Types.WORLD_SURFACE_WG, pos.getX(), pos.getZ());
        int depth = surfaceOrigin - floorOrigin;
        if (depth <= 0) {
            return false;
        }
        WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(level.getSeed()));
        NormalNoise seagrassSelector = NormalNoise.create((RandomSource)worldgenrandom, (int)-6, (double[])new double[]{1.0});
        int rad = random.nextInt(4) + 8;
        boolean deep = depth >= 18;
        for (int x = -rad; x <= rad; ++x) {
            for (int z = -rad; z <= rad; ++z) {
                BlockPos local;
                if (x * x + z * z > rad * rad) continue;
                int floor = level.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, pos.getX() + x, pos.getZ() + z);
                int surface = level.getHeight(Heightmap.Types.WORLD_SURFACE_WG, pos.getX() + x, pos.getZ() + z);
                if (surface <= floor || !level.getFluidState(local = pos.offset(x, 0, z).atY(floor)).is(FluidTags.WATER)) continue;
                boolean selection = seagrassSelector.getValue((double)local.getX(), (double)pos.getY(), (double)local.getZ()) > 0.0;
                SeagrassData data = SEAGRASS_DATA.apply(deep, selection);
                Block matted = data.matted;
                Block tall = data.tall;
                Block seagrass = data.seagrass;
                SeagrassData flowering = data.flowering;
                if (flowering != null && random.nextInt(8) == 0) {
                    seagrass = flowering.seagrass;
                    tall = flowering.tall;
                }
                if (random.nextInt(8) > 0) {
                    level.setBlock(local.below(), matted.defaultBlockState(), 2);
                }
                boolean placed = false;
                if (tall != null && random.nextInt(10) == 0 && level.getBlockState(local.above()).getFluidState().is(FluidTags.WATER)) {
                    level.setBlock(local.above(), (BlockState)tall.defaultBlockState().setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER), 2);
                    level.setBlock(local, (BlockState)tall.defaultBlockState().setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.LOWER), 2);
                    placed = true;
                }
                if (!placed && random.nextInt(tall == null ? 3 : 8) == 0) {
                    level.setBlock(local, seagrass.defaultBlockState(), 2);
                    placed = true;
                }
                if (placed || random.nextInt(80) != 0) continue;
                level.setBlock(local, (BlockState)Blocks.SEA_PICKLE.defaultBlockState().setValue((Property)BlockStateProperties.PICKLES, (Comparable)Integer.valueOf(random.nextInt(4) + 1)), 2);
            }
        }
        return true;
    }

    record SeagrassData(Block seagrass, Block matted, @Nullable Block tall, @Nullable SeagrassData flowering) {
        SeagrassData(Block seagrass, Block matted, @Nullable Block tall) {
            this(seagrass, matted, tall, null);
        }
    }
}

