/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.tropicraft.core.common.dimension.feature.TropicraftStructureTypes;

public class KoaVillageStructure
extends Structure {
    public static final MapCodec<KoaVillageStructure> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)KoaVillageStructure.settingsCodec((RecordCodecBuilder.Instance)i), (App)StructureTemplatePool.CODEC.fieldOf("start_pool").forGetter(s -> s.startPool), (App)Codec.intRange((int)0, (int)7).fieldOf("size").forGetter(s -> s.maxDepth)).apply((Applicative)i, KoaVillageStructure::new));
    private final Holder<StructureTemplatePool> startPool;
    private final int maxDepth;

    public KoaVillageStructure(Structure.StructureSettings settings, Holder<StructureTemplatePool> startPool, int maxDepth) {
        super(settings);
        this.startPool = startPool;
        this.maxDepth = maxDepth;
    }

    private static boolean isFeatureChunk(Structure.GenerationContext context, BlockPos startPos) {
        ChunkGenerator generator = context.chunkGenerator();
        LevelHeightAccessor level = context.heightAccessor();
        RandomState randomState = context.randomState();
        return KoaVillageStructure.isValid(generator, startPos.offset(-4, 0, -4), level, randomState) && KoaVillageStructure.isValid(generator, startPos.offset(-4, 0, 4), level, randomState) && KoaVillageStructure.isValid(generator, startPos.offset(4, 0, 4), level, randomState) && KoaVillageStructure.isValid(generator, startPos.offset(4, 0, -4), level, randomState);
    }

    private static boolean isValid(ChunkGenerator generator, BlockPos pos, LevelHeightAccessor level, RandomState randomState) {
        return generator.getBaseHeight(pos.getX(), pos.getZ(), Heightmap.Types.WORLD_SURFACE_WG, level, randomState) == generator.getSeaLevel();
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        ChunkPos chunkPos = context.chunkPos();
        BlockPos startPos = new BlockPos(chunkPos.getMinBlockX() + 8, 0, chunkPos.getMinBlockZ() + 8);
        if (!KoaVillageStructure.isFeatureChunk(context, startPos)) {
            return Optional.empty();
        }
        return JigsawPlacement.addPieces((Structure.GenerationContext)context, this.startPool, Optional.empty(), (int)this.maxDepth, (BlockPos)startPos, (boolean)true, Optional.of(Heightmap.Types.WORLD_SURFACE_WG), (int)80, (PoolAliasLookup)PoolAliasLookup.EMPTY, (DimensionPadding)DimensionPadding.ZERO, (LiquidSettings)LiquidSettings.APPLY_WATERLOGGING);
    }

    public StructureType<?> type() {
        return (StructureType)TropicraftStructureTypes.KOA_VILLAGE.get();
    }
}

