/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature;

import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.dimension.feature.TropicraftFeatureUtil;

public class EIHFeature
extends Feature<NoneFeatureConfiguration> {
    private static final Supplier<BlockState> EIH_STATE = () -> ((Block)TropicraftBlocks.CHUNK.get()).defaultBlockState();
    private static final BlockState LAVA_STATE = Blocks.LAVA.defaultBlockState();

    public EIHFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel world = context.level();
        BlockPos pos = context.origin();
        int height = 5;
        int i = pos.getX();
        int j = pos.getY() + 1;
        int k = pos.getZ();
        if (TropicraftFeatureUtil.goesBeyondWorldSize(world, pos.getY(), height)) {
            return false;
        }
        if (!TropicraftFeatureUtil.isBBAvailable(world, pos, height)) {
            return false;
        }
        if (!TropicraftFeatureUtil.isSoil((LevelAccessor)world, pos.below()) && !world.getBlockState(pos.below()).is(BlockTags.SAND)) {
            return false;
        }
        this.setBlock((LevelAccessor)world, i + 0, j + 0, k + 2, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + 0, j + 0, k + 3, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + 0, j + 0, k + 4, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -1, j + 0, k + 4, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -1, j + 0, k + 1, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -1, j + 0, k + 3, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -1, j + 1, k + 4, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + 0, j + 1, k + 4, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -1, j + 1, k + 3, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + 0, j + 1, k + 3, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + 0, j + 1, k + 2, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -1, j + 1, k + 1, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -1, j + 1, k + 0, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + 0, j + 2, k + 3, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -1, j + 2, k + 3, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + 0, j + 2, k + 2, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -1, j + 2, k + 0, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -1, j + 3, k + 3, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + 0, j + 3, k + 2, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + 0, j + 3, k + 1, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + 0, j + 3, k + 0, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + 0, j + 4, k + 2, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -1, j + 3, k + -1, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + 0, j + 3, k + -1, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -1, j + 2, k + -1, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + 0, j + 4, k + -1, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -1, j + 4, k + 2, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -1, j + 4, k + -1, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -1, j + 5, k + -1, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + 0, j + 5, k + -1, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -1, j + 5, k + 1, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -1, j + 5, k + 2, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -1, j + 3, k + 4, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -1, j + 4, k + 3, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + 0, j + 6, k + -1, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + 0, j + 6, k + 0, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -1, j + 6, k + -1, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -1, j + 6, k + 0, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -1, j + 6, k + 1, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + 1, j + 5, k + 0, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + 1, j + 5, k + 1, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + 1, j + 4, k + 1, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + 1, j + 4, k + 0, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + 0, j + 2, k + 1, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + 0, j + 2, k + 0, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + 0, j + 1, k + 0, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + 0, j + 0, k + 0, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -1, j + 0, k + 0, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + 0, j + 6, k + 1, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + 0, j + 5, k + 0, LAVA_STATE);
        this.setBlock((LevelAccessor)world, i + -1, j + 4, k + 0, LAVA_STATE);
        this.setBlock((LevelAccessor)world, i + -1, j + 5, k + 0, LAVA_STATE);
        this.setBlock((LevelAccessor)world, i + -1, j + 3, k + 0, LAVA_STATE);
        this.setBlock((LevelAccessor)world, i + -1, j + 4, k + 1, LAVA_STATE);
        this.setBlock((LevelAccessor)world, i + -1, j + 3, k + 1, LAVA_STATE);
        this.setBlock((LevelAccessor)world, i + -1, j + 2, k + 1, LAVA_STATE);
        this.setBlock((LevelAccessor)world, i + -1, j + 3, k + 2, LAVA_STATE);
        this.setBlock((LevelAccessor)world, i + -1, j + 2, k + 2, LAVA_STATE);
        this.setBlock((LevelAccessor)world, i + -1, j + 1, k + 2, LAVA_STATE);
        this.setBlock((LevelAccessor)world, i + -2, j + 3, k + 4, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -2, j + 3, k + 3, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -2, j + 2, k + 3, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -2, j + 1, k + 3, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -2, j + 1, k + 4, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -2, j + 0, k + 4, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -2, j + 0, k + 3, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -2, j + 0, k + 1, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -2, j + 0, k + 0, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -2, j + 1, k + 1, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -2, j + 1, k + 0, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -2, j + 2, k + 0, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -2, j + 2, k + -1, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -2, j + 3, k + -1, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -2, j + 4, k + -1, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -2, j + 5, k + -1, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -2, j + 6, k + -1, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -2, j + 6, k + 1, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -2, j + 6, k + 0, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -2, j + 5, k + 2, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -2, j + 5, k + 1, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -2, j + 4, k + 2, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -2, j + 4, k + 3, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -2, j + 5, k + 0, LAVA_STATE);
        this.setBlock((LevelAccessor)world, i + -2, j + 4, k + 0, LAVA_STATE);
        this.setBlock((LevelAccessor)world, i + -2, j + 3, k + 0, LAVA_STATE);
        this.setBlock((LevelAccessor)world, i + -2, j + 4, k + 1, LAVA_STATE);
        this.setBlock((LevelAccessor)world, i + -2, j + 3, k + 1, LAVA_STATE);
        this.setBlock((LevelAccessor)world, i + -2, j + 2, k + 1, LAVA_STATE);
        this.setBlock((LevelAccessor)world, i + -2, j + 3, k + 2, LAVA_STATE);
        this.setBlock((LevelAccessor)world, i + -2, j + 2, k + 2, LAVA_STATE);
        this.setBlock((LevelAccessor)world, i + -2, j + 1, k + 2, LAVA_STATE);
        this.setBlock((LevelAccessor)world, i + -3, j + 0, k + 0, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -3, j + 0, k + 2, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -3, j + 0, k + 3, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -3, j + 0, k + 4, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -3, j + 1, k + 4, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -3, j + 1, k + 3, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -3, j + 2, k + 3, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -3, j + 1, k + 0, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -3, j + 1, k + 2, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -3, j + 2, k + 2, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -3, j + 2, k + 1, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -3, j + 2, k + 0, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -3, j + 3, k + 2, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -3, j + 4, k + 2, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -3, j + 3, k + 1, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -3, j + 3, k + 0, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -3, j + 3, k + -1, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -3, j + 4, k + -1, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -3, j + 5, k + -1, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -3, j + 6, k + -1, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -3, j + 6, k + 0, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -3, j + 6, k + 1, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -4, j + 5, k + 0, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -4, j + 4, k + 0, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -4, j + 4, k + 1, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + 0, j + 4, k + 0, LAVA_STATE);
        this.setBlock((LevelAccessor)world, i + 0, j + 4, k + 1, LAVA_STATE);
        this.setBlock((LevelAccessor)world, i + -3, j + 4, k + 0, LAVA_STATE);
        this.setBlock((LevelAccessor)world, i + -3, j + 4, k + 1, LAVA_STATE);
        this.setBlock((LevelAccessor)world, i + -3, j + 5, k + 0, LAVA_STATE);
        this.setBlock((LevelAccessor)world, i + -4, j + 5, k + 1, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -2, j + 1, k + -1, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -1, j + 1, k + -1, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -2, j + 0, k + -1, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -1, j + 0, k + -1, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -3, j + -1, k + 0, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -2, j + -1, k + 0, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -1, j + -1, k + 0, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + 0, j + -1, k + 0, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -2, j + -1, k + 1, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -1, j + -1, k + 1, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -3, j + -1, k + 2, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + 0, j + -1, k + 2, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -2, j + -1, k + 3, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -1, j + -1, k + 3, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -3, j + -2, k + 2, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -2, j + -2, k + 3, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -1, j + -2, k + 3, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + 0, j + -2, k + 2, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -1, j + -2, k + 1, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -2, j + -2, k + 1, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -3, j + -2, k + 0, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -2, j + -2, k + 0, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -1, j + -2, k + 0, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + 0, j + -2, k + 0, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + 0, j + -3, k + 2, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -1, j + -3, k + 3, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -1, j + 0, k + 2, LAVA_STATE);
        this.setBlock((LevelAccessor)world, i + -2, j + 0, k + 2, LAVA_STATE);
        this.setBlock((LevelAccessor)world, i + -1, j + -1, k + 2, LAVA_STATE);
        this.setBlock((LevelAccessor)world, i + -2, j + -1, k + 2, LAVA_STATE);
        this.setBlock((LevelAccessor)world, i + -2, j + -2, k + 2, LAVA_STATE);
        this.setBlock((LevelAccessor)world, i + -1, j + -2, k + 2, LAVA_STATE);
        this.setBlock((LevelAccessor)world, i + -2, j + -3, k + 3, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -1, j + -3, k + 2, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -2, j + -3, k + 2, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -3, j + -3, k + 2, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -2, j + -3, k + 1, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -1, j + -3, k + 1, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -3, j + -3, k + 0, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -2, j + -3, k + 0, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + -1, j + -3, k + 0, EIH_STATE.get());
        this.setBlock((LevelAccessor)world, i + 0, j + -3, k + 0, EIH_STATE.get());
        int eyeOneX = i;
        int eyeOneY = j + 5;
        int eyeOneZ = k + 1;
        int eyeTwoX = i - 3;
        int eyeTwoY = j + 5;
        int eyeTwoZ = k + 1;
        int eyeRand = world.getRandom().nextInt(9);
        this.placeEye((LevelAccessor)world, eyeOneX, eyeOneY, eyeOneZ, eyeRand);
        this.placeEye((LevelAccessor)world, eyeTwoX, eyeTwoY, eyeTwoZ, eyeRand);
        return true;
    }

    private void setBlock(LevelAccessor world, int i, int i1, int i2, BlockState state) {
        world.setBlock(new BlockPos(i, i1, i2), state, 3);
    }

    private void placeEye(LevelAccessor world, int x, int y, int z, int eyeRand) {
        if (world.getRandom().nextInt(1000) == 0) {
            eyeRand = world.getRandom().nextInt(9);
        }
        BlockState blockState = switch (eyeRand) {
            case 0, 5 -> Blocks.GLOWSTONE.defaultBlockState();
            case 1 -> Blocks.OBSIDIAN.defaultBlockState();
            case 2 -> Blocks.DIAMOND_BLOCK.defaultBlockState();
            case 3 -> Blocks.IRON_BLOCK.defaultBlockState();
            case 4 -> Blocks.GOLD_BLOCK.defaultBlockState();
            case 6 -> ((Block)TropicraftBlocks.AZURITE_BLOCK.get()).defaultBlockState();
            case 7 -> ((Block)TropicraftBlocks.EUDIALYTE_BLOCK.get()).defaultBlockState();
            case 8 -> ((Block)TropicraftBlocks.ZIRCON_BLOCK.get()).defaultBlockState();
            default -> Blocks.REDSTONE_BLOCK.defaultBlockState();
        };
        this.setBlock((LevelWriter)world, new BlockPos(x, y, z), blockState);
    }
}

