/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.tropicraft.core.common.block.CoffeeBushBlock;
import net.tropicraft.core.common.block.TropicraftBlocks;

public class CoffeePlantFeature
extends Feature<NoneFeatureConfiguration> {
    public static final BlockState GRASS_BLOCK = Blocks.GRASS_BLOCK.defaultBlockState();
    public static final BlockState COFE = ((CoffeeBushBlock)((Object)TropicraftBlocks.COFFEE_BUSH.get())).getStateForAge(6);
    public static final BlockState FARMLAND = Blocks.FARMLAND.defaultBlockState();
    public static final BlockState WATER = Blocks.WATER.defaultBlockState();

    public CoffeePlantFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos upPos;
        WorldGenLevel world = context.level();
        RandomSource random = context.random();
        BlockPos pos = context.origin();
        BlockPos genPos = new BlockPos(pos.getX() + random.nextInt(8) - random.nextInt(8), pos.getY(), pos.getZ() + random.nextInt(8) - random.nextInt(8));
        if (!world.isEmptyBlock(genPos) || world.getBlockState(genPos.below()).getBlock() != GRASS_BLOCK.getBlock() || world.isEmptyBlock(genPos.below(2))) {
            return false;
        }
        Direction viableDirection = null;
        for (Object dir : Direction.Plane.HORIZONTAL) {
            int neighborx = genPos.getX() + dir.getStepX();
            int neighborz = genPos.getZ() + dir.getStepZ();
            if (world.isEmptyBlock(new BlockPos(neighborx, pos.getY() - 1, neighborz))) continue;
            viableDirection = dir;
            break;
        }
        if (viableDirection == null) {
            return false;
        }
        BlockPos waterPos = new BlockPos(genPos.getX() + viableDirection.getStepX(), pos.getY() - 1, genPos.getZ() + viableDirection.getStepZ());
        world.setBlock(waterPos, WATER, 3);
        world.setBlock(genPos.below(), FARMLAND, 3);
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            world.setBlock(waterPos.relative(dir), GRASS_BLOCK, 3);
        }
        for (int i = 0; i < 3 && world.isEmptyBlock(upPos = genPos.above(i)); ++i) {
            world.setBlock(upPos, COFE, 3);
        }
        return true;
    }
}

