/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.biome;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.common.dimension.feature.TropicraftVegetationPlacements;

public class TropicraftBiomeModifiers {
    public static void bootstrap(BootstrapContext<BiomeModifier> context) {
        HolderGetter biomes = context.lookup(Registries.BIOME);
        HolderGetter placedFeatures = context.lookup(Registries.PLACED_FEATURE);
        context.register(TropicraftBiomeModifiers.createKey("overworld_palm_trees"), (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomes.getOrThrow(Biomes.BEACH)}), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(TropicraftVegetationPlacements.TREES_PALM_OVERWORLD)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(TropicraftBiomeModifiers.createKey("overworld_pineapples"), (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomes.getOrThrow(Biomes.JUNGLE), biomes.getOrThrow(Biomes.SPARSE_JUNGLE), biomes.getOrThrow(Biomes.BAMBOO_JUNGLE)}), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(TropicraftVegetationPlacements.PINEAPPLE)}), GenerationStep.Decoration.VEGETAL_DECORATION));
    }

    private static ResourceKey<BiomeModifier> createKey(String name) {
        return Tropicraft.resourceKey(NeoForgeRegistries.Keys.BIOME_MODIFIERS, name);
    }
}

