/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension;

import java.util.OptionalLong;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.common.dimension.TropicsPortalLinker;
import net.tropicraft.core.common.dimension.biome.TropicraftBiomeBuilder;
import net.tropicraft.core.common.dimension.noise.TropicraftNoiseGenSettings;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class TropicraftDimension {
    private static final Logger LOGGER = LogManager.getLogger(TropicraftDimension.class);
    public static final ResourceLocation ID;
    public static final ResourceLocation EFFECTS_ID;
    public static final ResourceKey<Level> WORLD;
    public static final ResourceKey<LevelStem> DIMENSION;
    public static final ResourceKey<DimensionType> DIMENSION_TYPE;
    public static final int SEA_LEVEL = 127;

    public static void bootstrapDimensionType(BootstrapContext<DimensionType> context) {
        context.register(DIMENSION_TYPE, (Object)new DimensionType(OptionalLong.empty(), true, false, false, true, 1.0, true, false, -64, 384, 384, BlockTags.INFINIBURN_OVERWORLD, EFFECTS_ID, 0.0f, new DimensionType.MonsterSettings(false, true, (IntProvider)UniformInt.of((int)0, (int)7), 0)));
    }

    public static void bootstrapLevelStem(BootstrapContext<LevelStem> context) {
        context.register(DIMENSION, (Object)new LevelStem((Holder)context.lookup(Registries.DIMENSION_TYPE).getOrThrow(DIMENSION_TYPE), (ChunkGenerator)new NoiseBasedChunkGenerator((BiomeSource)MultiNoiseBiomeSource.createFromPreset((Holder)context.lookup(Registries.MULTI_NOISE_BIOME_SOURCE_PARAMETER_LIST).getOrThrow(TropicraftBiomeBuilder.PARAMETER_LIST)), (Holder)context.lookup(Registries.NOISE_SETTINGS).getOrThrow(TropicraftNoiseGenSettings.TROPICS))));
    }

    public static void teleportPlayer(ServerPlayer player, ResourceKey<Level> dimensionType) {
        ServerLevel targetLevel = TropicraftDimension.getTeleportDestination((Level)player.serverLevel(), dimensionType);
        if (targetLevel == null) {
            return;
        }
        int x = player.getBlockX();
        int z = player.getBlockZ();
        LevelChunk chunk = targetLevel.getChunk(SectionPos.blockToSectionCoord((int)x), SectionPos.blockToSectionCoord((int)z));
        int topY = chunk.getHeight(Heightmap.Types.WORLD_SURFACE, SectionPos.sectionRelative((int)x), SectionPos.sectionRelative((int)z));
        Vec3 pos = new Vec3((double)x + 0.5, (double)topY + 1.0, (double)z + 0.5);
        player.unRide();
        player.changeDimension(new DimensionTransition(targetLevel, pos, Vec3.ZERO, player.getYRot(), player.getXRot(), DimensionTransition.DO_NOTHING));
    }

    @Nullable
    public static DimensionTransition getPortalTransition(ServerLevel level, Entity entity, ResourceKey<Level> targetDimension) {
        ServerLevel targetLevel = TropicraftDimension.getTeleportDestination((Level)level, targetDimension);
        if (targetLevel == null) {
            return null;
        }
        TropicsPortalLinker linker = new TropicsPortalLinker(targetLevel);
        TropicsPortalLinker.PortalInfo portal = linker.findOrCreatePortal(entity);
        if (portal == null) {
            return null;
        }
        return new DimensionTransition(targetLevel, portal.position(), Vec3.ZERO, portal.yRot(), portal.xRot(), DimensionTransition.PLACE_PORTAL_TICKET.then(DimensionTransition.PLAY_PORTAL_SOUND));
    }

    public static void teleportPlayerWithPortal(ServerPlayer player, ResourceKey<Level> dimensionType) {
        player.unRide();
        DimensionTransition portalTransition = TropicraftDimension.getPortalTransition(player.serverLevel(), (Entity)player, dimensionType);
        if (portalTransition != null) {
            player.changeDimension(portalTransition);
        }
    }

    @Nullable
    private static ServerLevel getTeleportDestination(Level sourceLevel, ResourceKey<Level> targetDimension) {
        ResourceKey<Level> destination = sourceLevel.dimension() == targetDimension ? Level.OVERWORLD : targetDimension;
        ServerLevel destLevel = sourceLevel.getServer().getLevel(destination);
        if (destLevel == null) {
            LOGGER.error("Cannot teleport player to dimension {} as it does not exist!", (Object)destination.location());
            return null;
        }
        return destLevel;
    }

    public static int getSeaLevel(LevelReader reader) {
        Level level;
        if (reader instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)reader;
            ServerChunkCache chunkProvider = serverLevel.getChunkSource();
            return chunkProvider.getGenerator().getSeaLevel();
        }
        if (reader instanceof Level && (level = (Level)reader).dimension() == WORLD) {
            return 127;
        }
        return reader.getSeaLevel();
    }

    static {
        EFFECTS_ID = ID = Tropicraft.location("tropics");
        WORLD = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ID);
        DIMENSION = ResourceKey.create((ResourceKey)Registries.LEVEL_STEM, (ResourceLocation)ID);
        DIMENSION_TYPE = ResourceKey.create((ResourceKey)Registries.DIMENSION_TYPE, (ResourceLocation)ID);
    }
}

