/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.data;

import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.SharedConstants;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.slf4j.Logger;

public class StructureConverter
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String STRUCTURE_DIRECTORY = "structure";
    private final String namespace;
    private final PackOutput output;
    private final Collection<Path> inputs;

    public StructureConverter(String namespace, PackOutput output, Collection<Path> inputs) {
        this.namespace = namespace;
        this.output = output;
        this.inputs = inputs;
    }

    public CompletableFuture<?> run(CachedOutput output) {
        Path outputStructureRoot = this.output.getOutputFolder(PackOutput.Target.DATA_PACK).resolve(this.namespace).resolve(STRUCTURE_DIRECTORY);
        for (Path inputRoot : this.inputs) {
            Path structureRoot = inputRoot.resolve("data").resolve(this.namespace).resolve(STRUCTURE_DIRECTORY);
            StructureConverter.importNbtStructures(structureRoot);
            StructureConverter.convertAndUpdateSnbtStructures(output, structureRoot, outputStructureRoot);
        }
        return CompletableFuture.completedFuture(null);
    }

    private static void importNbtStructures(Path inputRoot) {
        try {
            Files.walkFileTree(inputRoot, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                    String fileName = path.getFileName().toString();
                    if (!fileName.endsWith(".nbt")) {
                        return FileVisitResult.CONTINUE;
                    }
                    Path snbtPath = path.resolveSibling(StructureConverter.replaceExtension(fileName, ".nbt", ".snbt"));
                    CompoundTag tag = NbtIo.readCompressed((Path)path, (NbtAccounter)NbtAccounter.unlimitedHeap());
                    Files.writeString(snbtPath, (CharSequence)NbtUtils.structureToSnbt((CompoundTag)tag), StandardCharsets.UTF_8, new OpenOption[0]);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            LOGGER.error("Failed to import structure files", (Throwable)e);
        }
    }

    private static void convertAndUpdateSnbtStructures(final CachedOutput output, final Path inputRoot, final Path outputRoot) {
        try {
            Files.walkFileTree(inputRoot, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                    CompoundTag tag;
                    String fileName = path.getFileName().toString();
                    if (!fileName.endsWith(".snbt")) {
                        return FileVisitResult.CONTINUE;
                    }
                    try {
                        tag = NbtUtils.snbtToStructure((String)Files.readString(path, StandardCharsets.UTF_8));
                    }
                    catch (CommandSyntaxException e) {
                        LOGGER.error("Failed to parse SNBT for {}", (Object)path, (Object)e);
                        return FileVisitResult.CONTINUE;
                    }
                    CompoundTag upgradedTag = StructureConverter.upgradeStructureTag(tag);
                    if (!tag.equals((Object)upgradedTag)) {
                        Files.writeString(path, (CharSequence)NbtUtils.structureToSnbt((CompoundTag)upgradedTag.copy()), StandardCharsets.UTF_8, new OpenOption[0]);
                    }
                    String convertedFileName = StructureConverter.replaceExtension(fileName, ".snbt", ".nbt");
                    Path convertedPath = outputRoot.resolve(inputRoot.relativize(path.resolveSibling(convertedFileName)));
                    StructureConverter.writePackedStructure(output, convertedPath, upgradedTag);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            LOGGER.error("Failed to convert structure files", (Throwable)e);
        }
    }

    private static void writePackedStructure(CachedOutput output, Path path, CompoundTag tag) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        HashingOutputStream hashingOutput = new HashingOutputStream(Hashing.sha1(), (OutputStream)bytes);
        NbtIo.writeCompressed((CompoundTag)tag, (OutputStream)hashingOutput);
        output.writeIfNeeded(path, bytes.toByteArray(), hashingOutput.hash());
    }

    private static CompoundTag upgradeStructureTag(CompoundTag tag) {
        int currentVersion = SharedConstants.getCurrentVersion().getDataVersion().getVersion();
        int dataVersion = NbtUtils.getDataVersion((CompoundTag)tag, (int)500);
        if (dataVersion == currentVersion) {
            return tag;
        }
        CompoundTag updatedTag = DataFixTypes.STRUCTURE.update(DataFixers.getDataFixer(), tag, dataVersion, currentVersion);
        StructureTemplate template = new StructureTemplate();
        template.load((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), updatedTag);
        return template.save(new CompoundTag());
    }

    private static String replaceExtension(String path, String oldSuffix, String newSuffix) {
        if (!path.endsWith(oldSuffix)) {
            throw new IllegalArgumentException("Cannot replace extension of " + path + " with " + newSuffix + ", as it does not have " + oldSuffix);
        }
        return path.substring(0, path.length() - oldSuffix.length()) + newSuffix;
    }

    public String getName() {
        return "Structure Converter (" + this.namespace + ")";
    }
}

