/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block.tileentity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.entity.TropicraftEntities;
import net.tropicraft.core.common.entity.projectile.LavaBallEntity;
import net.tropicraft.core.common.volcano.VolcanoState;

public class VolcanoBlockEntity
extends BlockEntity {
    private static final int RAND_DORMANT_DURATION = 4000;
    private static final int MAX_LAVA_LEVEL_DURING_RISE = 183;
    private static final int MAX_LAVA_LEVEL_DURING_ERUPTION = 185;
    private static final int LAVA_BASE_LEVEL = 149;
    private static final int LAVA_ERUPT_LEVEL = 160;
    private int ticksUntilEruption = VolcanoState.getTimeBefore(VolcanoState.ERUPTING);
    private int ticksUntilSmoking = VolcanoState.getTimeBefore(VolcanoState.SMOKING);
    private int ticksUntilRetreating = VolcanoState.getTimeBefore(VolcanoState.RETREATING);
    private int ticksUntilDormant = VolcanoState.getTimeBefore(VolcanoState.DORMANT);
    private int ticksUntilRising = VolcanoState.getTimeBefore(VolcanoState.RISING);
    private int lavaLevel = -1;
    private int radius = -1;
    private VolcanoState state = VolcanoState.DORMANT;
    private int heightOffset = Integer.MIN_VALUE;

    public VolcanoBlockEntity(BlockEntityType<VolcanoBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public static void volcanoTick(Level level, BlockPos pos, BlockState state, VolcanoBlockEntity volcano) {
        volcano.tick();
    }

    private void tick() {
    }

    public void cleanUpFromEruption() {
        int xPos = this.worldPosition.getX();
        int zPos = this.worldPosition.getZ();
        for (int x = xPos - this.radius * 2; x < xPos + this.radius * 2; ++x) {
            for (int z = zPos - this.radius * 2; z < zPos + this.radius * 2; ++z) {
                for (int y = 149 + this.heightOffset; y < 140; ++y) {
                    BlockPos outBlockPos = new BlockPos(x, y, z);
                    if (!this.getLevel().getBlockState(outBlockPos).is(Blocks.LAVA)) continue;
                    this.getLevel().setBlockAndUpdate(outBlockPos, Blocks.AIR.defaultBlockState());
                }
            }
        }
    }

    public void throwLavaFromCaldera(double force) {
        Vec3 pos = new Vec3((this.getLevel().random.nextDouble() / 2.0 + 0.3) * (double)this.radius, (double)(this.lavaLevel + 2), 0.0);
        float angle = this.getLevel().random.nextFloat() * (float)Math.PI * 2.0f;
        pos = pos.yRot(angle).add(Vec3.atCenterOf((Vec3i)this.getBlockPos()));
        double motX = force * Math.cos(angle);
        double motZ = force * Math.sin(-angle);
        this.throwLava(pos.x, pos.y, pos.z, motX, 0.86, motZ);
    }

    public void throwLava(double i, double j, double k, double xMot, double yMot, double zMot) {
        if (!this.getLevel().isClientSide) {
            this.getLevel().addFreshEntity((Entity)new LavaBallEntity((EntityType<? extends LavaBallEntity>)((EntityType)TropicraftEntities.LAVA_BALL.get()), this.getLevel(), i, j, k, xMot, yMot, zMot));
        }
    }

    private void raiseLavaLevels() {
        if (this.lavaLevel < 185 + this.heightOffset) {
            ++this.lavaLevel;
            this.setBlocksOnLavaLevel(Blocks.LAVA.defaultBlockState(), 3);
        }
    }

    private void lowerLavaLevels() {
        if (this.lavaLevel > 149 + this.heightOffset) {
            this.setBlocksOnLavaLevel(Blocks.AIR.defaultBlockState(), 3);
            --this.lavaLevel;
        }
    }

    private void setBlocksOnLavaLevel(BlockState state, int updateFlag) {
        int xPos = this.worldPosition.getX();
        int zPos = this.worldPosition.getZ();
        for (int x = xPos - this.radius; x < xPos + this.radius; ++x) {
            for (int z = zPos - this.radius; z < zPos + this.radius; ++z) {
                if (!(Math.sqrt(Math.pow(x - xPos, 2.0) + Math.pow(z - zPos, 2.0)) < (double)(this.radius + 3))) continue;
                BlockPos botPos = new BlockPos(x, 10, z);
                if (!this.getLevel().getBlockState(botPos).is(Blocks.LAVA)) continue;
                BlockPos pos2 = new BlockPos(x, this.lavaLevel, z);
                if (this.lavaLevel >= 183 + this.heightOffset && this.lavaLevel < 185 + this.heightOffset) {
                    if (this.getLevel().getBlockState(pos2).getBlock() == TropicraftBlocks.CHUNK.get()) continue;
                    this.getLevel().setBlock(pos2, state, updateFlag);
                    continue;
                }
                this.getLevel().setBlock(pos2, state, updateFlag);
            }
        }
    }

    public void spewSmoke() {
        int n = this.getLevel().random.nextInt(100) + 4;
        for (int i = 0; i < n; ++i) {
            double x = this.worldPosition.getX() + this.getLevel().random.nextInt(this.radius) * (this.getLevel().random.nextBoolean() ? -1 : 1);
            double y = this.lavaLevel + this.getLevel().random.nextInt(6);
            double z = this.worldPosition.getZ() + this.getLevel().random.nextInt(this.radius) * (this.getLevel().random.nextBoolean() ? -1 : 1);
            this.getLevel().addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, true, x, y, z, 0.0, 0.7, 0.0);
        }
    }

    private void updateStates() {
        switch (this.state) {
            case DORMANT: {
                --this.ticksUntilSmoking;
                if (this.ticksUntilSmoking > 0) break;
                this.state = VolcanoState.SMOKING;
                this.ticksUntilSmoking = VolcanoState.getTimeBefore(VolcanoState.SMOKING);
                break;
            }
            case SMOKING: {
                --this.ticksUntilRising;
                if (this.ticksUntilRising > 0) break;
                this.state = VolcanoState.RISING;
                this.ticksUntilRising = VolcanoState.getTimeBefore(VolcanoState.RISING);
                break;
            }
            case RISING: {
                --this.ticksUntilEruption;
                if (this.ticksUntilEruption > 0) break;
                this.state = VolcanoState.ERUPTING;
                this.ticksUntilEruption = VolcanoState.getTimeBefore(VolcanoState.ERUPTING);
                break;
            }
            case ERUPTING: {
                --this.ticksUntilRetreating;
                if (this.ticksUntilRetreating > 0) break;
                this.state = VolcanoState.RETREATING;
                this.ticksUntilRetreating = VolcanoState.getTimeBefore(VolcanoState.RETREATING);
                break;
            }
            case RETREATING: {
                --this.ticksUntilDormant;
                if (this.ticksUntilDormant > 0) break;
                this.state = VolcanoState.DORMANT;
                this.ticksUntilDormant = VolcanoState.getTimeBefore(VolcanoState.DORMANT) + this.getLevel().random.nextInt(4000);
                break;
            }
        }
    }

    private void setLavaLevel() {
        int x = this.worldPosition.getX();
        int z = this.worldPosition.getZ();
        int minY = 149 + this.heightOffset;
        int maxY = this.level.getMaxBuildHeight();
        for (BlockPos pos : BlockPos.betweenClosed((int)x, (int)minY, (int)z, (int)x, (int)maxY, (int)z)) {
            if (this.level.getFluidState(pos).is(FluidTags.LAVA)) continue;
            this.lavaLevel = pos.getY() - 1;
            return;
        }
    }

    private int findRadius() {
        int x = this.worldPosition.getX();
        int z = this.worldPosition.getZ();
        for (BlockPos pos : BlockPos.betweenClosed((int)x, (int)10, (int)z, (int)(x + 60), (int)10, (int)z)) {
            if (this.level.getFluidState(pos).is(FluidTags.LAVA)) continue;
            return pos.getX() - this.worldPosition.getX();
        }
        return -1;
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.heightOffset = nbt.getInt("height_offset");
        this.state = VolcanoState.valueOf(nbt.getString("state"));
        this.ticksUntilDormant = nbt.getInt("ticksUntilDormant");
        this.ticksUntilSmoking = nbt.getInt("ticksUntilSmoking");
        this.ticksUntilRising = nbt.getInt("ticksUntilRising");
        this.ticksUntilEruption = nbt.getInt("ticksUntilEruption");
        this.ticksUntilRetreating = nbt.getInt("ticksUntilRetreating");
        this.lavaLevel = nbt.getInt("lavaLevel");
        this.radius = nbt.getInt("radius");
    }

    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.putInt("height_offset", this.heightOffset);
        nbt.putString("state", this.state.name());
        nbt.putInt("ticksUntilDormant", this.ticksUntilDormant);
        nbt.putInt("ticksUntilSmoking", this.ticksUntilSmoking);
        nbt.putInt("ticksUntilRising", this.ticksUntilRising);
        nbt.putInt("ticksUntilEruption", this.ticksUntilEruption);
        nbt.putInt("ticksUntilRetreating", this.ticksUntilRetreating);
        nbt.putInt("lavaLevel", this.lavaLevel);
        nbt.putInt("radius", this.radius);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider registries) {
        this.loadAdditional(pkt.getTag(), registries);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag nbt = new CompoundTag();
        this.saveAdditional(nbt, registries);
        return nbt;
    }

    public void setHeightOffset(int y) {
        this.heightOffset = y;
    }
}

