/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import java.util.Locale;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tropicraft.core.common.TropicraftTags;
import net.tropicraft.core.common.block.TropicraftBlocks;

public enum TropicraftFlower implements Supplier<Block>
{
    ACAI_VINE((Holder<MobEffect>)MobEffects.ABSORPTION, 0, 7, 16, null, BlockTags.SMALL_FLOWERS, TropicraftTags.Blocks.TROPICS_FLOWERS),
    ANEMONE((Holder<MobEffect>)MobEffects.WIND_CHARGED, 0, 9, null, BlockTags.SMALL_FLOWERS, TropicraftTags.Blocks.TROPICS_FLOWERS, TropicraftTags.Blocks.RAINFOREST_FLOWERS, TropicraftTags.Blocks.OVERWORLD_FLOWERS),
    BROMELIAD((Holder<MobEffect>)MobEffects.REGENERATION, 0, 9, null, BlockTags.SMALL_FLOWERS, TropicraftTags.Blocks.TROPICS_FLOWERS, TropicraftTags.Blocks.RAINFOREST_FLOWERS),
    CANNA((Holder<MobEffect>)MobEffects.INVISIBILITY, 0, Items.YELLOW_DYE, BlockTags.SMALL_FLOWERS, TropicraftTags.Blocks.TROPICS_FLOWERS, TropicraftTags.Blocks.RAINFOREST_FLOWERS),
    COMMELINA_DIFFUSA((Holder<MobEffect>)MobEffects.CONDUIT_POWER, 0, Items.LIGHT_BLUE_DYE, BlockTags.SMALL_FLOWERS, TropicraftTags.Blocks.TROPICS_FLOWERS, TropicraftTags.Blocks.RAINFOREST_FLOWERS, TropicraftTags.Blocks.OVERWORLD_FLOWERS),
    CROCOSMIA((Holder<MobEffect>)MobEffects.FIRE_RESISTANCE, 0, null, BlockTags.SMALL_FLOWERS, TropicraftTags.Blocks.TROPICS_FLOWERS, TropicraftTags.Blocks.RAINFOREST_FLOWERS),
    CROTON((Holder<MobEffect>)MobEffects.SATURATION, 0, 13, null, BlockTags.SMALL_FLOWERS, TropicraftTags.Blocks.TROPICS_FLOWERS),
    DRACAENA((Holder<MobEffect>)MobEffects.OOZING, 0, 13, Items.GREEN_DYE, BlockTags.SMALL_FLOWERS, TropicraftTags.Blocks.TROPICS_FLOWERS, TropicraftTags.Blocks.RAINFOREST_FLOWERS),
    TROPICAL_FERN((Holder<MobEffect>)MobEffects.REGENERATION, 0, 13, null, TropicraftTags.Blocks.TROPICS_FLOWERS),
    FOLIAGE((Holder<MobEffect>)MobEffects.REGENERATION, 0, 13, null, TropicraftTags.Blocks.TROPICS_FLOWERS),
    MAGIC_MUSHROOM((Holder<MobEffect>)MobEffects.BAD_OMEN, 0, 11, null, BlockTags.SMALL_FLOWERS, TropicraftTags.Blocks.RAINFOREST_FLOWERS),
    ORANGE_ANTHURIUM((Holder<MobEffect>)MobEffects.LUCK, 0, 11, Items.ORANGE_DYE, BlockTags.SMALL_FLOWERS, TropicraftTags.Blocks.TROPICS_FLOWERS, TropicraftTags.Blocks.RAINFOREST_FLOWERS, TropicraftTags.Blocks.OVERWORLD_FLOWERS),
    ORCHID((Holder<MobEffect>)MobEffects.SLOW_FALLING, 0, null, BlockTags.SMALL_FLOWERS, TropicraftTags.Blocks.TROPICS_FLOWERS, TropicraftTags.Blocks.RAINFOREST_FLOWERS, TropicraftTags.Blocks.OVERWORLD_FLOWERS),
    PATHOS((Holder<MobEffect>)MobEffects.REGENERATION, 0, 15, 12, null, TropicraftTags.Blocks.TROPICS_FLOWERS, TropicraftTags.Blocks.OVERWORLD_FLOWERS),
    RED_ANTHURIUM((Holder<MobEffect>)MobEffects.UNLUCK, 0, 11, Items.RED_DYE, BlockTags.SMALL_FLOWERS, TropicraftTags.Blocks.TROPICS_FLOWERS, TropicraftTags.Blocks.RAINFOREST_FLOWERS, TropicraftTags.Blocks.OVERWORLD_FLOWERS);

    private final Holder<MobEffect> effect;
    private final int effectDuration;
    private final VoxelShape shape;
    private final TagKey<Block>[] tags;
    @Nullable
    private final Item dye;

    @SafeVarargs
    private TropicraftFlower(@Nullable Holder<MobEffect> effect, int effectDuration, Item dye, TagKey<Block> ... tags) {
        this(effect, effectDuration, 7, dye, tags);
    }

    @SafeVarargs
    private TropicraftFlower(Holder<MobEffect> effect, @Nullable int effectDuration, int w, Item dye, TagKey<Block> ... tags) {
        this(effect, effectDuration, w, 15, dye, tags);
    }

    @SafeVarargs
    private TropicraftFlower(Holder<MobEffect> effect, int effectDuration, @Nullable int w, int h, Item dye, TagKey<Block> ... tags) {
        this(null, effect, effectDuration, w, h, dye, tags);
    }

    @SafeVarargs
    private TropicraftFlower(String name, Holder<MobEffect> effect, int effectDuration, @Nullable int w, int h, Item dye, TagKey<Block> ... tags) {
        this.effect = effect;
        this.effectDuration = effectDuration;
        this.dye = dye;
        this.tags = tags;
        float halfW = (float)w / 2.0f;
        this.shape = Block.box((double)(8.0f - halfW), (double)0.0, (double)(8.0f - halfW), (double)(8.0f + halfW), (double)h, (double)(8.0f + halfW));
    }

    public Holder<MobEffect> getEffect() {
        return this.effect;
    }

    public int getEffectDuration() {
        return this.effectDuration;
    }

    public VoxelShape getShape() {
        return this.shape;
    }

    public String getId() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    @Override
    public Block get() {
        return (Block)TropicraftBlocks.FLOWERS.get(this).get();
    }

    public TagKey<Block>[] getTags() {
        return this.tags;
    }

    @Nullable
    public Item getDye() {
        return this.dye;
    }
}

