/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Either;
import com.tterrag.registrate.Registrate;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.RegistrateItemModelProvider;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.providers.loot.RegistrateBlockLootTables;
import com.tterrag.registrate.util.DataIngredient;
import com.tterrag.registrate.util.entry.BlockEntityEntry;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemEnchantmentsPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicates;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PlaceOnWaterBlockItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.RedstoneWallTorchBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SeagrassBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.TallSeagrassBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockModelProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.Tags;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.client.TropicraftItemRenderers;
import net.tropicraft.core.client.tileentity.AirCompressorRenderer;
import net.tropicraft.core.client.tileentity.BambooChestRenderer;
import net.tropicraft.core.client.tileentity.DrinkMixerRenderer;
import net.tropicraft.core.client.tileentity.SifterRenderer;
import net.tropicraft.core.common.TropicraftTags;
import net.tropicraft.core.common.block.AirCompressorBlock;
import net.tropicraft.core.common.block.BambooChestBlock;
import net.tropicraft.core.common.block.BlockTropicraftSand;
import net.tropicraft.core.common.block.BoardwalkBlock;
import net.tropicraft.core.common.block.BongoDrumBlock;
import net.tropicraft.core.common.block.CoconutBlock;
import net.tropicraft.core.common.block.CoffeeBushBlock;
import net.tropicraft.core.common.block.CustomSeagrassBlock;
import net.tropicraft.core.common.block.CustomTallSeagrassBlock;
import net.tropicraft.core.common.block.DrinkMixerBlock;
import net.tropicraft.core.common.block.DuckweedBlock;
import net.tropicraft.core.common.block.FruitingBranchBlock;
import net.tropicraft.core.common.block.FruitingVineBlock;
import net.tropicraft.core.common.block.GrowableDoublePlantBlock;
import net.tropicraft.core.common.block.GrowableSinglePlantBlock;
import net.tropicraft.core.common.block.MahoganyNutBlock;
import net.tropicraft.core.common.block.MangroveLeavesBlock;
import net.tropicraft.core.common.block.MangroveRootsBlock;
import net.tropicraft.core.common.block.MudBlock;
import net.tropicraft.core.common.block.PapayaBlock;
import net.tropicraft.core.common.block.PineappleBlock;
import net.tropicraft.core.common.block.PortalWaterBlock;
import net.tropicraft.core.common.block.PropaguleBlock;
import net.tropicraft.core.common.block.ReedsBlock;
import net.tropicraft.core.common.block.ScientificNameBlock;
import net.tropicraft.core.common.block.SifterBlock;
import net.tropicraft.core.common.block.TikiTorchBlock;
import net.tropicraft.core.common.block.TropicraftFlower;
import net.tropicraft.core.common.block.TropicraftLeavesBlock;
import net.tropicraft.core.common.block.TropicraftLogBlock;
import net.tropicraft.core.common.block.TropicraftTreeGrowers;
import net.tropicraft.core.common.block.TropicraftWoodTypes;
import net.tropicraft.core.common.block.TropicsFlowerBlock;
import net.tropicraft.core.common.block.VolcanicSandBlock;
import net.tropicraft.core.common.block.VolcanoBlock;
import net.tropicraft.core.common.block.huge_plant.HugePlantBlock;
import net.tropicraft.core.common.block.jigarbov.JigarbovTorchType;
import net.tropicraft.core.common.block.tileentity.AirCompressorBlockEntity;
import net.tropicraft.core.common.block.tileentity.BambooChestBlockEntity;
import net.tropicraft.core.common.block.tileentity.DrinkMixerBlockEntity;
import net.tropicraft.core.common.block.tileentity.SifterBlockEntity;
import net.tropicraft.core.common.block.tileentity.VolcanoBlockEntity;
import net.tropicraft.core.common.item.TropicraftItems;
import net.tropicraft.core.mixin.BlockEntityTypeAccessor;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class TropicraftBlocks {
    private static final Registrate REGISTRATE = Tropicraft.registrate();
    private static final LootItemCondition.Builder HAS_SHEARS = MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(new ItemLike[]{Items.SHEARS}));
    private static final float[] FRUIT_SAPLING_RATES = new float[]{0.1f, 0.125f, 0.16666667f, 0.2f};
    private static final float[] SAPLING_RATES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};
    private static final float[] RARE_SAPLING_RATES = new float[]{0.025f, 0.027777778f, 0.03125f, 0.041666668f, 0.1f};
    public static final BlockEntry<PortalWaterBlock> TELEPORT_WATER;
    public static final BlockEntry<LiquidBlock> PORTAL_WATER;
    public static final BlockEntry<Block> CHUNK;
    public static final BlockEntry<DropExperienceBlock> AZURITE_ORE;
    public static final BlockEntry<DropExperienceBlock> EUDIALYTE_ORE;
    public static final BlockEntry<DropExperienceBlock> MANGANESE_ORE;
    public static final BlockEntry<DropExperienceBlock> SHAKA_ORE;
    public static final BlockEntry<DropExperienceBlock> ZIRCON_ORE;
    public static final BlockEntry<Block> AZURITE_BLOCK;
    public static final BlockEntry<Block> EUDIALYTE_BLOCK;
    public static final BlockEntry<Block> MANGANESE_BLOCK;
    public static final BlockEntry<Block> SHAKA_BLOCK;
    public static final BlockEntry<Block> ZIRCON_BLOCK;
    public static final BlockEntry<Block> ZIRCONIUM_BLOCK;
    public static final Map<TropicraftFlower, BlockEntry<TropicsFlowerBlock>> FLOWERS;
    public static final BlockEntry<BlockTropicraftSand> PURIFIED_SAND;
    public static final BlockEntry<Block> PACKED_PURIFIED_SAND;
    public static final BlockEntry<BlockTropicraftSand> CORAL_SAND;
    public static final BlockEntry<BlockTropicraftSand> FOAMY_SAND;
    public static final BlockEntry<VolcanicSandBlock> VOLCANIC_SAND;
    public static final BlockEntry<BlockTropicraftSand> MINERAL_SAND;
    public static final BlockEntry<MudBlock> MUD;
    public static final BlockEntry<Block> MUD_WITH_PIANGUAS;
    public static final BlockEntry<RotatedPillarBlock> BAMBOO_BUNDLE;
    public static final BlockEntry<RotatedPillarBlock> THATCH_BUNDLE;
    public static final BlockEntry<Block> MAHOGANY_PLANKS;
    public static final BlockEntry<Block> PALM_PLANKS;
    public static final BlockEntry<RotatedPillarBlock> MAHOGANY_LOG;
    public static final BlockEntry<RotatedPillarBlock> PALM_LOG;
    public static final BlockEntry<RotatedPillarBlock> MAHOGANY_WOOD;
    public static final BlockEntry<RotatedPillarBlock> PALM_WOOD;
    public static final BlockEntry<StairBlock> PALM_STAIRS;
    public static final BlockEntry<StairBlock> MAHOGANY_STAIRS;
    public static final BlockEntry<StairBlock> THATCH_STAIRS;
    public static final BlockEntry<StairBlock> THATCH_STAIRS_FUZZY;
    public static final BlockEntry<StairBlock> BAMBOO_STAIRS;
    public static final BlockEntry<StairBlock> CHUNK_STAIRS;
    public static final BlockEntry<CoconutBlock> COCONUT;
    public static final BlockEntry<SlabBlock> BAMBOO_SLAB;
    public static final BlockEntry<SlabBlock> THATCH_SLAB;
    public static final BlockEntry<SlabBlock> CHUNK_SLAB;
    public static final BlockEntry<SlabBlock> PALM_SLAB;
    public static final BlockEntry<SlabBlock> MAHOGANY_SLAB;
    public static final BlockEntry<SaplingBlock> GRAPEFRUIT_SAPLING;
    public static final BlockEntry<SaplingBlock> LEMON_SAPLING;
    public static final BlockEntry<SaplingBlock> LIME_SAPLING;
    public static final BlockEntry<SaplingBlock> ORANGE_SAPLING;
    public static final BlockEntry<SaplingBlock> PAPAYA_SAPLING;
    public static final BlockEntry<SaplingBlock> MAHOGANY_SAPLING;
    public static final BlockEntry<SaplingBlock> PALM_SAPLING;
    public static final BlockEntry<LeavesBlock> MAHOGANY_LEAVES;
    public static final BlockEntry<LeavesBlock> PALM_LEAVES;
    public static final BlockEntry<LeavesBlock> KAPOK_LEAVES;
    public static final BlockEntry<LeavesBlock> FRUIT_LEAVES;
    public static final BlockEntry<LeavesBlock> GRAPEFRUIT_LEAVES;
    public static final BlockEntry<LeavesBlock> LEMON_LEAVES;
    public static final BlockEntry<LeavesBlock> LIME_LEAVES;
    public static final BlockEntry<LeavesBlock> ORANGE_LEAVES;
    public static final BlockEntry<LeavesBlock> PAPAYA_LEAVES;
    public static final BlockEntry<LeavesBlock> WHITE_FLOWERING_LEAVES;
    public static final BlockEntry<LeavesBlock> RED_FLOWERING_LEAVES;
    public static final BlockEntry<LeavesBlock> BLUE_FLOWERING_LEAVES;
    public static final BlockEntry<LeavesBlock> PURPLE_FLOWERING_LEAVES;
    public static final BlockEntry<LeavesBlock> YELLOW_FLOWERING_LEAVES;
    public static final BlockEntry<FruitingVineBlock> PASSIONFRUIT_VINE;
    public static final BlockEntry<RotatedPillarBlock> PAPAYA_LOG;
    public static final BlockEntry<RotatedPillarBlock> PAPAYA_WOOD;
    public static final BlockEntry<SaplingBlock> PLANTAIN_SAPLING;
    public static final BlockEntry<RotatedPillarBlock> PLANTAIN_STEM;
    public static final BlockEntry<LeavesBlock> PLANTAIN_LEAVES;
    public static final BlockEntry<Block> GREEN_PLANTAIN_BUNCH;
    public static final BlockEntry<Block> YELLOW_PLANTAIN_BUNCH;
    public static final BlockEntry<SaplingBlock> JOCOTE_SAPLING;
    public static final BlockEntry<RotatedPillarBlock> JOCOTE_LOG;
    public static final BlockEntry<LeavesBlock> JOCOTE_LEAVES;
    public static final BlockEntry<FruitingBranchBlock> JOCOTE_BRANCH;
    public static final BlockEntry<MahoganyNutBlock> MAHOGANY_NUT;
    public static final BlockEntry<RotatedPillarBlock> RED_MANGROVE_LOG;
    public static final BlockEntry<RotatedPillarBlock> RED_MANGROVE_WOOD;
    public static final BlockEntry<MangroveRootsBlock> RED_MANGROVE_ROOTS;
    public static final BlockEntry<RotatedPillarBlock> LIGHT_MANGROVE_LOG;
    public static final BlockEntry<RotatedPillarBlock> LIGHT_MANGROVE_WOOD;
    public static final BlockEntry<MangroveRootsBlock> LIGHT_MANGROVE_ROOTS;
    public static final BlockEntry<RotatedPillarBlock> BLACK_MANGROVE_LOG;
    public static final BlockEntry<RotatedPillarBlock> BLACK_MANGROVE_WOOD;
    public static final BlockEntry<MangroveRootsBlock> BLACK_MANGROVE_ROOTS;
    public static final BlockEntry<MangroveLeavesBlock> RED_MANGROVE_LEAVES;
    public static final BlockEntry<MangroveLeavesBlock> TALL_MANGROVE_LEAVES;
    public static final BlockEntry<MangroveLeavesBlock> TEA_MANGROVE_LEAVES;
    public static final BlockEntry<MangroveLeavesBlock> BLACK_MANGROVE_LEAVES;
    public static final BlockEntry<PropaguleBlock> RED_MANGROVE_PROPAGULE;
    public static final BlockEntry<PropaguleBlock> TALL_MANGROVE_PROPAGULE;
    public static final BlockEntry<PropaguleBlock> TEA_MANGROVE_PROPAGULE;
    public static final BlockEntry<PropaguleBlock> BLACK_MANGROVE_PROPAGULE;
    public static final BlockEntry<RotatedPillarBlock> STRIPPED_MANGROVE_LOG;
    public static final BlockEntry<RotatedPillarBlock> STRIPPED_MANGROVE_WOOD;
    public static final BlockEntry<Block> MANGROVE_PLANKS;
    public static final BlockEntry<StairBlock> MANGROVE_STAIRS;
    public static final BlockEntry<SlabBlock> MANGROVE_SLAB;
    public static final BlockEntry<FenceBlock> MANGROVE_FENCE;
    public static final BlockEntry<FenceGateBlock> MANGROVE_FENCE_GATE;
    public static final BlockEntry<DoorBlock> MANGROVE_DOOR;
    public static final BlockEntry<TrapDoorBlock> MANGROVE_TRAPDOOR;
    public static final BlockEntry<ButtonBlock> MANGROVE_BUTTON;
    public static final BlockEntry<ButtonBlock> MAHOGANY_BUTTON;
    public static final BlockEntry<ButtonBlock> PALM_BUTTON;
    public static final BlockEntry<ButtonBlock> BAMBOO_BUTTON;
    public static final BlockEntry<ButtonBlock> THATCH_BUTTON;
    public static final BlockEntry<PressurePlateBlock> MANGROVE_PRESSURE_PLATE;
    public static final BlockEntry<PressurePlateBlock> MAHOGANY_PRESSURE_PLATE;
    public static final BlockEntry<PressurePlateBlock> PALM_PRESSURE_PLATE;
    public static final BlockEntry<PressurePlateBlock> BAMBOO_PRESSURE_PLATE;
    public static final BlockEntry<PressurePlateBlock> THATCH_PRESSURE_PLATE;
    public static final BlockEntry<StandingSignBlock> MAHOGANY_SIGN;
    public static final BlockEntry<StandingSignBlock> PALM_SIGN;
    public static final BlockEntry<StandingSignBlock> BAMBOO_SIGN;
    public static final BlockEntry<StandingSignBlock> THATCH_SIGN;
    public static final BlockEntry<StandingSignBlock> MANGROVE_SIGN;
    public static final BlockEntry<WallSignBlock> MAHOGANY_WALL_SIGN;
    public static final BlockEntry<WallSignBlock> PALM_WALL_SIGN;
    public static final BlockEntry<WallSignBlock> BAMBOO_WALL_SIGN;
    public static final BlockEntry<WallSignBlock> THATCH_WALL_SIGN;
    public static final BlockEntry<WallSignBlock> MANGROVE_WALL_SIGN;
    public static final BlockEntry<ReedsBlock> REEDS;
    public static final BlockEntry<PapayaBlock> PAPAYA;
    public static final BlockEntry<FenceBlock> BAMBOO_FENCE;
    public static final BlockEntry<FenceBlock> THATCH_FENCE;
    public static final BlockEntry<FenceBlock> CHUNK_FENCE;
    public static final BlockEntry<FenceBlock> PALM_FENCE;
    public static final BlockEntry<FenceBlock> MAHOGANY_FENCE;
    public static final BlockEntry<FenceGateBlock> BAMBOO_FENCE_GATE;
    public static final BlockEntry<FenceGateBlock> THATCH_FENCE_GATE;
    public static final BlockEntry<FenceGateBlock> CHUNK_FENCE_GATE;
    public static final BlockEntry<FenceGateBlock> PALM_FENCE_GATE;
    public static final BlockEntry<FenceGateBlock> MAHOGANY_FENCE_GATE;
    public static final BlockEntry<WallBlock> CHUNK_WALL;
    public static final BlockEntry<DoorBlock> BAMBOO_DOOR;
    public static final BlockEntry<DoorBlock> PALM_DOOR;
    public static final BlockEntry<DoorBlock> MAHOGANY_DOOR;
    public static final BlockEntry<DoorBlock> THATCH_DOOR;
    public static final BlockEntry<TrapDoorBlock> BAMBOO_TRAPDOOR;
    public static final BlockEntry<TrapDoorBlock> PALM_TRAPDOOR;
    public static final BlockEntry<TrapDoorBlock> MAHOGANY_TRAPDOOR;
    public static final BlockEntry<TrapDoorBlock> THATCH_TRAPDOOR;
    public static final BlockEntry<TallFlowerBlock> IRIS;
    public static final BlockEntry<PineappleBlock> PINEAPPLE;
    public static final BlockEntry<BongoDrumBlock> SMALL_BONGO_DRUM;
    public static final BlockEntry<BongoDrumBlock> MEDIUM_BONGO_DRUM;
    public static final BlockEntry<BongoDrumBlock> LARGE_BONGO_DRUM;
    public static final BlockEntry<LadderBlock> BAMBOO_LADDER;
    public static final BlockEntry<BoardwalkBlock> BAMBOO_BOARDWALK;
    public static final BlockEntry<BoardwalkBlock> PALM_BOARDWALK;
    public static final BlockEntry<BoardwalkBlock> MAHOGANY_BOARDWALK;
    public static final BlockEntry<BoardwalkBlock> MANGROVE_BOARDWALK;
    public static final BlockEntry<BambooChestBlock> BAMBOO_CHEST;
    public static final BlockEntityEntry<BambooChestBlockEntity> BAMBOO_CHEST_ENTITY;
    public static final BlockEntry<SifterBlock> SIFTER;
    public static final BlockEntityEntry<SifterBlockEntity> SIFTER_ENTITY;
    public static final BlockEntry<DrinkMixerBlock> DRINK_MIXER;
    public static final BlockEntityEntry<DrinkMixerBlockEntity> DRINK_MIXER_ENTITY;
    public static final BlockEntry<AirCompressorBlock> AIR_COMPRESSOR;
    public static final BlockEntityEntry<AirCompressorBlockEntity> AIR_COMPRESSOR_ENTITY;
    public static final BlockEntry<VolcanoBlock> VOLCANO;
    public static final BlockEntityEntry<VolcanoBlockEntity> VOLCANO_ENTITY;
    public static final BlockEntry<TikiTorchBlock> TIKI_TORCH;
    public static final BlockEntry<FlowerPotBlock> BAMBOO_FLOWER_POT;
    public static final BlockEntry<CoffeeBushBlock> COFFEE_BUSH;
    public static final BlockEntry<GrowableSinglePlantBlock> GOLDEN_LEATHER_FERN;
    public static final BlockEntry<GrowableDoublePlantBlock> TALL_GOLDEN_LEATHER_FERN;
    public static final BlockEntry<HugePlantBlock> LARGE_GOLDEN_LEATHER_FERN;
    public static final BlockEntry<WaterlilyBlock> FLOWERING_LILY_PAD;
    public static final BlockEntry<DuckweedBlock> DUCKWEED;
    public static final BlockEntry<CustomSeagrassBlock> EEL_GRASS;
    public static final BlockEntry<CustomTallSeagrassBlock> TALL_EEL_GRASS;
    public static final BlockEntry<CustomSeagrassBlock> FLOWERING_EEL_GRASS;
    public static final BlockEntry<CustomTallSeagrassBlock> FLOWERING_TALL_EEL_GRASS;
    public static final BlockEntry<ScientificNameBlock> MATTED_EEL_GRASS;
    public static final BlockEntry<ScientificNameBlock> EEL_GRASS_BLOCK;
    public static final BlockEntry<CustomSeagrassBlock> FERN_SEAGRASS;
    public static final BlockEntry<CustomTallSeagrassBlock> TALL_FERN_SEAGRASS;
    public static final BlockEntry<ScientificNameBlock> MATTED_FERN_SEAGRASS;
    public static final BlockEntry<ScientificNameBlock> FERN_SEAGRASS_BLOCK;
    public static final BlockEntry<CustomSeagrassBlock> SICKLE_SEAGRASS;
    public static final BlockEntry<CustomTallSeagrassBlock> TALL_SICKLE_SEAGRASS;
    public static final BlockEntry<ScientificNameBlock> MATTED_SICKLE_SEAGRASS;
    public static final BlockEntry<ScientificNameBlock> SICKLE_SEAGRASS_BLOCK;
    public static final BlockEntry<CustomSeagrassBlock> NOODLE_SEAGRASS;
    public static final BlockEntry<ScientificNameBlock> MATTED_NOODLE_SEAGRASS;
    public static final BlockEntry<ScientificNameBlock> NOODLE_SEAGRASS_BLOCK;
    private static final Set<BlockEntry<? extends Block>> POTTABLE_PLANTS;
    public static final List<BlockEntry<FlowerPotBlock>> BAMBOO_POTTED_TROPICS_PLANTS;
    public static final List<BlockEntry<FlowerPotBlock>> VANILLA_POTTED_TROPICS_PLANTS;
    public static final List<BlockEntry<FlowerPotBlock>> BAMBOO_POTTED_VANILLA_PLANTS;
    public static final List<BlockEntry<FlowerPotBlock>> ALL_POTTED_PLANTS;
    public static final Map<JigarbovTorchType, BlockEntry<? extends RedstoneWallTorchBlock>> JIGARBOV_WALL_TORCHES;

    private static LootItemCondition.Builder hasSilkTouch(RegistrateBlockLootTables loot) {
        HolderLookup.RegistryLookup enchantments = loot.getRegistries().lookupOrThrow(Registries.ENCHANTMENT);
        return MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().withSubPredicate(ItemSubPredicates.ENCHANTMENTS, (ItemSubPredicate)ItemEnchantmentsPredicate.enchantments(List.of(new EnchantmentPredicate((Holder)enchantments.getOrThrow(Enchantments.SILK_TOUCH), MinMaxBounds.Ints.atLeast((int)1))))));
    }

    private static LootItemCondition.Builder hasNoSilkTouch(RegistrateBlockLootTables loot) {
        return TropicraftBlocks.hasSilkTouch(loot).invert();
    }

    private static LootItemCondition.Builder hasShearsOrSilkTouch(RegistrateBlockLootTables loot) {
        return HAS_SHEARS.or(TropicraftBlocks.hasSilkTouch(loot));
    }

    private static LootItemCondition.Builder hasNoShearsOrSilkTouch(RegistrateBlockLootTables loot) {
        return TropicraftBlocks.hasShearsOrSilkTouch(loot).invert();
    }

    private static Holder.Reference<Enchantment> fortune(RegistrateBlockLootTables loot) {
        return loot.getRegistries().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.FORTUNE);
    }

    private static void registerPlankRecipe(RegistrateRecipeProvider prov, Supplier<ItemLike> logOrWood, Block output) {
        prov.singleItemUnfinished(DataIngredient.items((ItemLike)logOrWood.get(), (ItemLike[])new ItemLike[0]), RecipeCategory.BUILDING_BLOCKS, () -> output, 1, 4).group("planks").save((RecipeOutput)prov, String.valueOf(prov.safeId((ItemLike)output)) + "_from_" + prov.safeName(logOrWood.get()));
    }

    private static BlockBuilder<DropExperienceBlock, Registrate> ore(String name, MapColor color) {
        return (BlockBuilder)REGISTRATE.block(name, p -> new DropExperienceBlock((IntProvider)UniformInt.of((int)0, (int)2), p)).initialProperties(() -> Blocks.STONE).properties(p -> p.strength(3.0f).mapColor(color)).tag(new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE, Tags.Blocks.ORES}).item().tag(new TagKey[]{Tags.Items.ORES}).build();
    }

    private static BlockBuilder<DropExperienceBlock, Registrate> ore(String name, Supplier<Item> gem, MapColor color) {
        return REGISTRATE.block(name, p -> new DropExperienceBlock((IntProvider)UniformInt.of((int)0, (int)2), p)).initialProperties(() -> Blocks.STONE).properties(p -> p.strength(3.0f).mapColor(color)).loot((loot, block) -> loot.add((Block)block, loot.createSilkTouchDispatchTable((Block)block, (LootPoolEntryContainer.Builder)loot.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)gem.get())).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount(TropicraftBlocks.fortune(loot))))))).tag(new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE, Tags.Blocks.ORES}).simpleItem();
    }

    private static BlockBuilder<Block, Registrate> oreStorageBlock(String name, MapColor color, ItemEntry<Item> ingredient) {
        return REGISTRATE.block(name, Block::new).properties(p -> p.requiresCorrectToolForDrops().mapColor(color).sound(SoundType.METAL).destroyTime(5.0f).explosionResistance(6.0f)).tag(new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE}).recipe((ctx, prov) -> prov.storage((NonNullSupplier)ingredient, RecipeCategory.BUILDING_BLOCKS, (NonNullSupplier)ctx)).simpleItem();
    }

    private static BlockEntry<Block> plantainBunch(String name, Supplier<ItemEntry<Item>> item) {
        return REGISTRATE.block(name, Block::new).initialProperties(() -> Blocks.MELON).properties(p -> p.sound(SoundType.WART_BLOCK).strength(0.5f)).tag(new TagKey[]{BlockTags.MINEABLE_WITH_HOE}).loot((tables, block) -> tables.add(block, tables.createSingleItemTableWithSilkTouch(block, (ItemLike)((ItemEntry)item.get()).get(), (NumberProvider)UniformGenerator.between((float)3.0f, (float)5.0f)))).simpleItem().register();
    }

    private static BlockBuilder<BongoDrumBlock, Registrate> bongoDrum(String name, BongoDrumBlock.Size size) {
        return REGISTRATE.block(name, p -> new BongoDrumBlock(size, (BlockBehaviour.Properties)p)).properties(p -> p.mapColor(MapColor.TERRACOTTA_WHITE).strength(2.0f).sound(SoundType.WOOD).ignitedByLava().instrument(NoteBlockInstrument.BASS)).tag(new TagKey[]{TropicraftTags.Blocks.BONGOS}).blockstate((ctx, prov) -> {
            AABB bb = size.shape.bounds();
            prov.simpleBlock((Block)ctx.get(), (ModelFile)((BlockModelBuilder)prov.models().cubeBottomTop(ctx.getName(), prov.modLoc("block/bongo_side"), prov.modLoc("block/bongo_bottom"), prov.modLoc("block/bongo_top"))).element().from((float)bb.minX * 16.0f, (float)bb.minY * 16.0f, (float)bb.minZ * 16.0f).to((float)bb.maxX * 16.0f, (float)bb.maxY * 16.0f, (float)bb.maxZ * 16.0f).allFaces((dir, face) -> face.texture(dir.getAxis().isHorizontal() ? "#side" : (dir == Direction.DOWN ? "#bottom" : "#top")).cullface((Direction)(dir.getAxis().isVertical() ? dir : null))).end());
        }).recipe((ctx, prov) -> ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get())).pattern(StringUtils.repeat((char)'T', (int)size.recipeColumns)).pattern(StringUtils.repeat((char)'B', (int)size.recipeColumns)).pattern(StringUtils.repeat((char)'B', (int)size.recipeColumns)).define(Character.valueOf('T'), (ItemLike)TropicraftItems.IGUANA_LEATHER.get()).define(Character.valueOf('B'), (ItemLike)MAHOGANY_PLANKS.get()).group("tropicraft:bongos").unlockedBy("has_" + prov.safeName((ItemLike)TropicraftItems.IGUANA_LEATHER.get()), RegistrateRecipeProvider.has((ItemLike)((ItemLike)TropicraftItems.IGUANA_LEATHER.get()))).save((RecipeOutput)prov)).simpleItem();
    }

    private static BlockBuilder<CustomSeagrassBlock, Registrate> seagrass(String name, String scientificName, @Nullable Supplier<BlockEntry<? extends TallSeagrassBlock>> tall) {
        return (BlockBuilder)REGISTRATE.block(name, p -> new CustomSeagrassBlock((BlockBehaviour.Properties)p, scientificName, () -> TropicraftBlocks.lambda$seagrass$251((Supplier)tall))).initialProperties(() -> Blocks.SEAGRASS).loot((loot, block) -> loot.add((Block)block, TropicraftBlocks.onlyWithSilkTouchOrShears(loot, (Block)block))).addLayer(() -> RenderType::cutout).blockstate((ctx, prov) -> {
            ResourceLocation texture = prov.blockTexture((Block)ctx.get());
            prov.simpleBlock((Block)ctx.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName(), prov.mcLoc("template_seagrass"))).texture("texture", texture)).texture("particle", texture));
        }).item().model(TropicraftBlocks::blockSprite).build();
    }

    private static BlockBuilder<CustomTallSeagrassBlock, Registrate> tallSeagrass(String name, String scientificName, BlockEntry<? extends SeagrassBlock> normal) {
        return REGISTRATE.block(name, p -> new CustomTallSeagrassBlock((BlockBehaviour.Properties)p, scientificName, () -> ((BlockEntry)normal).get())).initialProperties(() -> Blocks.SEAGRASS).loot((loot, block) -> loot.add((Block)block, TropicraftBlocks.onlyWithSilkTouchOrShears(loot, (Block)normal.get()))).addLayer(() -> RenderType::cutout).blockstate((ctx, prov) -> {
            ModelBuilder top = ((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_top", prov.mcLoc("template_seagrass"))).texture("texture", prov.modLoc("block/" + ctx.getName() + "_top"))).texture("particle", prov.modLoc("block/" + ctx.getName() + "_top"));
            ModelBuilder bottom = ((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_bottom", prov.mcLoc("template_seagrass"))).texture("texture", prov.modLoc("block/" + ctx.getName() + "_bottom"))).texture("particle", prov.modLoc("block/" + ctx.getName() + "_bottom"));
            MultiPartBlockStateBuilder builder = prov.getMultipartBuilder((Block)ctx.get());
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)top).addModel()).condition((Property)TallSeagrassBlock.HALF, (Comparable[])new DoubleBlockHalf[]{DoubleBlockHalf.UPPER}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)bottom).addModel()).condition((Property)TallSeagrassBlock.HALF, (Comparable[])new DoubleBlockHalf[]{DoubleBlockHalf.LOWER}).end();
        });
    }

    private static BlockBuilder<ScientificNameBlock, Registrate> seagrassBlock(String name, String scientificName) {
        return REGISTRATE.block(name + "_block", p -> new ScientificNameBlock((BlockBehaviour.Properties)p, scientificName)).initialProperties(() -> Blocks.SAND).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().cubeAll(ctx.getName(), prov.modLoc("block/matted_" + name + "_top")))).simpleItem();
    }

    private static BlockBuilder<ScientificNameBlock, Registrate> mattedSeagrassBlock(String name, String scientificName) {
        return REGISTRATE.block(name, p -> new ScientificNameBlock((BlockBehaviour.Properties)p, scientificName)).initialProperties(() -> Blocks.SAND).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().cubeBottomTop(ctx.getName(), prov.modLoc("block/" + ctx.getName() + "_side"), prov.modLoc("block/" + PURIFIED_SAND.getId().getPath()), prov.modLoc("block/" + ctx.getName() + "_top")))).simpleItem();
    }

    private static BlockEntry<FlowerPotBlock> bambooPot(String name, Supplier<? extends Block> plant) {
        return REGISTRATE.block(name, p -> new FlowerPotBlock(BAMBOO_FLOWER_POT, plant, p)).properties(p -> p.strength(0.2f, 5.0f).sound(SoundType.BAMBOO).pushReaction(PushReaction.DESTROY)).loot((loot, block) -> loot.add((Block)block, TropicraftBlocks.pottedPlantLoot(loot, block))).addLayer(() -> RenderType::cutout).tag(new TagKey[]{BlockTags.FLOWER_POTS}).blockstate((ctx, prov) -> TropicraftBlocks.flowerPot((DataGenContext<Block, ? extends FlowerPotBlock>)ctx, prov, BAMBOO_FLOWER_POT, prov.modLoc("block/bamboo_side"))).register();
    }

    private static BlockEntry<FlowerPotBlock> vanillaPot(String name, Supplier<? extends Block> plant) {
        return REGISTRATE.block(name, p -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, plant, p)).initialProperties(() -> Blocks.FLOWER_POT).loot((loot, block) -> loot.add((Block)block, TropicraftBlocks.pottedPlantLoot(loot, block))).addLayer(() -> RenderType::cutout).tag(new TagKey[]{BlockTags.FLOWER_POTS}).blockstate((ctx, prov) -> TropicraftBlocks.flowerPot((DataGenContext<Block, ? extends FlowerPotBlock>)ctx, prov, () -> Blocks.FLOWER_POT, ResourceLocation.withDefaultNamespace((String)"block/flower_pot"))).register();
    }

    private static void flowerPot(DataGenContext<Block, ? extends FlowerPotBlock> ctx, RegistrateBlockstateProvider prov, Supplier<? extends Block> empty, ResourceLocation particle) {
        Block flower = ((FlowerPotBlock)ctx.get()).getPotted();
        boolean isVanilla = flower.builtInRegistryHolder().key().location().getNamespace().equals("minecraft");
        String flowerName = TropicraftBlocks.name((ItemLike)flower);
        String parent = flower == Blocks.AIR ? "flower_pot" : (!isVanilla ? "flower_pot_cross" : "block/potted_" + flowerName);
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName(), parent)).texture("flowerpot", prov.blockTexture(empty.get()))).texture("dirt", prov.mcLoc("block/dirt"))).texture("particle", prov.modLoc("block/bamboo_side"));
        if (!isVanilla) {
            if (flower instanceof TropicsFlowerBlock) {
                model.texture("plant", prov.modLoc("block/flower/" + flowerName));
            } else if (flower instanceof TallFlowerBlock) {
                model.texture("plant", prov.modLoc("block/" + flowerName + "_top"));
            } else {
                model.texture("plant", prov.blockTexture(flower));
            }
        }
        prov.simpleBlock((Block)ctx.get(), (ModelFile)model);
    }

    private static LootTable.Builder pottedPlantLoot(RegistrateBlockLootTables loot, FlowerPotBlock fullPot) {
        return LootTable.lootTable().withPool((LootPool.Builder)loot.applyExplosionCondition((ItemLike)fullPot.getEmptyPot(), (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)fullPot.getEmptyPot())))).withPool((LootPool.Builder)loot.applyExplosionCondition((ItemLike)fullPot.getPotted(), (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)fullPot.getPotted()))));
    }

    private static BlockBuilder<StairBlock, Registrate> stoneStairs(String name, BlockEntry<? extends Block> block) {
        return TropicraftBlocks.stairs(name, block, (TagKey<Block>)BlockTags.STAIRS, (TagKey<Item>)ItemTags.STAIRS).recipe((ctx, prov) -> prov.stairs(DataIngredient.items((ItemLike)((Block)block.get()), (ItemLike[])new Block[0]), RecipeCategory.BUILDING_BLOCKS, (Supplier)ctx, null, true)).tag(new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE});
    }

    private static BlockBuilder<StairBlock, Registrate> woodenStairs(String name, BlockEntry<? extends Block> block) {
        return TropicraftBlocks.stairs(name, block, (TagKey<Block>)BlockTags.WOODEN_STAIRS, (TagKey<Item>)ItemTags.WOODEN_STAIRS).recipe((ctx, prov) -> prov.stairs(DataIngredient.items((ItemLike)((Block)block.get()), (ItemLike[])new Block[0]), RecipeCategory.BUILDING_BLOCKS, (Supplier)ctx, "wooden_stairs", false)).tag(new TagKey[]{BlockTags.MINEABLE_WITH_AXE});
    }

    private static BlockBuilder<StairBlock, Registrate> stairs(String name, BlockEntry<? extends Block> block, TagKey<Block> blockTag, TagKey<Item> itemTag) {
        return (BlockBuilder)REGISTRATE.block(name, p -> new StairBlock(((Block)block.get()).defaultBlockState(), p)).initialProperties(block).tag(new TagKey[]{blockTag}).blockstate((ctx, prov) -> prov.stairsBlock((StairBlock)ctx.get(), prov.blockTexture((Block)block.get()))).item().tag(new TagKey[]{itemTag}).build();
    }

    private static BlockBuilder<SlabBlock, Registrate> stoneSlab(String name, BlockEntry<? extends Block> block) {
        return TropicraftBlocks.slab(name, block, (TagKey<Block>)BlockTags.SLABS, (TagKey<Item>)ItemTags.SLABS).recipe((ctx, prov) -> prov.slab(DataIngredient.items((ItemLike)((Block)block.get()), (ItemLike[])new Block[0]), RecipeCategory.BUILDING_BLOCKS, (Supplier)ctx, null, true)).tag(new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE});
    }

    private static BlockBuilder<SlabBlock, Registrate> woodenSlab(String name, BlockEntry<? extends Block> block) {
        return TropicraftBlocks.slab(name, block, (TagKey<Block>)BlockTags.WOODEN_SLABS, (TagKey<Item>)ItemTags.WOODEN_SLABS).recipe((ctx, prov) -> prov.slab(DataIngredient.items((ItemLike)((Block)block.get()), (ItemLike[])new Block[0]), RecipeCategory.BUILDING_BLOCKS, (Supplier)ctx, "wooden_slab", false)).tag(new TagKey[]{BlockTags.MINEABLE_WITH_AXE});
    }

    private static BlockBuilder<SlabBlock, Registrate> slab(String name, BlockEntry<? extends Block> block, TagKey<Block> blockTag, TagKey<Item> itemTag) {
        return (BlockBuilder)REGISTRATE.block(name, SlabBlock::new).initialProperties(block).loot((loot, slab) -> loot.add((Block)slab, loot.createSlabItemTable((Block)slab))).tag(new TagKey[]{blockTag}).blockstate((ctx, prov) -> prov.slabBlock((SlabBlock)ctx.get(), block.getId(), prov.blockTexture((Block)block.get()))).item().tag(new TagKey[]{itemTag}).build();
    }

    private static BlockBuilder<ButtonBlock, Registrate> woodButton(String name, BlockEntry<? extends Block> block, String texture) {
        return (BlockBuilder)REGISTRATE.block(name, p -> new ButtonBlock(BlockSetType.OAK, 30, p)).initialProperties(block).properties(p -> p.noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY)).tag(new TagKey[]{BlockTags.WOODEN_BUTTONS, BlockTags.MINEABLE_WITH_AXE}).blockstate((ctx, prov) -> prov.buttonBlock((ButtonBlock)ctx.get(), prov.modLoc("block/" + texture))).recipe((ctx, prov) -> RegistrateRecipeProvider.buttonBuilder((ItemLike)((ItemLike)ctx.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{block.asItem()})).unlockedBy("has_" + prov.safeName((ItemLike)block.get()), RegistrateRecipeProvider.has((ItemLike)((ItemLike)block.get()))).group("wooden_button").save((RecipeOutput)prov)).item().model((ctx, prov) -> prov.buttonInventory(ctx.getName(), prov.modLoc("block/" + texture))).tag(new TagKey[]{ItemTags.WOODEN_BUTTONS}).build();
    }

    private static BlockBuilder<PressurePlateBlock, Registrate> pressurePlate(String name, BlockEntry<? extends Block> block, String texture) {
        return (BlockBuilder)REGISTRATE.block(name, p -> new PressurePlateBlock(BlockSetType.OAK, p)).initialProperties(block).properties(p -> p.forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollission().strength(0.5f).ignitedByLava().pushReaction(PushReaction.DESTROY)).tag(new TagKey[]{BlockTags.WOODEN_PRESSURE_PLATES, BlockTags.MINEABLE_WITH_AXE}).recipe((ctx, prov) -> RegistrateRecipeProvider.pressurePlateBuilder((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ctx.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{block.asItem()})).unlockedBy("has_" + prov.safeName((ItemLike)block.get()), RegistrateRecipeProvider.has((ItemLike)((ItemLike)block.get()))).group("wooden_pressure_plate").save((RecipeOutput)prov)).blockstate((ctx, prov) -> prov.pressurePlateBlock((PressurePlateBlock)ctx.get(), prov.modLoc("block/" + texture))).item().model((ctx, prov) -> prov.pressurePlate(ctx.getName(), prov.modLoc("block/" + texture))).build();
    }

    private static BlockBuilder<StandingSignBlock, Registrate> standingSign(WoodType woodType, Supplier<? extends Item> item, String texture) {
        String woodName = ResourceLocation.parse((String)woodType.name()).getPath();
        return (BlockBuilder)((BlockBuilder)REGISTRATE.block(woodName + "_sign", p -> new StandingSignBlock(woodType, p)).initialProperties(() -> Blocks.OAK_SIGN).tag(new TagKey[]{BlockTags.STANDING_SIGNS, BlockTags.MINEABLE_WITH_AXE}).blockstate((ctx, prov) -> {
            BlockModelBuilder model = (BlockModelBuilder)prov.models().sign(woodName + "_sign", prov.modLoc("block/" + texture));
            prov.simpleBlock((Block)ctx.get(), (ModelFile)model);
        }).loot((loot, b) -> loot.dropOther((Block)b, (ItemLike)item.get())).setData(ProviderType.LANG, NonNullBiConsumer.noop())).onRegisterAfter(Registries.BLOCK_ENTITY_TYPE, b -> TropicraftBlocks.extendBlockEntity(BlockEntityType.SIGN, (Block)b));
    }

    private static BlockBuilder<WallSignBlock, Registrate> wallSign(WoodType woodType, Supplier<? extends Item> item, String texture) {
        String woodName = ResourceLocation.parse((String)woodType.name()).getPath();
        return (BlockBuilder)((BlockBuilder)REGISTRATE.block(woodName + "_wall_sign", p -> new WallSignBlock(woodType, p)).initialProperties(() -> Blocks.OAK_WALL_SIGN).tag(new TagKey[]{BlockTags.WALL_SIGNS, BlockTags.MINEABLE_WITH_AXE}).blockstate((ctx, prov) -> {
            BlockModelBuilder model = (BlockModelBuilder)prov.models().sign(woodName + "_sign", prov.modLoc("block/" + texture));
            prov.simpleBlock((Block)ctx.get(), (ModelFile)model);
        }).loot((loot, b) -> loot.dropOther((Block)b, (ItemLike)item.get())).setData(ProviderType.LANG, NonNullBiConsumer.noop())).onRegisterAfter(Registries.BLOCK_ENTITY_TYPE, b -> TropicraftBlocks.extendBlockEntity(BlockEntityType.SIGN, (Block)b));
    }

    @SafeVarargs
    private static BlockBuilder<SaplingBlock, Registrate> sapling(String name, TreeGrower tree, final Supplier<? extends Block> ... validPlantBlocks) {
        return (BlockBuilder)REGISTRATE.block(name, p -> new SaplingBlock(tree, (BlockBehaviour.Properties)p){

            public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
                if (super.canSurvive(state, level, pos)) {
                    return true;
                }
                BlockPos ground = pos.below();
                return this.mayPlaceOn(level.getBlockState(ground), (BlockGetter)level, ground);
            }

            protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
                Block block = state.getBlock();
                if (super.mayPlaceOn(state, level, pos)) {
                    return true;
                }
                return Arrays.stream(validPlantBlocks).map(Supplier::get).anyMatch(b -> b == block);
            }
        }).initialProperties(() -> Blocks.OAK_SAPLING).addLayer(() -> RenderType::cutout).tag(new TagKey[]{BlockTags.SAPLINGS}).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().cross(ctx.getName(), prov.blockTexture((Block)ctx.get())))).item().model(TropicraftBlocks::blockSprite).tag(new TagKey[]{ItemTags.SAPLINGS}).build();
    }

    private static BlockBuilder<LeavesBlock, Registrate> leaves(String name, BlockEntry<SaplingBlock> sapling, float[] saplingRates, boolean normalDecay) {
        return (BlockBuilder)REGISTRATE.block(name, normalDecay ? LeavesBlock::new : TropicraftLeavesBlock::new).initialProperties(() -> Blocks.OAK_LEAVES).loot((loot, block) -> loot.add((Block)block, loot.createLeavesDrops((Block)block, (Block)sapling.get(), saplingRates))).tag(new TagKey[]{BlockTags.LEAVES, BlockTags.MINEABLE_WITH_HOE}).item().tag(new TagKey[]{ItemTags.LEAVES}).build();
    }

    private static BlockBuilder<LeavesBlock, Registrate> leaves(String name, boolean normalDecay) {
        return (BlockBuilder)REGISTRATE.block(name, normalDecay ? LeavesBlock::new : TropicraftLeavesBlock::new).initialProperties(() -> Blocks.OAK_LEAVES).loot((loot, block) -> loot.add((Block)block, TropicraftBlocks.onlyWithSilkTouchOrShears(loot, (Block)block).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(TropicraftBlocks.hasNoShearsOrSilkTouch(loot)).add(((LootPoolSingletonContainer.Builder)loot.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))))).when(BonusLevelTableCondition.bonusLevelFlatChance(TropicraftBlocks.fortune(loot), (float[])new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f})))))).tag(new TagKey[]{BlockTags.LEAVES, BlockTags.MINEABLE_WITH_HOE}).item().tag(new TagKey[]{ItemTags.LEAVES}).build();
    }

    private static BlockBuilder<LeavesBlock, Registrate> fruitLeaves(String name, Supplier<SaplingBlock> sapling, Supplier<? extends Item> fruit) {
        return (BlockBuilder)REGISTRATE.block(name, LeavesBlock::new).initialProperties(() -> Blocks.OAK_LEAVES).loot((loot, block) -> loot.add((Block)block, loot.createLeavesDrops((Block)block, (Block)sapling.get(), FRUIT_SAPLING_RATES).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(TropicraftBlocks.hasNoShearsOrSilkTouch(loot)).add((LootPoolEntryContainer.Builder)loot.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)fruit.get()))))))).tag(new TagKey[]{BlockTags.LEAVES, BlockTags.MINEABLE_WITH_HOE}).item().tag(new TagKey[]{ItemTags.LEAVES}).build();
    }

    private static BlockBuilder<RotatedPillarBlock, Registrate> log(String name, MapColor topColor, MapColor sideColor) {
        return TropicraftBlocks.log(name, topColor, sideColor, null);
    }

    private static BlockBuilder<RotatedPillarBlock, Registrate> mangroveLog(String name, MapColor topColor, MapColor sideColor, @Nullable Supplier<? extends RotatedPillarBlock> strippedLog) {
        return (BlockBuilder)REGISTRATE.block(name, p -> strippedLog != null ? new TropicraftLogBlock((BlockBehaviour.Properties)p, strippedLog) : new RotatedPillarBlock(p)).initialProperties(() -> Blocks.OAK_LOG).properties(p -> TropicraftBlocks.rotatedPillarProperties(p, topColor, sideColor)).tag(new TagKey[]{BlockTags.LOGS, BlockTags.LOGS_THAT_BURN, BlockTags.MINEABLE_WITH_AXE}).blockstate((ctx, prov) -> prov.logBlock((RotatedPillarBlock)ctx.get())).item().tag(new TagKey[]{ItemTags.LOGS, ItemTags.LOGS_THAT_BURN, TropicraftTags.Items.MANGROVE_LOGS}).build();
    }

    private static BlockBuilder<RotatedPillarBlock, Registrate> log(String name, MapColor topColor, MapColor sideColor, @Nullable Supplier<? extends RotatedPillarBlock> strippedLog) {
        return (BlockBuilder)REGISTRATE.block(name, p -> strippedLog != null ? new TropicraftLogBlock((BlockBehaviour.Properties)p, strippedLog) : new RotatedPillarBlock(p)).initialProperties(() -> Blocks.OAK_LOG).properties(p -> TropicraftBlocks.rotatedPillarProperties(p, topColor, sideColor)).tag(new TagKey[]{BlockTags.LOGS, BlockTags.LOGS_THAT_BURN, BlockTags.MINEABLE_WITH_AXE}).blockstate((ctx, prov) -> prov.logBlock((RotatedPillarBlock)ctx.get())).item().tag(new TagKey[]{ItemTags.LOGS, ItemTags.LOGS_THAT_BURN}).build();
    }

    private static BlockBuilder<RotatedPillarBlock, Registrate> wood(String name, MapColor color, BlockEntry<? extends RotatedPillarBlock> bark) {
        return TropicraftBlocks.wood(name, color, bark, null);
    }

    private static BlockBuilder<RotatedPillarBlock, Registrate> wood(String name, MapColor color, BlockEntry<? extends RotatedPillarBlock> bark, @Nullable Supplier<? extends RotatedPillarBlock> stripped) {
        return (BlockBuilder)REGISTRATE.block(name, p -> stripped != null ? new TropicraftLogBlock((BlockBehaviour.Properties)p, stripped) : new RotatedPillarBlock(p)).properties(p -> p.sound(SoundType.WOOD).mapColor(color).strength(2.0f).ignitedByLava().instrument(NoteBlockInstrument.BASS)).tag(new TagKey[]{BlockTags.LOGS, BlockTags.LOGS_THAT_BURN, BlockTags.MINEABLE_WITH_AXE}).blockstate((ctx, prov) -> {
            ResourceLocation barkTexture = prov.blockTexture((Block)bark.get());
            prov.axisBlock((RotatedPillarBlock)ctx.get(), barkTexture, barkTexture);
        }).recipe((ctx, prov) -> ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ctx.get()), (int)3).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)bark.get()).group("bark").unlockedBy("has_log", RegistrateRecipeProvider.has((ItemLike)Blocks.ACACIA_LOG)).save((RecipeOutput)prov)).item().tag(new TagKey[]{ItemTags.LOGS, ItemTags.LOGS_THAT_BURN}).build();
    }

    private static BlockBuilder<MangroveRootsBlock, Registrate> mangroveRoots(String name) {
        return (BlockBuilder)REGISTRATE.block(name, MangroveRootsBlock::new).properties(p -> p.mapColor(MapColor.WOOD).sound(SoundType.WOOD).ignitedByLava().instrument(NoteBlockInstrument.BASS).strength(2.0f).noOcclusion().isRedstoneConductor((state, world, pos) -> false).hasPostProcess((state, world, pos) -> true)).addLayer(() -> RenderType::cutoutMipped).tag(new TagKey[]{TropicraftTags.Blocks.ROOTS, BlockTags.MINEABLE_WITH_AXE}).blockstate((ctx, prov) -> {
            ResourceLocation roots = prov.modLoc("block/" + name);
            ModelBuilder stem = ((BlockModelBuilder)prov.models().withExistingParent(name + "_stem", prov.modLoc("block/mangrove_roots/stem"))).texture("roots", roots);
            ModelBuilder stemShort = ((BlockModelBuilder)prov.models().withExistingParent(name + "_stem_short", prov.modLoc("block/mangrove_roots/stem_short"))).texture("roots", roots);
            ModelBuilder connectionLow = ((BlockModelBuilder)prov.models().withExistingParent(name + "_connection_low", prov.modLoc("block/mangrove_roots/connection_low"))).texture("roots", roots);
            ModelBuilder connectionHigh = ((BlockModelBuilder)prov.models().withExistingParent(name + "_connection_high", prov.modLoc("block/mangrove_roots/connection_high"))).texture("roots", roots);
            ModelBuilder appendagesHigh = ((BlockModelBuilder)prov.models().withExistingParent(name + "_appendages_high", prov.modLoc("block/mangrove_roots/appendages"))).texture("appendages", prov.modLoc("block/" + name + "_appendages_high"));
            ModelBuilder appendagesHighShort = ((BlockModelBuilder)prov.models().withExistingParent(name + "_appendages_high_short", prov.modLoc("block/mangrove_roots/appendages"))).texture("appendages", prov.modLoc("block/" + name + "_appendages_high_short"));
            ModelBuilder appendagesGrounded = ((BlockModelBuilder)prov.models().withExistingParent(name + "_appendages_ground", prov.modLoc("block/mangrove_roots/appendages"))).texture("appendages", prov.modLoc("block/" + name + "_appendages_ground"));
            ModelBuilder appendagesGroundedShort = ((BlockModelBuilder)prov.models().withExistingParent(name + "_appendages_ground_short", prov.modLoc("block/mangrove_roots/appendages"))).texture("appendages", prov.modLoc("block/" + name + "_appendages_ground_short"));
            MultiPartBlockStateBuilder builder = prov.getMultipartBuilder((Block)ctx.get());
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)stem).addModel()).condition((Property)MangroveRootsBlock.TALL, (Comparable[])new Boolean[]{true});
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)stemShort).addModel()).condition((Property)MangroveRootsBlock.TALL, (Comparable[])new Boolean[]{false});
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)appendagesGrounded).addModel()).condition((Property)MangroveRootsBlock.TALL, (Comparable[])new Boolean[]{true}).condition((Property)MangroveRootsBlock.GROUNDED, (Comparable[])new Boolean[]{true});
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)appendagesGroundedShort).addModel()).condition((Property)MangroveRootsBlock.TALL, (Comparable[])new Boolean[]{false}).condition((Property)MangroveRootsBlock.GROUNDED, (Comparable[])new Boolean[]{true});
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)appendagesHigh).addModel()).condition((Property)MangroveRootsBlock.TALL, (Comparable[])new Boolean[]{true}).condition((Property)MangroveRootsBlock.GROUNDED, (Comparable[])new Boolean[]{false});
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)appendagesHighShort).addModel()).condition((Property)MangroveRootsBlock.TALL, (Comparable[])new Boolean[]{false}).condition((Property)MangroveRootsBlock.GROUNDED, (Comparable[])new Boolean[]{false});
            for (int i = 0; i < 4; ++i) {
                EnumProperty<MangroveRootsBlock.Connection> connection = MangroveRootsBlock.CONNECTIONS[i];
                int rotation = (i * 90 + 270) % 360;
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)connectionHigh).rotationY(rotation).uvLock(true).addModel()).condition(connection, (Comparable[])new MangroveRootsBlock.Connection[]{MangroveRootsBlock.Connection.HIGH});
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)connectionLow).rotationY(rotation).uvLock(true).addModel()).condition(connection, (Comparable[])new MangroveRootsBlock.Connection[]{MangroveRootsBlock.Connection.LOW});
            }
        }).item().model((ctx, prov) -> prov.blockItem((NonNullSupplier)ctx, "_stem")).build();
    }

    private static BlockBuilder<MangroveLeavesBlock, Registrate> mangroveLeaves(String name, Supplier<PropaguleBlock> propagule) {
        return (BlockBuilder)REGISTRATE.block(name, p -> new MangroveLeavesBlock((BlockBehaviour.Properties)p, propagule)).initialProperties(() -> Blocks.OAK_LEAVES).properties(BlockBehaviour.Properties::randomTicks).loot((loot, block) -> loot.add((Block)block, TropicraftBlocks.onlyWithSilkTouchOrShears(loot, (Block)block).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(TropicraftBlocks.hasNoShearsOrSilkTouch(loot)).add(((LootPoolSingletonContainer.Builder)loot.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))))).when(BonusLevelTableCondition.bonusLevelFlatChance(TropicraftBlocks.fortune(loot), (float[])new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f})))))).tag(new TagKey[]{BlockTags.LEAVES}).item().tag(new TagKey[]{ItemTags.LEAVES}).build();
    }

    private static BlockBuilder<PropaguleBlock, Registrate> propagule(String name, TreeGrower tree, String scientificName) {
        return (BlockBuilder)((BlockBuilder)REGISTRATE.block(name, p -> new PropaguleBlock(tree, (BlockBehaviour.Properties)p)).initialProperties(() -> Blocks.OAK_SAPLING).addLayer(() -> RenderType::cutout).tag(new TagKey[]{BlockTags.SAPLINGS}).blockstate((ctx, prov) -> {
            BlockModelBuilder planted = (BlockModelBuilder)prov.models().cross(ctx.getName() + "_planted", prov.modLoc("block/" + ctx.getName() + "_planted"));
            BlockModelBuilder hanging = (BlockModelBuilder)prov.models().cross(ctx.getName() + "_hanging", prov.blockTexture((Block)ctx.get()));
            prov.getVariantBuilder((Block)ctx.get()).partialState().with((Property)PropaguleBlock.PLANTED, (Comparable)Boolean.valueOf(false)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)hanging)}).partialState().with((Property)PropaguleBlock.PLANTED, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)planted)});
        }).setData(ProviderType.LANG, (ctx, prov) -> prov.addBlockWithTooltip((NonNullSupplier)ctx, scientificName))).item().model(TropicraftBlocks::blockSprite).tag(new TagKey[]{ItemTags.SAPLINGS}).build();
    }

    private static BlockBuilder<Block, Registrate> planks(String name, MapColor color, Supplier<DataIngredient> log) {
        return (BlockBuilder)REGISTRATE.block(name, Block::new).initialProperties(() -> Blocks.OAK_PLANKS).properties(p -> p.mapColor(color)).tag(new TagKey[]{BlockTags.PLANKS, BlockTags.MINEABLE_WITH_AXE}).recipe((ctx, prov) -> prov.planks((DataIngredient)log.get(), RecipeCategory.BUILDING_BLOCKS, (Supplier)ctx)).item().tag(new TagKey[]{ItemTags.PLANKS}).build();
    }

    private static BlockBuilder<FenceBlock, Registrate> woodenFence(String name, BlockEntry<? extends Block> block, UnaryOperator<ItemBuilder<BlockItem, BlockBuilder<FenceBlock, Registrate>>> itemFunction) {
        BlockBuilder builder = REGISTRATE.block(name, FenceBlock::new).initialProperties(block).tag(new TagKey[]{BlockTags.WOODEN_FENCES, BlockTags.MINEABLE_WITH_AXE}).blockstate((ctx, prov) -> prov.fenceBlock((FenceBlock)ctx.get(), prov.blockTexture((Block)block.get()))).recipe((ctx, prov) -> prov.fence(DataIngredient.items((ItemLike)((Block)block.get()), (ItemLike[])new Block[0]), RecipeCategory.DECORATIONS, (Supplier)ctx, "wooden_fence"));
        return (BlockBuilder)((ItemBuilder)itemFunction.apply(builder.item().tag(new TagKey[]{ItemTags.WOODEN_FENCES}).model((ctx, prov) -> prov.fenceInventory(ctx.getName(), prov.modLoc("block/" + prov.name((NonNullSupplier)block)))))).build();
    }

    private static BlockBuilder<FenceGateBlock, Registrate> fenceGate(String name, BlockEntry<? extends Block> block) {
        return REGISTRATE.block(name, p -> new FenceGateBlock(p, SoundEvents.FENCE_GATE_OPEN, SoundEvents.FENCE_GATE_CLOSE)).initialProperties(block).tag(new TagKey[]{BlockTags.FENCE_GATES, BlockTags.MINEABLE_WITH_AXE}).blockstate((ctx, prov) -> prov.fenceGateBlock((FenceGateBlock)ctx.get(), prov.blockTexture((Block)block.get()))).recipe((ctx, prov) -> prov.fenceGate(DataIngredient.items((ItemLike)((Block)block.get()), (ItemLike[])new Block[0]), RecipeCategory.DECORATIONS, (Supplier)ctx, "wooden_fence_gate")).simpleItem();
    }

    private static BlockBuilder<DoorBlock, Registrate> woodenDoor(String name, BlockEntry<? extends Block> material) {
        return (BlockBuilder)REGISTRATE.block(name, p -> new DoorBlock(BlockSetType.OAK, p)).initialProperties(() -> Blocks.OAK_DOOR).loot((loot, block) -> loot.add((Block)block, TropicraftBlocks.createSinglePropConditionTable(loot, (Block)block, DoorBlock.HALF, DoubleBlockHalf.LOWER))).addLayer(() -> RenderType::cutout).tag(new TagKey[]{BlockTags.WOODEN_DOORS, BlockTags.MINEABLE_WITH_AXE}).blockstate((ctx, prov) -> prov.doorBlock((DoorBlock)ctx.get(), prov.modLoc("block/" + ctx.getName() + "_bottom"), prov.modLoc("block/" + ctx.getName() + "_top"))).recipe((ctx, prov) -> prov.door(DataIngredient.items((ItemLike)((Block)material.get()), (ItemLike[])new Block[0]), RecipeCategory.DECORATIONS, (Supplier)ctx, "wooden_door")).item().defaultModel().tag(new TagKey[]{ItemTags.WOODEN_DOORS}).build();
    }

    private static BlockBuilder<TrapDoorBlock, Registrate> trapdoor(String name, BlockEntry<? extends Block> material) {
        return (BlockBuilder)REGISTRATE.block(name, p -> new TrapDoorBlock(BlockSetType.OAK, p)).initialProperties(() -> Blocks.OAK_TRAPDOOR).addLayer(() -> RenderType::cutout).tag(new TagKey[]{BlockTags.WOODEN_TRAPDOORS, BlockTags.MINEABLE_WITH_AXE}).blockstate((ctx, prov) -> prov.trapdoorBlock((TrapDoorBlock)ctx.get(), prov.blockTexture((Block)ctx.get()), true)).recipe((ctx, prov) -> prov.trapDoor(DataIngredient.items((ItemLike)((Block)material.get()), (ItemLike[])new Block[0]), RecipeCategory.DECORATIONS, (Supplier)ctx, "wooden_trapdoor")).item().tag(new TagKey[]{ItemTags.WOODEN_TRAPDOORS}).model((ctx, prov) -> prov.blockItem((NonNullSupplier)ctx, "_bottom")).build();
    }

    private static BlockBuilder<BoardwalkBlock, Registrate> boardwalk(String name, BlockEntry<SlabBlock> slab, Either<Supplier<Block>, ResourceLocation> texture) {
        return (BlockBuilder)REGISTRATE.block(name, BoardwalkBlock::new).initialProperties(slab).properties(BlockBehaviour.Properties::noOcclusion).tag(new TagKey[]{BlockTags.MINEABLE_WITH_AXE}).blockstate((ctx, prov) -> {
            Direction.Axis[] horizontals;
            ResourceLocation resolvedTexture = (ResourceLocation)texture.map(b -> prov.blockTexture((Block)b.get()), Function.identity());
            ModelBuilder shortModel = ((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_short", prov.modLoc("block/boardwalk/short"))).texture("planks", resolvedTexture);
            ModelBuilder shortPostModel = ((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_short_post", prov.modLoc("block/boardwalk/short_post"))).texture("planks", resolvedTexture);
            ModelBuilder tallModel = ((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_tall", prov.modLoc("block/boardwalk/tall"))).texture("planks", resolvedTexture);
            ModelBuilder tallPostModel = ((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_tall_post", prov.modLoc("block/boardwalk/tall_post"))).texture("planks", resolvedTexture);
            ModelBuilder tallConnectionModel = ((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_tall_connection", prov.modLoc("block/boardwalk/tall_connection"))).texture("planks", resolvedTexture);
            MultiPartBlockStateBuilder builder = prov.getMultipartBuilder((Block)ctx.get());
            for (Direction.Axis axis : horizontals = new Direction.Axis[]{Direction.Axis.X, Direction.Axis.Z}) {
                int rotation = axis == Direction.Axis.X ? 270 : 0;
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)shortModel).rotationY(rotation).uvLock(true).addModel()).condition(BoardwalkBlock.TYPE, (Comparable[])BoardwalkBlock.Type.SHORTS).condition(BoardwalkBlock.AXIS, (Comparable[])new Direction.Axis[]{axis});
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)tallModel).rotationY(rotation).uvLock(true).addModel()).condition(BoardwalkBlock.TYPE, (Comparable[])BoardwalkBlock.Type.TALLS).condition(BoardwalkBlock.AXIS, (Comparable[])new Direction.Axis[]{axis});
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)tallConnectionModel).rotationY(rotation).uvLock(true).addModel()).condition(BoardwalkBlock.TYPE, (Comparable[])BoardwalkBlock.Type.BACKS).condition(BoardwalkBlock.AXIS, (Comparable[])new Direction.Axis[]{axis});
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)tallConnectionModel).rotationY((rotation + 180) % 360).uvLock(true).addModel()).condition(BoardwalkBlock.TYPE, (Comparable[])BoardwalkBlock.Type.FRONTS).condition(BoardwalkBlock.AXIS, (Comparable[])new Direction.Axis[]{axis});
            }
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)shortPostModel).addModel()).condition(BoardwalkBlock.TYPE, (Comparable[])BoardwalkBlock.Type.SHORT_POSTS);
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)tallPostModel).addModel()).condition(BoardwalkBlock.TYPE, (Comparable[])BoardwalkBlock.Type.TALL_POSTS);
        }).recipe((ctx, prov) -> ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get()), (int)3).pattern("XXX").pattern("S S").define(Character.valueOf('X'), (ItemLike)slab.get()).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).group("tropicraft:boardwalk").unlockedBy("has_" + prov.safeName((ItemLike)slab.get()), RegistrateRecipeProvider.has((ItemLike)((ItemLike)slab.get()))).save((RecipeOutput)prov)).item().model((ctx, prov) -> prov.blockItem((NonNullSupplier)ctx, "_short")).build();
    }

    private static BlockBehaviour.Properties rotatedPillarProperties(BlockBehaviour.Properties properties, MapColor topColor, MapColor sideColor) {
        return properties.mapColor(state -> state.getValue((Property)RotatedPillarBlock.AXIS) == Direction.Axis.Y ? topColor : sideColor);
    }

    protected static <T extends Comparable<T> & StringRepresentable> LootTable.Builder createSinglePropConditionTable(RegistrateBlockLootTables loot, Block block, Property<T> property, T value) {
        return LootTable.lootTable().withPool((LootPool.Builder)loot.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)block).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty(property, value))))));
    }

    private static LootPool.Builder droppingChunksPool(RegistrateBlockLootTables loot, Block block, Supplier<? extends ItemLike> chunk) {
        return LootPool.lootPool().add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)chunk.get()).when(MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(ItemTags.SWORDS)))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f))).otherwise((LootPoolEntryContainer.Builder)loot.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)block))));
    }

    protected static LootTable.Builder droppingChunks(RegistrateBlockLootTables loot, Block block, Supplier<? extends ItemLike> chunk) {
        return LootTable.lootTable().withPool(TropicraftBlocks.droppingChunksPool(loot, block, chunk));
    }

    protected static LootTable.Builder droppingChunks(RegistrateBlockLootTables loot, Block block, Supplier<? extends ItemLike> chunk, LootItemCondition.Builder condition) {
        return LootTable.lootTable().withPool(TropicraftBlocks.droppingChunksPool(loot, block, chunk).when(condition));
    }

    private static LootTable.Builder dropNumberOfItems(RegistrateBlockLootTables loot, Block block, Supplier<? extends ItemLike> drop, int minDrops, int maxDrops) {
        return LootTable.lootTable().withPool((LootPool.Builder)loot.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)drop.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)minDrops, (float)maxDrops)))));
    }

    private static LootTable.Builder onlyWithSilkTouchOrShears(RegistrateBlockLootTables loot, Block block) {
        return LootTable.lootTable().withPool(LootPool.lootPool().when(TropicraftBlocks.hasShearsOrSilkTouch(loot)).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block)));
    }

    private static LootTable.Builder coffee(RegistrateBlockLootTables loot, Block block, Supplier<? extends ItemLike> drop) {
        return LootTable.lootTable().withPool((LootPool.Builder)loot.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)drop.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)new ConstantValue(1.0f))))).withPool((LootPool.Builder)loot.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)drop.get())).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)CoffeeBushBlock.AGE, 6))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)))));
    }

    private static ModelFile cubeTop(DataGenContext<Block, BlockTropicraftSand> ctx, RegistrateBlockstateProvider prov, String suffix) {
        return prov.models().cubeTop(ctx.getName() + "_" + suffix, prov.blockTexture((Block)ctx.get()), prov.modLoc("block/" + ctx.getName() + "_" + suffix));
    }

    private static ModelFile fuzzyStairs(RegistrateBlockstateProvider prov, String name, String parent, String side, String end, String cross) {
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(name, prov.modLoc(parent))).texture("side", prov.modLoc("block/" + side))).texture("bottom", prov.modLoc("block/" + end))).texture("top", prov.modLoc("block/" + end))).texture("cross", prov.modLoc("block/" + cross));
    }

    private static ModelFile fuzzyStairs(RegistrateBlockstateProvider prov, String name, String side, String end, String cross) {
        return TropicraftBlocks.fuzzyStairs(prov, name, "stairs_fuzzy", side, end, cross);
    }

    private static ModelFile fuzzyStairsOuter(RegistrateBlockstateProvider prov, String name, String side, String end, String cross) {
        return TropicraftBlocks.fuzzyStairs(prov, name, "stairs_fuzzy_outer", side, end, cross);
    }

    private static void doublePlant(DataGenContext<Block, ? extends DoublePlantBlock> ctx, RegistrateBlockstateProvider prov) {
        BlockModelProvider models = prov.models();
        prov.getVariantBuilder((Block)ctx.get()).partialState().with((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)models.cross(ctx.getName() + "_bottom", prov.modLoc("block/" + ctx.getName() + "_bottom")))}).partialState().with((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)models.cross(ctx.getName() + "_top", prov.modLoc("block/" + ctx.getName() + "_top")))});
    }

    private static void noModelBlock(DataGenContext<Block, ? extends Block> ctx, RegistrateBlockstateProvider prov, ResourceLocation particle) {
        prov.simpleBlock((Block)ctx.get(), (ModelFile)((BlockModelBuilder)prov.models().getBuilder(ctx.getName())).texture("particle", particle));
    }

    private static void simpleBlockAllRotations(DataGenContext<Block, ? extends Block> ctx, RegistrateBlockstateProvider prov) {
        prov.simpleBlock((Block)ctx.get(), ConfiguredModel.allRotations((ModelFile)prov.cubeAll((Block)ctx.get()), (boolean)false));
    }

    private static ItemModelBuilder blockSprite(DataGenContext<Item, ? extends ItemLike> ctx, RegistrateItemModelProvider prov) {
        return prov.blockSprite(ctx);
    }

    private static String name(ItemLike item) {
        return item.asItem().builtInRegistryHolder().key().location().getPath();
    }

    private static void extendBlockEntity(BlockEntityType<?> type, Block block) {
        ((BlockEntityTypeAccessor)type).tropicraft$setValidBlocks((Set<Block>)ImmutableSet.builder().addAll(((BlockEntityTypeAccessor)type).tropicraft$getValidBlocks()).add((Object)block).build());
    }

    private static /* synthetic */ TallSeagrassBlock lambda$seagrass$251(Supplier tall) {
        return (TallSeagrassBlock)((BlockEntry)tall.get()).get();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$static$203(ModelFile tikiUpper, ModelFile tikiLower, BlockState state) {
        return ConfiguredModel.builder().modelFile(state.getValue(TikiTorchBlock.SECTION) == TikiTorchBlock.TorchSection.UPPER ? tikiUpper : tikiLower).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$static$165(ModelFile model, BlockState state) {
        return ConfiguredModel.builder().modelFile(model).rotationY(((int)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot() + 180) % 360).build();
    }

    static {
        REGISTRATE.addDataGenerator(ProviderType.BLOCKSTATE, prov -> {
            ((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent("bamboo_item_frame", "item_frame")).texture("particle", prov.modLoc("block/bamboo_side"))).texture("wood", prov.modLoc("block/bamboo_side"));
            ((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent("bamboo_item_frame_map", "item_frame_map")).texture("particle", prov.modLoc("block/bamboo_side"))).texture("wood", prov.modLoc("block/bamboo_side"));
        });
        REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, prov -> {
            prov.addTag(TropicraftTags.Blocks.CARVER_REPLACEABLES).addTags(new TagKey[]{BlockTags.OVERWORLD_CARVER_REPLACEABLES});
            prov.addTag(TropicraftTags.Blocks.BIRDS_LIKE_TO_STAND_ON).addTags(new TagKey[]{BlockTags.LOGS}).addTags(new TagKey[]{BlockTags.LEAVES}).addTags(new TagKey[]{TropicraftTags.Blocks.BRANCHES});
        });
        REGISTRATE.addDataGenerator(ProviderType.RECIPE, prov -> {
            TropicraftBlocks.registerPlankRecipe(prov, () -> JOCOTE_LOG, Blocks.JUNGLE_PLANKS);
            TropicraftBlocks.registerPlankRecipe(prov, () -> PAPAYA_LOG, Blocks.JUNGLE_PLANKS);
            TropicraftBlocks.registerPlankRecipe(prov, () -> PAPAYA_WOOD, Blocks.JUNGLE_PLANKS);
            TropicraftBlocks.registerPlankRecipe(prov, () -> STRIPPED_MANGROVE_LOG, (Block)MANGROVE_PLANKS.get());
            TropicraftBlocks.registerPlankRecipe(prov, () -> STRIPPED_MANGROVE_WOOD, (Block)MANGROVE_PLANKS.get());
        });
        TELEPORT_WATER = REGISTRATE.block("teleport_water", PortalWaterBlock::new).initialProperties(() -> Blocks.WATER).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().getExistingFile(prov.mcLoc("block/water")))).register();
        PORTAL_WATER = REGISTRATE.block("portal_water", p -> new LiquidBlock(Fluids.WATER, p)).initialProperties(() -> Blocks.WATER).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().getExistingFile(prov.mcLoc("block/water")))).register();
        CHUNK = REGISTRATE.block("chunk", Block::new).initialProperties(() -> Blocks.STONE).properties(p -> p.mapColor(MapColor.COLOR_BLACK).strength(6.0f).explosionResistance(30.0f)).blockstate(TropicraftBlocks::simpleBlockAllRotations).tag(new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE}).lang("Chunk O' Head").simpleItem().register();
        AZURITE_ORE = ((BlockBuilder)TropicraftBlocks.ore("azurite_ore", TropicraftItems.AZURITE, MapColor.STONE).tag(new TagKey[]{BlockTags.NEEDS_IRON_TOOL}).item().tag(new TagKey[]{TropicraftTags.Items.AZURITE_ORE, Tags.Items.ORES}).build()).register();
        EUDIALYTE_ORE = ((BlockBuilder)TropicraftBlocks.ore("eudialyte_ore", TropicraftItems.EUDIALYTE, MapColor.STONE).tag(new TagKey[]{BlockTags.NEEDS_IRON_TOOL}).item().tag(new TagKey[]{TropicraftTags.Items.EUDIALYTE_ORE, Tags.Items.ORES}).build()).register();
        MANGANESE_ORE = ((BlockBuilder)TropicraftBlocks.ore("manganese_ore", MapColor.STONE).tag(new TagKey[]{BlockTags.NEEDS_IRON_TOOL}).item().tag(new TagKey[]{TropicraftTags.Items.MANGANESE_ORE, Tags.Items.ORES}).build()).register();
        SHAKA_ORE = ((BlockBuilder)TropicraftBlocks.ore("shaka_ore", MapColor.COLOR_BLACK).tag(new TagKey[]{BlockTags.NEEDS_IRON_TOOL}).item().tag(new TagKey[]{TropicraftTags.Items.SHAKA_ORE, Tags.Items.ORES}).build()).register();
        ZIRCON_ORE = ((BlockBuilder)TropicraftBlocks.ore("zircon_ore", TropicraftItems.ZIRCON, MapColor.STONE).tag(new TagKey[]{BlockTags.NEEDS_IRON_TOOL}).item().tag(new TagKey[]{TropicraftTags.Items.ZIRCON_ORE, Tags.Items.ORES}).build()).register();
        AZURITE_BLOCK = TropicraftBlocks.oreStorageBlock("azurite_block", MapColor.COLOR_LIGHT_BLUE, TropicraftItems.AZURITE).tag(new TagKey[]{BlockTags.NEEDS_IRON_TOOL}).register();
        EUDIALYTE_BLOCK = TropicraftBlocks.oreStorageBlock("eudialyte_block", MapColor.COLOR_PINK, TropicraftItems.EUDIALYTE).tag(new TagKey[]{BlockTags.NEEDS_IRON_TOOL}).register();
        MANGANESE_BLOCK = TropicraftBlocks.oreStorageBlock("manganese_block", MapColor.COLOR_PURPLE, TropicraftItems.MANGANESE).tag(new TagKey[]{BlockTags.NEEDS_IRON_TOOL}).register();
        SHAKA_BLOCK = TropicraftBlocks.oreStorageBlock("shaka_block", MapColor.COLOR_BLUE, TropicraftItems.SHAKA).tag(new TagKey[]{BlockTags.NEEDS_IRON_TOOL}).register();
        ZIRCON_BLOCK = TropicraftBlocks.oreStorageBlock("zircon_block", MapColor.COLOR_RED, TropicraftItems.ZIRCON).tag(new TagKey[]{BlockTags.NEEDS_IRON_TOOL}).register();
        ZIRCONIUM_BLOCK = TropicraftBlocks.oreStorageBlock("zirconium_block", MapColor.COLOR_PINK, TropicraftItems.ZIRCONIUM).register();
        FLOWERS = (Map)Arrays.stream(TropicraftFlower.values()).collect(ImmutableMap.toImmutableMap(Function.identity(), flower -> {
            BlockBuilder builder = (BlockBuilder)REGISTRATE.block(flower.getId(), p -> new TropicsFlowerBlock(flower.getEffect(), flower.getEffectDuration(), flower.getShape(), (BlockBehaviour.Properties)p)).initialProperties(() -> Blocks.POPPY).addLayer(() -> RenderType::cutout).tag(flower.getTags()).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName(), "block/cross")).texture("cross", "tropicraft:block/flower/" + ctx.getName()))).item().tag(new TagKey[]{ItemTags.FLOWERS}).model((ctx, prov) -> prov.generated((NonNullSupplier)ctx, new ResourceLocation[]{prov.modLoc("block/flower/" + ctx.getName())})).build();
            Item dye = flower.getDye();
            if (dye != null) {
                builder = builder.recipe((ctx, prov) -> prov.singleItemUnfinished(DataIngredient.items((ItemLike)((TropicsFlowerBlock)((Object)((Object)((Object)ctx.get())))), (ItemLike[])new TropicsFlowerBlock[0]), RecipeCategory.MISC, () -> dye, 1, 2).save((RecipeOutput)prov, Tropicraft.location(TropicraftBlocks.name((ItemLike)dye))));
            }
            return builder.register();
        }));
        PURIFIED_SAND = ((BlockBuilder)REGISTRATE.block("purified_sand", BlockTropicraftSand::new).initialProperties(() -> Blocks.SAND).tag(new TagKey[]{BlockTags.SAND, BlockTags.MINEABLE_WITH_SHOVEL, TropicraftTags.Blocks.CARVER_REPLACEABLES}).blockstate((ctx, prov) -> {
            ModelFile normal = prov.cubeAll((Block)ctx.get());
            ModelFile calcified = TropicraftBlocks.cubeTop((DataGenContext<Block, BlockTropicraftSand>)ctx, prov, "calcified");
            ModelFile dune1 = TropicraftBlocks.cubeTop((DataGenContext<Block, BlockTropicraftSand>)ctx, prov, "dune1");
            ModelFile dune2 = TropicraftBlocks.cubeTop((DataGenContext<Block, BlockTropicraftSand>)ctx, prov, "dune2");
            ModelFile starfish = TropicraftBlocks.cubeTop((DataGenContext<Block, BlockTropicraftSand>)ctx, prov, "starfish");
            prov.getVariantBuilder((Block)ctx.get()).partialState().with((Property)BlockTropicraftSand.UNDERWATER, (Comparable)Boolean.valueOf(false)).addModels(ConfiguredModel.allRotations((ModelFile)normal, (boolean)false, (int)50)).addModels(ConfiguredModel.allYRotations((ModelFile)calcified, (int)0, (boolean)false, (int)5)).partialState().with((Property)BlockTropicraftSand.UNDERWATER, (Comparable)Boolean.valueOf(true)).addModels(ConfiguredModel.allRotations((ModelFile)normal, (boolean)false, (int)50)).addModels(ConfiguredModel.allYRotations((ModelFile)dune1, (int)0, (boolean)false, (int)10)).addModels(ConfiguredModel.allYRotations((ModelFile)dune2, (int)0, (boolean)false, (int)10)).addModels(ConfiguredModel.allYRotations((ModelFile)starfish, (int)0, (boolean)false));
        }).item().tag(new TagKey[]{ItemTags.SAND}).build()).recipe((ctx, prov) -> {
            prov.smelting(DataIngredient.items((NonNullSupplier)ctx, (NonNullSupplier[])new NonNullSupplier[0]), RecipeCategory.MISC, () -> Blocks.GLASS, 0.3f);
            prov.singleItem(DataIngredient.items((NonNullSupplier)ctx, (NonNullSupplier[])new NonNullSupplier[0]), RecipeCategory.BUILDING_BLOCKS, () -> Blocks.SAND, 1, 1);
        }).register();
        PACKED_PURIFIED_SAND = ((BlockBuilder)REGISTRATE.block("packed_purified_sand", Block::new).initialProperties(() -> Blocks.SAND).properties(p -> p.mapColor(MapColor.STONE).strength(0.8f).requiresCorrectToolForDrops()).blockstate(TropicraftBlocks::simpleBlockAllRotations).tag(new TagKey[]{BlockTags.SAND, BlockTags.MINEABLE_WITH_SHOVEL, TropicraftTags.Blocks.CARVER_REPLACEABLES}).recipe((ctx, prov) -> ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ctx.get())).pattern("XX").pattern("XX").define(Character.valueOf('X'), (ItemLike)PURIFIED_SAND.get()).unlockedBy("has_purified_sand", RegistrateRecipeProvider.has((ItemLike)((ItemLike)PURIFIED_SAND.get()))).save((RecipeOutput)prov)).item().tag(new TagKey[]{ItemTags.SAND}).build()).register();
        CORAL_SAND = ((BlockBuilder)REGISTRATE.block("coral_sand", BlockTropicraftSand::new).initialProperties(() -> Blocks.SAND).properties(p -> p.mapColor(MapColor.COLOR_PINK)).blockstate(TropicraftBlocks::simpleBlockAllRotations).tag(new TagKey[]{BlockTags.SAND, BlockTags.MINEABLE_WITH_SHOVEL, TropicraftTags.Blocks.CARVER_REPLACEABLES}).item().tag(new TagKey[]{ItemTags.SAND}).build()).register();
        FOAMY_SAND = ((BlockBuilder)REGISTRATE.block("foamy_sand", BlockTropicraftSand::new).initialProperties(() -> Blocks.SAND).properties(p -> p.mapColor(MapColor.COLOR_GREEN)).blockstate(TropicraftBlocks::simpleBlockAllRotations).tag(new TagKey[]{BlockTags.SAND, BlockTags.MINEABLE_WITH_SHOVEL, TropicraftTags.Blocks.CARVER_REPLACEABLES}).item().tag(new TagKey[]{ItemTags.SAND}).build()).register();
        VOLCANIC_SAND = ((BlockBuilder)REGISTRATE.block("volcanic_sand", VolcanicSandBlock::new).initialProperties(() -> Blocks.SAND).properties(p -> p.mapColor(MapColor.COLOR_LIGHT_GRAY)).blockstate(TropicraftBlocks::simpleBlockAllRotations).tag(new TagKey[]{BlockTags.SAND, BlockTags.MINEABLE_WITH_SHOVEL, TropicraftTags.Blocks.CARVER_REPLACEABLES}).item().tag(new TagKey[]{ItemTags.SAND}).build()).register();
        MINERAL_SAND = ((BlockBuilder)REGISTRATE.block("mineral_sand", BlockTropicraftSand::new).initialProperties(() -> Blocks.SAND).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), ConfiguredModel.allRotations((ModelFile)prov.cubeAll((Block)ctx.get()), (boolean)false))).tag(new TagKey[]{BlockTags.SAND, BlockTags.MINEABLE_WITH_SHOVEL, TropicraftTags.Blocks.CARVER_REPLACEABLES}).item().tag(new TagKey[]{ItemTags.SAND}).build()).register();
        MUD = REGISTRATE.block("mud", MudBlock::new).initialProperties(() -> Blocks.DIRT).properties(p -> p.speedFactor(0.5f).isValidSpawn((s, w, pa, e) -> true).isRedstoneConductor((s, w, pa) -> true).isViewBlocking((s, w, pa) -> true).isSuffocating((s, w, pa) -> true)).tag(new TagKey[]{TropicraftTags.Blocks.MUD, BlockTags.MINEABLE_WITH_SHOVEL, TropicraftTags.Blocks.CARVER_REPLACEABLES, BlockTags.BAMBOO_PLANTABLE_ON, BlockTags.DIRT, BlockTags.SNOW_LAYER_CAN_SURVIVE_ON, BlockTags.SNIFFER_DIGGABLE_BLOCK}).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ConfiguredModel[])ArrayUtils.addAll((Object[])ConfiguredModel.allYRotations((ModelFile)prov.models().cubeAll("mud", prov.modLoc("block/mud")), (int)0, (boolean)false, (int)5), (Object[])ConfiguredModel.allYRotations((ModelFile)prov.models().cubeAll("mud_with_stones", prov.modLoc("block/mud_with_stones")), (int)0, (boolean)false, (int)1)))).simpleItem().register();
        MUD_WITH_PIANGUAS = REGISTRATE.block("mud_with_pianguas", Block::new).initialProperties(MUD).loot((loot, block) -> loot.add(block, (LootTable.Builder)loot.applyExplosionDecay((ItemLike)MUD_WITH_PIANGUAS.get(), (FunctionUserBuilder)LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)MUD_WITH_PIANGUAS.get())).when(TropicraftBlocks.hasSilkTouch(loot))).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)MUD.get()))))).withPool(LootPool.lootPool().when(TropicraftBlocks.hasNoSilkTouch(loot)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)TropicraftItems.PIANGUAS.get())).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount(TropicraftBlocks.fortune(loot)))))))).tag(new TagKey[]{TropicraftTags.Blocks.MUD, BlockTags.MINEABLE_WITH_SHOVEL, TropicraftTags.Blocks.CARVER_REPLACEABLES, BlockTags.BAMBOO_PLANTABLE_ON, BlockTags.DIRT, BlockTags.SNOW_LAYER_CAN_SURVIVE_ON, BlockTags.SNIFFER_DIGGABLE_BLOCK}).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), model -> ConfiguredModel.allYRotations((ModelFile)model, (int)0, (boolean)false))).simpleItem().register();
        BAMBOO_BUNDLE = REGISTRATE.block("bamboo_bundle", RotatedPillarBlock::new).properties(p -> p.mapColor(MapColor.PLANT).sound(SoundType.BAMBOO).strength(0.2f, 5.0f)).blockstate((ctx, prov) -> prov.axisBlock((RotatedPillarBlock)ctx.get(), prov.modLoc("block/bamboo"))).recipe((ctx, prov) -> prov.singleItem(DataIngredient.items(TropicraftItems.BAMBOO_STICK, (NonNullSupplier[])new NonNullSupplier[0]), RecipeCategory.BUILDING_BLOCKS, (Supplier)ctx, 9, 2)).simpleItem().register();
        THATCH_BUNDLE = REGISTRATE.block("thatch_bundle", RotatedPillarBlock::new).properties(p -> p.mapColor(MapColor.PLANT).sound(SoundType.BAMBOO).strength(0.2f, 5.0f).ignitedByLava().pushReaction(PushReaction.DESTROY)).blockstate((ctx, prov) -> prov.axisBlock((RotatedPillarBlock)ctx.get(), prov.modLoc("block/thatch"))).recipe((ctx, prov) -> prov.singleItem(DataIngredient.items((ItemLike)Items.SUGAR_CANE, (ItemLike[])new Item[0]), RecipeCategory.BUILDING_BLOCKS, (Supplier)ctx, 4, 1)).simpleItem().register();
        MAHOGANY_PLANKS = TropicraftBlocks.planks("mahogany_planks", MapColor.COLOR_BROWN, () -> DataIngredient.items((ItemLike)((RotatedPillarBlock)MAHOGANY_LOG.get()), (ItemLike[])new RotatedPillarBlock[]{(RotatedPillarBlock)MAHOGANY_WOOD.get()})).register();
        PALM_PLANKS = TropicraftBlocks.planks("palm_planks", MapColor.COLOR_BROWN, () -> DataIngredient.items((ItemLike)((RotatedPillarBlock)PALM_LOG.get()), (ItemLike[])new RotatedPillarBlock[]{(RotatedPillarBlock)PALM_WOOD.get()})).register();
        MAHOGANY_LOG = TropicraftBlocks.log("mahogany_log", MapColor.WOOD, MapColor.COLOR_BROWN).register();
        PALM_LOG = TropicraftBlocks.log("palm_log", MapColor.COLOR_GRAY, MapColor.COLOR_BROWN).register();
        MAHOGANY_WOOD = TropicraftBlocks.wood("mohogany_wood", MapColor.WOOD, MAHOGANY_LOG).lang("Mahogany Wood").register();
        PALM_WOOD = TropicraftBlocks.wood("palm_wood", MapColor.COLOR_GRAY, PALM_LOG).register();
        PALM_STAIRS = TropicraftBlocks.woodenStairs("palm_stairs", PALM_PLANKS).register();
        MAHOGANY_STAIRS = TropicraftBlocks.woodenStairs("mahogany_stairs", MAHOGANY_PLANKS).register();
        THATCH_STAIRS = TropicraftBlocks.woodenStairs("thatch_stairs", THATCH_BUNDLE).blockstate((ctx, prov) -> {
            ResourceLocation side = prov.modLoc("block/thatch_side");
            ResourceLocation end = prov.modLoc("block/thatch_end");
            prov.stairsBlock((StairBlock)ctx.get(), side, end, end);
        }).register();
        THATCH_STAIRS_FUZZY = TropicraftBlocks.woodenStairs("thatch_stairs_fuzzy", THATCH_BUNDLE).addLayer(() -> RenderType::cutoutMipped).blockstate((ctx, prov) -> {
            ModelFile fuzzyThatch = TropicraftBlocks.fuzzyStairs(prov, "thatch_stairs_fuzzy", "thatch_side", "thatch_end", "thatch_grass");
            ModelFile fuzzyThatchOuter = TropicraftBlocks.fuzzyStairsOuter(prov, "thatch_stairs_fuzzy_outer", "thatch_side", "thatch_end", "thatch_grass");
            prov.stairsBlock((StairBlock)ctx.get(), fuzzyThatch, (ModelFile)prov.models().getExistingFile(prov.modLoc("thatch_stairs_inner")), fuzzyThatchOuter);
        }).lang("Thatch Roof").recipe((ctx, prov) -> ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get()), (int)4).pattern("C  ").pattern("XC ").pattern("XXC").define(Character.valueOf('X'), (ItemLike)THATCH_BUNDLE.get()).define(Character.valueOf('C'), (ItemLike)Items.SUGAR_CANE).unlockedBy("has_thatch_bundle", RegistrateRecipeProvider.has((ItemLike)((ItemLike)THATCH_BUNDLE.get()))).save((RecipeOutput)prov)).register();
        BAMBOO_STAIRS = TropicraftBlocks.woodenStairs("bamboo_stairs", BAMBOO_BUNDLE).blockstate((ctx, prov) -> {
            ResourceLocation side = prov.modLoc("block/bamboo_side");
            ResourceLocation end = prov.modLoc("block/bamboo_end");
            prov.stairsBlock((StairBlock)ctx.get(), side, end, end);
        }).register();
        CHUNK_STAIRS = TropicraftBlocks.stoneStairs("chunk_stairs", CHUNK).register();
        COCONUT = ((BlockBuilder)REGISTRATE.block("coconut", CoconutBlock::new).properties(p -> p.mapColor(MapColor.PLANT).strength(2.0f).sound(SoundType.STONE).pushReaction(PushReaction.DESTROY)).loot((loot, block) -> loot.add((Block)block, TropicraftBlocks.droppingChunks(loot, (Block)block, TropicraftItems.COCONUT_CHUNK))).tag(new TagKey[]{BlockTags.MINEABLE_WITH_AXE}).addLayer(() -> RenderType::cutout).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().cross("coconut", prov.modLoc("block/coconut")))).item().model(TropicraftBlocks::blockSprite).build()).register();
        BAMBOO_SLAB = TropicraftBlocks.woodenSlab("bamboo_slab", BAMBOO_BUNDLE).blockstate((ctx, prov) -> {
            ResourceLocation side = prov.modLoc("block/bamboo_side");
            ResourceLocation end = prov.modLoc("block/bamboo_end");
            prov.slabBlock((SlabBlock)ctx.get(), BAMBOO_BUNDLE.getId(), side, end, end);
        }).register();
        THATCH_SLAB = TropicraftBlocks.woodenSlab("thatch_slab", THATCH_BUNDLE).blockstate((ctx, prov) -> {
            ResourceLocation side = prov.modLoc("block/thatch_side");
            ResourceLocation end = prov.modLoc("block/thatch_end");
            prov.slabBlock((SlabBlock)ctx.get(), THATCH_BUNDLE.getId(), side, end, end);
        }).register();
        CHUNK_SLAB = TropicraftBlocks.stoneSlab("chunk_slab", CHUNK).register();
        PALM_SLAB = TropicraftBlocks.woodenSlab("palm_slab", PALM_PLANKS).register();
        MAHOGANY_SLAB = TropicraftBlocks.woodenSlab("mahogany_slab", MAHOGANY_PLANKS).register();
        GRAPEFRUIT_SAPLING = TropicraftBlocks.sapling("grapefruit_sapling", TropicraftTreeGrowers.GRAPEFRUIT, new Supplier[0]).register();
        LEMON_SAPLING = TropicraftBlocks.sapling("lemon_sapling", TropicraftTreeGrowers.LEMON, new Supplier[0]).register();
        LIME_SAPLING = TropicraftBlocks.sapling("lime_sapling", TropicraftTreeGrowers.LIME, new Supplier[0]).register();
        ORANGE_SAPLING = TropicraftBlocks.sapling("orange_sapling", TropicraftTreeGrowers.ORANGE, new Supplier[0]).register();
        PAPAYA_SAPLING = TropicraftBlocks.sapling("papaya_sapling", TropicraftTreeGrowers.PAPAYA, new Supplier[0]).register();
        MAHOGANY_SAPLING = TropicraftBlocks.sapling("mahogany_sapling", TropicraftTreeGrowers.RAINFOREST, new Supplier[0]).register();
        PALM_SAPLING = TropicraftBlocks.sapling("palm_sapling", TropicraftTreeGrowers.PALM, new Supplier[]{() -> Blocks.SAND, CORAL_SAND, FOAMY_SAND, VOLCANIC_SAND, PURIFIED_SAND, MINERAL_SAND}).register();
        MAHOGANY_LEAVES = TropicraftBlocks.leaves("mahogany_leaves", MAHOGANY_SAPLING, RARE_SAPLING_RATES, false).register();
        PALM_LEAVES = TropicraftBlocks.leaves("palm_leaves", PALM_SAPLING, SAPLING_RATES, false).register();
        KAPOK_LEAVES = TropicraftBlocks.leaves("kapok_leaves", false).register();
        FRUIT_LEAVES = TropicraftBlocks.leaves("fruit_leaves", true).register();
        GRAPEFRUIT_LEAVES = TropicraftBlocks.fruitLeaves("grapefruit_leaves", GRAPEFRUIT_SAPLING, TropicraftItems.GRAPEFRUIT).register();
        LEMON_LEAVES = TropicraftBlocks.fruitLeaves("lemon_leaves", LEMON_SAPLING, TropicraftItems.LEMON).register();
        LIME_LEAVES = TropicraftBlocks.fruitLeaves("lime_leaves", LIME_SAPLING, TropicraftItems.LIME).register();
        ORANGE_LEAVES = TropicraftBlocks.fruitLeaves("orange_leaves", ORANGE_SAPLING, TropicraftItems.ORANGE).register();
        PAPAYA_LEAVES = TropicraftBlocks.leaves("papaya_leaves", PAPAYA_SAPLING, SAPLING_RATES, true).register();
        WHITE_FLOWERING_LEAVES = TropicraftBlocks.leaves("white_flowering_leaves", true).register();
        RED_FLOWERING_LEAVES = TropicraftBlocks.leaves("red_flowering_leaves", true).register();
        BLUE_FLOWERING_LEAVES = TropicraftBlocks.leaves("blue_flowering_leaves", true).register();
        PURPLE_FLOWERING_LEAVES = TropicraftBlocks.leaves("purple_flowering_leaves", true).register();
        YELLOW_FLOWERING_LEAVES = TropicraftBlocks.leaves("yellow_flowering_leaves", true).register();
        PASSIONFRUIT_VINE = ((BlockBuilder)REGISTRATE.block("passionfruit_vine", FruitingVineBlock::new).properties(p -> p.mapColor(MapColor.GRASS).replaceable().noCollission().strength(0.2f).sound(SoundType.VINE).ignitedByLava().pushReaction(PushReaction.DESTROY)).blockstate((ctx, prov) -> {
            MultiPartBlockStateBuilder builder = prov.getMultipartBuilder((Block)ctx.get());
            Iterator iterator = FruitingVineBlock.AGE.getPossibleValues().iterator();
            while (iterator.hasNext()) {
                int age = (Integer)iterator.next();
                BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_" + age, prov.modLoc("block/vines"))).texture("texture", prov.modLoc("block/" + ctx.getName() + "_" + age));
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)model).addModel()).condition((Property)FruitingVineBlock.AGE, (Comparable[])new Integer[]{age}).condition((Property)BlockStateProperties.NORTH, (Comparable[])new Boolean[]{true});
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)model).rotationY(270).addModel()).condition((Property)FruitingVineBlock.AGE, (Comparable[])new Integer[]{age}).condition((Property)BlockStateProperties.WEST, (Comparable[])new Boolean[]{true});
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)model).rotationY(90).addModel()).condition((Property)FruitingVineBlock.AGE, (Comparable[])new Integer[]{age}).condition((Property)BlockStateProperties.EAST, (Comparable[])new Boolean[]{true});
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)model).rotationY(180).addModel()).condition((Property)FruitingVineBlock.AGE, (Comparable[])new Integer[]{age}).condition((Property)BlockStateProperties.SOUTH, (Comparable[])new Boolean[]{true});
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)model).rotationX(90).addModel()).condition((Property)FruitingVineBlock.AGE, (Comparable[])new Integer[]{age}).condition((Property)BlockStateProperties.DOWN, (Comparable[])new Boolean[]{true});
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)model).rotationX(270).addModel()).condition((Property)FruitingVineBlock.AGE, (Comparable[])new Integer[]{age}).condition((Property)BlockStateProperties.UP, (Comparable[])new Boolean[]{true});
            }
        }).addLayer(() -> RenderType::cutoutMipped).loot((loot, block) -> loot.add((Block)block, loot.createSilkTouchOrShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder)loot.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem(TropicraftItems.PASSIONFRUIT).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)FruitingVineBlock.AGE, 2)))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))))))).item().model((ctx, prov) -> prov.blockSprite((NonNullSupplier)ctx, prov.modLoc("block/passionfruit_vine_1"))).build()).register();
        PAPAYA_LOG = TropicraftBlocks.log("papaya_log", MapColor.COLOR_GRAY, MapColor.COLOR_BROWN).register();
        PAPAYA_WOOD = TropicraftBlocks.wood("papaya_wood", MapColor.COLOR_GRAY, PAPAYA_LOG).register();
        PLANTAIN_SAPLING = TropicraftBlocks.sapling("plantain_sapling", TropicraftTreeGrowers.PLANTAIN, new Supplier[0]).register();
        PLANTAIN_STEM = TropicraftBlocks.log("plantain_stem", MapColor.COLOR_LIGHT_GREEN, MapColor.COLOR_BROWN).register();
        PLANTAIN_LEAVES = TropicraftBlocks.leaves("plantain_leaves", PLANTAIN_SAPLING, SAPLING_RATES, true).register();
        GREEN_PLANTAIN_BUNCH = TropicraftBlocks.plantainBunch("green_plantain_bunch", () -> TropicraftItems.GREEN_PLANTAIN);
        YELLOW_PLANTAIN_BUNCH = TropicraftBlocks.plantainBunch("yellow_plantain_bunch", () -> TropicraftItems.YELLOW_PLANTAIN);
        JOCOTE_SAPLING = TropicraftBlocks.sapling("jocote_sapling", TropicraftTreeGrowers.JOCOTE, new Supplier[0]).register();
        JOCOTE_LOG = TropicraftBlocks.log("jocote_log", MapColor.COLOR_GRAY, MapColor.COLOR_BROWN).register();
        JOCOTE_LEAVES = TropicraftBlocks.leaves("jocote_leaves", JOCOTE_SAPLING, SAPLING_RATES, true).register();
        JOCOTE_BRANCH = ((BlockBuilder)REGISTRATE.block("jocote_branch", FruitingBranchBlock::new).properties(p -> p.sound(SoundType.AZALEA).noOcclusion().instabreak().randomTicks().pushReaction(PushReaction.DESTROY)).blockstate((ctx, prov) -> {
            ResourceLocation fruitingBranch = prov.modLoc("block/fruiting_branch");
            List<BlockModelBuilder> models = IntStream.rangeClosed(0, 2).mapToObj(age -> (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_age" + age, fruitingBranch)).texture("horizontal", prov.modLoc("block/jocote_branch_horizontal_" + age))).texture("vertical", prov.modLoc("block/jocote_branch_vertical"))).toList();
            prov.horizontalBlock((Block)ctx.get(), state -> (ModelFile)models.get((Integer)state.getValue((Property)FruitingBranchBlock.AGE)));
        }).tag(new TagKey[]{TropicraftTags.Blocks.BRANCHES}).addLayer(() -> RenderType::cutoutMipped).loot((loot, block) -> loot.add((Block)block, LootTable.lootTable().withPool((LootPool.Builder)loot.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block)).add(LootItem.lootTableItem(TropicraftItems.JOCOTE).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)FruitingBranchBlock.AGE, 2)))))))).item().model((ctx, prov) -> prov.blockSprite((NonNullSupplier)ctx, prov.modLoc("block/jocote_branch_horizontal_0"))).build()).register();
        MAHOGANY_NUT = ((BlockBuilder)REGISTRATE.block("mahogany_nut", MahoganyNutBlock::new).initialProperties(() -> Blocks.COCOA).blockstate((ctx, prov) -> prov.getVariantBuilder((Block)ctx.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)prov.models().getExistingFile(prov.modLoc("block/mahogany_nut_" + String.valueOf(state.getValue((Property)MahoganyNutBlock.AGE))))).build())).loot((loot, block) -> loot.add((Block)block, LootTable.lootTable().withPool((LootPool.Builder)loot.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)block).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)MahoganyNutBlock.AGE, 2)))))))).addLayer(() -> RenderType::cutoutMipped).item().model((ctx, prov) -> prov.generated((NonNullSupplier)ctx, new ResourceLocation[]{prov.modLoc("item/mahogany_nut")})).build()).register();
        RED_MANGROVE_LOG = TropicraftBlocks.mangroveLog("red_mangrove_log", MapColor.COLOR_GRAY, MapColor.COLOR_BROWN, () -> (RotatedPillarBlock)STRIPPED_MANGROVE_LOG.get()).register();
        RED_MANGROVE_WOOD = TropicraftBlocks.wood("red_mangrove_wood", MapColor.COLOR_GRAY, RED_MANGROVE_LOG, () -> (RotatedPillarBlock)STRIPPED_MANGROVE_WOOD.get()).register();
        RED_MANGROVE_ROOTS = TropicraftBlocks.mangroveRoots("red_mangrove_roots").register();
        LIGHT_MANGROVE_LOG = TropicraftBlocks.mangroveLog("light_mangrove_log", MapColor.COLOR_GRAY, MapColor.COLOR_BROWN, () -> (RotatedPillarBlock)STRIPPED_MANGROVE_LOG.get()).register();
        LIGHT_MANGROVE_WOOD = TropicraftBlocks.wood("light_mangrove_wood", MapColor.COLOR_GRAY, LIGHT_MANGROVE_LOG, () -> (RotatedPillarBlock)STRIPPED_MANGROVE_WOOD.get()).register();
        LIGHT_MANGROVE_ROOTS = TropicraftBlocks.mangroveRoots("light_mangrove_roots").register();
        BLACK_MANGROVE_LOG = TropicraftBlocks.mangroveLog("black_mangrove_log", MapColor.COLOR_GRAY, MapColor.COLOR_BROWN, () -> (RotatedPillarBlock)STRIPPED_MANGROVE_LOG.get()).register();
        BLACK_MANGROVE_WOOD = TropicraftBlocks.wood("black_mangrove_wood", MapColor.COLOR_GRAY, BLACK_MANGROVE_LOG, () -> (RotatedPillarBlock)STRIPPED_MANGROVE_WOOD.get()).register();
        BLACK_MANGROVE_ROOTS = TropicraftBlocks.mangroveRoots("black_mangrove_roots").register();
        RED_MANGROVE_LEAVES = TropicraftBlocks.mangroveLeaves("red_mangrove_leaves", () -> (PropaguleBlock)((Object)((Object)RED_MANGROVE_PROPAGULE.get()))).register();
        TALL_MANGROVE_LEAVES = TropicraftBlocks.mangroveLeaves("tall_mangrove_leaves", () -> (PropaguleBlock)((Object)((Object)TALL_MANGROVE_PROPAGULE.get()))).register();
        TEA_MANGROVE_LEAVES = TropicraftBlocks.mangroveLeaves("tea_mangrove_leaves", () -> (PropaguleBlock)((Object)((Object)TEA_MANGROVE_PROPAGULE.get()))).register();
        BLACK_MANGROVE_LEAVES = TropicraftBlocks.mangroveLeaves("black_mangrove_leaves", () -> (PropaguleBlock)((Object)((Object)BLACK_MANGROVE_PROPAGULE.get()))).register();
        RED_MANGROVE_PROPAGULE = TropicraftBlocks.propagule("red_mangrove_propagule", TropicraftTreeGrowers.RED_MANGROVE, "Rhizophora mangle").register();
        TALL_MANGROVE_PROPAGULE = TropicraftBlocks.propagule("tall_mangrove_propagule", TropicraftTreeGrowers.TALL_MANGROVE, "Rhizophora racemosa").register();
        TEA_MANGROVE_PROPAGULE = TropicraftBlocks.propagule("tea_mangrove_propagule", TropicraftTreeGrowers.TEA_MANGROVE, "Pelliciera rhizophorae").register();
        BLACK_MANGROVE_PROPAGULE = TropicraftBlocks.propagule("black_mangrove_propagule", TropicraftTreeGrowers.BLACK_MANGROVE, "Avicennia germinans").register();
        STRIPPED_MANGROVE_LOG = TropicraftBlocks.mangroveLog("stripped_mangrove_log", MapColor.COLOR_RED, MapColor.COLOR_RED, null).register();
        STRIPPED_MANGROVE_WOOD = TropicraftBlocks.wood("stripped_mangrove_wood", MapColor.COLOR_RED, STRIPPED_MANGROVE_LOG).register();
        MANGROVE_PLANKS = TropicraftBlocks.planks("mangrove_planks", MapColor.COLOR_BROWN, () -> DataIngredient.items(LIGHT_MANGROVE_LOG, (NonNullSupplier[])new NonNullSupplier[]{RED_MANGROVE_LOG, BLACK_MANGROVE_LOG, LIGHT_MANGROVE_WOOD, RED_MANGROVE_WOOD, BLACK_MANGROVE_WOOD})).register();
        MANGROVE_STAIRS = TropicraftBlocks.woodenStairs("mangrove_stairs", MANGROVE_PLANKS).register();
        MANGROVE_SLAB = TropicraftBlocks.woodenSlab("mangrove_slab", MANGROVE_PLANKS).register();
        MANGROVE_FENCE = TropicraftBlocks.woodenFence("mangrove_fence", MANGROVE_PLANKS, i -> i).register();
        MANGROVE_FENCE_GATE = TropicraftBlocks.fenceGate("mangrove_fence_gate", MANGROVE_PLANKS).register();
        MANGROVE_DOOR = TropicraftBlocks.woodenDoor("mangrove_door", MANGROVE_PLANKS).register();
        MANGROVE_TRAPDOOR = TropicraftBlocks.trapdoor("mangrove_trapdoor", MANGROVE_PLANKS).register();
        MANGROVE_BUTTON = TropicraftBlocks.woodButton("mangrove_button", MANGROVE_PLANKS, "mangrove_planks").register();
        MAHOGANY_BUTTON = TropicraftBlocks.woodButton("mahogany_button", MAHOGANY_PLANKS, "mahogany_planks").register();
        PALM_BUTTON = TropicraftBlocks.woodButton("palm_button", PALM_PLANKS, "palm_planks").register();
        BAMBOO_BUTTON = TropicraftBlocks.woodButton("bamboo_button", BAMBOO_BUNDLE, "bamboo_end").register();
        THATCH_BUTTON = TropicraftBlocks.woodButton("thatch_button", THATCH_BUNDLE, "thatch_end").register();
        MANGROVE_PRESSURE_PLATE = TropicraftBlocks.pressurePlate("mangrove_pressure_plate", MANGROVE_PLANKS, "mangrove_planks").register();
        MAHOGANY_PRESSURE_PLATE = TropicraftBlocks.pressurePlate("mahogany_pressure_plate", MAHOGANY_PLANKS, "mahogany_planks").register();
        PALM_PRESSURE_PLATE = TropicraftBlocks.pressurePlate("palm_pressure_plate", PALM_PLANKS, "palm_planks").register();
        BAMBOO_PRESSURE_PLATE = TropicraftBlocks.pressurePlate("bamboo_pressure_plate", BAMBOO_BUNDLE, "bamboo_end").register();
        THATCH_PRESSURE_PLATE = TropicraftBlocks.pressurePlate("thatch_pressure_plate", THATCH_BUNDLE, "thatch_end").register();
        MAHOGANY_SIGN = TropicraftBlocks.standingSign(TropicraftWoodTypes.MAHOGANY, () -> (Item)TropicraftItems.MAHOGANY_SIGN.get(), "mahogany_planks").register();
        PALM_SIGN = TropicraftBlocks.standingSign(TropicraftWoodTypes.PALM, () -> (Item)TropicraftItems.PALM_SIGN.get(), "palm_planks").register();
        BAMBOO_SIGN = TropicraftBlocks.standingSign(TropicraftWoodTypes.BAMBOO, () -> (Item)TropicraftItems.BAMBOO_SIGN.get(), "bamboo_end").register();
        THATCH_SIGN = TropicraftBlocks.standingSign(TropicraftWoodTypes.THATCH, () -> (Item)TropicraftItems.THATCH_SIGN.get(), "thatch_end").register();
        MANGROVE_SIGN = TropicraftBlocks.standingSign(TropicraftWoodTypes.MANGROVE, () -> (Item)TropicraftItems.MANGROVE_SIGN.get(), "mangrove_planks").register();
        MAHOGANY_WALL_SIGN = TropicraftBlocks.wallSign(TropicraftWoodTypes.MAHOGANY, () -> (Item)TropicraftItems.MAHOGANY_SIGN.get(), "mahogany_planks").register();
        PALM_WALL_SIGN = TropicraftBlocks.wallSign(TropicraftWoodTypes.PALM, () -> (Item)TropicraftItems.PALM_SIGN.get(), "palm_planks").register();
        BAMBOO_WALL_SIGN = TropicraftBlocks.wallSign(TropicraftWoodTypes.BAMBOO, () -> (Item)TropicraftItems.BAMBOO_SIGN.get(), "bamboo_end").register();
        THATCH_WALL_SIGN = TropicraftBlocks.wallSign(TropicraftWoodTypes.THATCH, () -> (Item)TropicraftItems.THATCH_SIGN.get(), "thatch_end").register();
        MANGROVE_WALL_SIGN = TropicraftBlocks.wallSign(TropicraftWoodTypes.MANGROVE, () -> (Item)TropicraftItems.MANGROVE_SIGN.get(), "mangrove_planks").register();
        REEDS = ((BlockBuilder)REGISTRATE.block("reeds", ReedsBlock::new).initialProperties(() -> Blocks.SUGAR_CANE).addLayer(() -> RenderType::cutout).blockstate((ctx, prov) -> {
            VariantBlockStateBuilder builder = prov.getVariantBuilder((Block)ctx.get());
            for (ReedsBlock.Type type : ReedsBlock.Type.values()) {
                VariantBlockStateBuilder.PartialBlockstate partialState = builder.partialState().with(ReedsBlock.TYPE, (Comparable)((Object)type));
                for (String texture : type.getTextures()) {
                    partialState.addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)prov.models().crop(texture, prov.modLoc("block/" + texture)))});
                }
            }
        }).item().model((ctx, prov) -> prov.blockSprite((NonNullSupplier)ctx, prov.modLoc("block/" + ctx.getName() + "_top_tall"))).build()).register();
        PAPAYA = REGISTRATE.block("papaya", PapayaBlock::new).properties(p -> p.mapColor(MapColor.PLANT).randomTicks().strength(0.2f, 3.0f).sound(SoundType.WOOD).noOcclusion().pushReaction(PushReaction.DESTROY)).loot((loot, block) -> loot.add((Block)block, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)loot.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem(TropicraftItems.PAPAYA).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f)).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)PapayaBlock.AGE, 1))))))))).addLayer(() -> RenderType::cutout).blockstate((ctx, prov) -> {
            ((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent("papaya_stage0", "cocoa_stage2")).texture("particle", prov.modLoc("block/papaya_stage0"))).texture("cocoa", prov.modLoc("block/papaya_stage0"));
            prov.getVariantBuilder((Block)ctx.get()).forAllStates(state -> {
                int age = (Integer)state.getValue((Property)PapayaBlock.AGE);
                Direction facing = (Direction)state.getValue((Property)PapayaBlock.FACING);
                ModelFile.ExistingModelFile modelFile = prov.models().getExistingFile(prov.modLoc("block/papaya_stage" + age));
                return new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelFile, 0, facing.get2DDataValue() * 90, false)};
            });
        }).register();
        BAMBOO_FENCE = TropicraftBlocks.woodenFence("bamboo_fence", BAMBOO_BUNDLE, item -> item.tag(new TagKey[]{ItemTags.WOODEN_FENCES}).model((ctx, prov) -> prov.fenceInventory(ctx.getName(), prov.modLoc("block/bamboo_side")))).blockstate((ctx, prov) -> prov.fenceBlock((FenceBlock)ctx.get(), prov.modLoc("block/bamboo_side"))).register();
        THATCH_FENCE = TropicraftBlocks.woodenFence("thatch_fence", THATCH_BUNDLE, item -> item.tag(new TagKey[]{ItemTags.WOODEN_FENCES}).model((ctx, prov) -> prov.fenceInventory(ctx.getName(), prov.modLoc("block/thatch_side")))).blockstate((ctx, prov) -> prov.fenceBlock((FenceBlock)ctx.get(), prov.modLoc("block/thatch_side"))).register();
        CHUNK_FENCE = TropicraftBlocks.woodenFence("chunk_fence", CHUNK, i -> i).register();
        PALM_FENCE = TropicraftBlocks.woodenFence("palm_fence", PALM_PLANKS, i -> i).register();
        MAHOGANY_FENCE = TropicraftBlocks.woodenFence("mahogany_fence", MAHOGANY_PLANKS, i -> i).register();
        BAMBOO_FENCE_GATE = TropicraftBlocks.fenceGate("bamboo_fence_gate", BAMBOO_BUNDLE).blockstate((ctx, prov) -> prov.fenceGateBlock((FenceGateBlock)ctx.get(), prov.modLoc("block/bamboo_side"))).register();
        THATCH_FENCE_GATE = TropicraftBlocks.fenceGate("thatch_fence_gate", THATCH_BUNDLE).blockstate((ctx, prov) -> prov.fenceGateBlock((FenceGateBlock)ctx.get(), prov.modLoc("block/thatch_side"))).register();
        CHUNK_FENCE_GATE = TropicraftBlocks.fenceGate("chunk_fence_gate", CHUNK).register();
        PALM_FENCE_GATE = TropicraftBlocks.fenceGate("palm_fence_gate", PALM_PLANKS).register();
        MAHOGANY_FENCE_GATE = TropicraftBlocks.fenceGate("mahogany_fence_gate", MAHOGANY_PLANKS).register();
        CHUNK_WALL = ((BlockBuilder)REGISTRATE.block("chunk_wall", WallBlock::new).initialProperties(CHUNK).tag(new TagKey[]{BlockTags.WALLS}).blockstate((ctx, prov) -> prov.wallBlock((WallBlock)ctx.get(), prov.blockTexture((Block)CHUNK.get()))).recipe((ctx, prov) -> prov.wall(DataIngredient.items((ItemLike)((Block)CHUNK.get()), (ItemLike[])new Block[0]), RecipeCategory.DECORATIONS, (Supplier)ctx)).item().tag(new TagKey[]{ItemTags.WALLS}).model((ctx, prov) -> prov.wallInventory(ctx.getName(), prov.modLoc("block/" + CHUNK.getId().getPath()))).build()).register();
        BAMBOO_DOOR = TropicraftBlocks.woodenDoor("bamboo_door", BAMBOO_BUNDLE).register();
        PALM_DOOR = TropicraftBlocks.woodenDoor("palm_door", PALM_PLANKS).register();
        MAHOGANY_DOOR = TropicraftBlocks.woodenDoor("mahogany_door", MAHOGANY_PLANKS).register();
        THATCH_DOOR = TropicraftBlocks.woodenDoor("thatch_door", THATCH_BUNDLE).register();
        BAMBOO_TRAPDOOR = TropicraftBlocks.trapdoor("bamboo_trapdoor", BAMBOO_BUNDLE).register();
        PALM_TRAPDOOR = TropicraftBlocks.trapdoor("palm_trapdoor", PALM_PLANKS).register();
        MAHOGANY_TRAPDOOR = TropicraftBlocks.trapdoor("mahogany_trapdoor", MAHOGANY_PLANKS).register();
        THATCH_TRAPDOOR = TropicraftBlocks.trapdoor("thatch_trapdoor", THATCH_BUNDLE).register();
        IRIS = ((BlockBuilder)REGISTRATE.block("iris", TallFlowerBlock::new).properties(p -> p.mapColor(MapColor.PLANT).noCollission().instabreak().sound(SoundType.GRASS).replaceable().ignitedByLava().pushReaction(PushReaction.DESTROY)).loot((loot, block) -> loot.add((Block)block, TropicraftBlocks.createSinglePropConditionTable(loot, (Block)block, DoublePlantBlock.HALF, DoubleBlockHalf.LOWER))).tag(new TagKey[]{BlockTags.TALL_FLOWERS}).addLayer(() -> RenderType::cutout).blockstate(TropicraftBlocks::doublePlant).recipe((ctx, prov) -> prov.singleItemUnfinished(DataIngredient.items((ItemLike)((TallFlowerBlock)ctx.get()), (ItemLike[])new TallFlowerBlock[0]), RecipeCategory.MISC, () -> Items.PURPLE_DYE, 1, 4).save((RecipeOutput)prov, Tropicraft.location(TropicraftBlocks.name((ItemLike)Items.PURPLE_DYE)))).item().model((ctx, prov) -> prov.blockSprite((NonNullSupplier)ctx, prov.modLoc("block/iris_top"))).build()).register();
        PINEAPPLE = ((BlockBuilder)REGISTRATE.block("pineapple", PineappleBlock::new).properties(p -> p.mapColor(MapColor.PLANT).randomTicks().noCollission().instabreak().sound(SoundType.GRASS).replaceable().ignitedByLava().pushReaction(PushReaction.DESTROY)).loot((loot, block) -> loot.add((Block)block, TropicraftBlocks.droppingChunks(loot, (Block)block, TropicraftItems.PINEAPPLE_CUBES, (LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER))))).addLayer(() -> RenderType::cutout).blockstate(TropicraftBlocks::doublePlant).item().model((ctx, prov) -> prov.blockSprite((NonNullSupplier)ctx, prov.modLoc("block/pineapple_top"))).build()).register();
        SMALL_BONGO_DRUM = TropicraftBlocks.bongoDrum("small_bongo_drum", BongoDrumBlock.Size.SMALL).register();
        MEDIUM_BONGO_DRUM = TropicraftBlocks.bongoDrum("medium_bongo_drum", BongoDrumBlock.Size.MEDIUM).register();
        LARGE_BONGO_DRUM = TropicraftBlocks.bongoDrum("large_bongo_drum", BongoDrumBlock.Size.LARGE).register();
        BAMBOO_LADDER = ((BlockBuilder)REGISTRATE.block("bamboo_ladder", LadderBlock::new).initialProperties(() -> Blocks.LADDER).properties(p -> p.sound(SoundType.BAMBOO)).addLayer(() -> RenderType::cutout).tag(new TagKey[]{BlockTags.CLIMBABLE, BlockTags.MINEABLE_WITH_AXE}).blockstate((ctx, prov) -> {
            ResourceLocation texture = prov.blockTexture((Block)ctx.get());
            ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName(), "ladder")).texture("particle", texture)).texture("texture", texture);
            prov.getVariantBuilder((Block)ctx.get()).forAllStatesExcept(arg_0 -> TropicraftBlocks.lambda$static$165((ModelFile)model, arg_0), new Property[]{LadderBlock.WATERLOGGED});
        }).recipe((ctx, prov) -> ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get()), (int)4).pattern("S S").pattern("BSB").pattern("S S").define(Character.valueOf('S'), (ItemLike)TropicraftItems.BAMBOO_STICK.get()).define(Character.valueOf('B'), (ItemLike)Items.BAMBOO).unlockedBy("has_bamboo", RegistrateRecipeProvider.has((ItemLike)Items.BAMBOO)).save((RecipeOutput)prov)).item().model(TropicraftBlocks::blockSprite).build()).register();
        BAMBOO_BOARDWALK = TropicraftBlocks.boardwalk("bamboo_boardwalk", BAMBOO_SLAB, (Either<Supplier<Block>, ResourceLocation>)Either.right((Object)Tropicraft.location("block/bamboo_side"))).register();
        PALM_BOARDWALK = TropicraftBlocks.boardwalk("palm_boardwalk", PALM_SLAB, (Either<Supplier<Block>, ResourceLocation>)Either.left(PALM_PLANKS)).register();
        MAHOGANY_BOARDWALK = TropicraftBlocks.boardwalk("mahogany_boardwalk", MAHOGANY_SLAB, (Either<Supplier<Block>, ResourceLocation>)Either.left(MAHOGANY_PLANKS)).register();
        MANGROVE_BOARDWALK = TropicraftBlocks.boardwalk("mangrove_boardwalk", MANGROVE_SLAB, (Either<Supplier<Block>, ResourceLocation>)Either.left(MANGROVE_PLANKS)).register();
        BAMBOO_CHEST = ((BlockBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block("bamboo_chest", BambooChestBlock::new).initialProperties(BAMBOO_BUNDLE).properties(p -> p.strength(1.0f)).blockstate((ctx, prov) -> TropicraftBlocks.noModelBlock((DataGenContext<Block, ? extends Block>)ctx, prov, prov.modLoc("block/bamboo_side"))).blockEntity(BambooChestBlockEntity::new).renderer(() -> BambooChestRenderer::new).build()).item().clientExtension(() -> TropicraftItemRenderers::bambooChest).model((ctx, prov) -> ((ItemModelBuilder)prov.withExistingParent(ctx.getName(), "item/chest")).texture("particle", prov.modLoc("block/bamboo_side"))).build()).addMiscData(ProviderType.LANG, prov -> {
            prov.add("tropicraft.container.bambooChest", "Bamboo Chest");
            prov.add("tropicraft.container.bambooChestDouble", "Large Bamboo Chest");
        })).recipe((ctx, prov) -> ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get())).pattern("BBB").pattern("B B").pattern("BBB").define(Character.valueOf('B'), (ItemLike)Items.BAMBOO).unlockedBy("has_bamboo", RegistrateRecipeProvider.has((ItemLike)Items.BAMBOO)).save((RecipeOutput)prov)).register();
        BAMBOO_CHEST_ENTITY = BlockEntityEntry.cast((RegistryEntry)BAMBOO_CHEST.getSibling(Registries.BLOCK_ENTITY_TYPE));
        SIFTER = ((BlockBuilder)((BlockBuilder)REGISTRATE.block("sifter", SifterBlock::new).initialProperties(() -> Blocks.OAK_PLANKS).properties(BlockBehaviour.Properties::noOcclusion).addLayer(() -> RenderType::cutout).blockEntity(SifterBlockEntity::new).renderer(() -> SifterRenderer::new).build()).setData(ProviderType.LANG, (ctx, prov) -> prov.addBlockWithTooltip((NonNullSupplier)ctx, "Place any type of tropics or regular sand in the sifter. What treasures are hidden inside?"))).recipe((ctx, prov) -> {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get())).pattern("XXX").pattern("XIX").pattern("XXX").define(Character.valueOf('X'), ItemTags.PLANKS).define(Character.valueOf('I'), Tags.Items.GLASS_BLOCKS).group("tropicraft:sifter").unlockedBy("has_glass", RegistrateRecipeProvider.has((TagKey)Tags.Items.GLASS_BLOCKS)).save((RecipeOutput)prov);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get())).pattern("XXX").pattern("XIX").pattern("XXX").define(Character.valueOf('X'), ItemTags.PLANKS).define(Character.valueOf('I'), Tags.Items.GLASS_PANES).group("tropicraft:sifter").unlockedBy("has_glass_pane", RegistrateRecipeProvider.has((TagKey)Tags.Items.GLASS_PANES)).save((RecipeOutput)prov, Tropicraft.location("sifter_with_glass_pane"));
        }).simpleItem().register();
        SIFTER_ENTITY = BlockEntityEntry.cast((RegistryEntry)SIFTER.getSibling(Registries.BLOCK_ENTITY_TYPE));
        DRINK_MIXER = ((BlockBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block("drink_mixer", DrinkMixerBlock::new).properties(p -> p.mapColor(MapColor.STONE).strength(2.0f, 30.0f).noOcclusion().instrument(NoteBlockInstrument.BASEDRUM)).blockstate((ctx, prov) -> TropicraftBlocks.noModelBlock((DataGenContext<Block, ? extends Block>)ctx, prov, prov.modLoc("block/chunk"))).blockEntity(DrinkMixerBlockEntity::new).renderer(() -> DrinkMixerRenderer::new).build()).item().clientExtension(() -> TropicraftItemRenderers::drinkMixer).model((ctx, prov) -> ((ItemModelBuilder)prov.withExistingParent(ctx.getName(), prov.modLoc("item/tall_machine"))).texture("particle", prov.modLoc("block/chunk"))).build()).addLayer(() -> RenderType::cutout).setData(ProviderType.LANG, (ctx, prov) -> prov.addBlockWithTooltip((NonNullSupplier)ctx, "Place two drink ingredients on the mixer, then place an empty mug on the base, then ???, then enjoy!"))).recipe((ctx, prov) -> ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get())).pattern("XXX").pattern("XYX").pattern("XXX").define(Character.valueOf('X'), (ItemLike)CHUNK.get()).define(Character.valueOf('Y'), (ItemLike)TropicraftItems.BAMBOO_MUG.get()).unlockedBy("has_bamboo_mug", RegistrateRecipeProvider.has((ItemLike)((ItemLike)TropicraftItems.BAMBOO_MUG.get()))).save((RecipeOutput)prov)).register();
        DRINK_MIXER_ENTITY = BlockEntityEntry.cast((RegistryEntry)DRINK_MIXER.getSibling(Registries.BLOCK_ENTITY_TYPE));
        AIR_COMPRESSOR = ((BlockBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block("air_compressor", AirCompressorBlock::new).properties(p -> p.mapColor(MapColor.STONE).strength(2.0f, 30.0f).noOcclusion().instrument(NoteBlockInstrument.BASEDRUM)).blockstate((ctx, prov) -> TropicraftBlocks.noModelBlock((DataGenContext<Block, ? extends Block>)ctx, prov, prov.modLoc("block/chunk"))).blockEntity(AirCompressorBlockEntity::new).renderer(() -> AirCompressorRenderer::new).build()).item().clientExtension(() -> TropicraftItemRenderers::airCompressor).model((ctx, prov) -> ((ItemModelBuilder)prov.withExistingParent(ctx.getName(), prov.modLoc("item/tall_machine"))).texture("particle", prov.modLoc("block/chunk"))).build()).addLayer(() -> RenderType::cutout).setData(ProviderType.LANG, (ctx, prov) -> prov.addBlockWithTooltip((NonNullSupplier)ctx, "Place an empty scuba harness in the compressor to fill it with air!"))).recipe((ctx, prov) -> ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get()), (int)1).pattern("XXX").pattern("XYX").pattern("XXX").define(Character.valueOf('X'), (ItemLike)CHUNK.get()).define(Character.valueOf('Y'), (ItemLike)TropicraftItems.AZURITE.get()).unlockedBy("has_" + prov.safeName((ItemLike)CHUNK.get()), RegistrateRecipeProvider.has((ItemLike)((ItemLike)CHUNK.get()))).unlockedBy("has_" + prov.safeName((ItemLike)TropicraftItems.AZURITE.get()), RegistrateRecipeProvider.has((ItemLike)((ItemLike)TropicraftItems.AZURITE.get()))).save((RecipeOutput)prov)).register();
        AIR_COMPRESSOR_ENTITY = BlockEntityEntry.cast((RegistryEntry)AIR_COMPRESSOR.getSibling(Registries.BLOCK_ENTITY_TYPE));
        VOLCANO = REGISTRATE.block("volcano", VolcanoBlock::new).initialProperties(() -> Blocks.BEDROCK).properties(BlockBehaviour.Properties::noLootTable).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().getExistingFile(prov.mcLoc("block/bedrock")))).simpleBlockEntity(VolcanoBlockEntity::new).register();
        VOLCANO_ENTITY = BlockEntityEntry.cast((RegistryEntry)VOLCANO.getSibling(Registries.BLOCK_ENTITY_TYPE));
        TIKI_TORCH = ((BlockBuilder)REGISTRATE.block("tiki_torch", TikiTorchBlock::new).initialProperties(() -> Blocks.TORCH).properties(p -> p.sound(SoundType.WOOD).lightLevel(state -> state.getValue(TikiTorchBlock.SECTION) == TikiTorchBlock.TorchSection.UPPER ? 15 : 0)).loot((loot, block) -> loot.add((Block)block, TropicraftBlocks.createSinglePropConditionTable(loot, block, TikiTorchBlock.SECTION, TikiTorchBlock.TorchSection.UPPER))).addLayer(() -> RenderType::cutout).blockstate((ctx, prov) -> {
            ModelBuilder tikiLower = prov.models().torch("tiki_torch_lower", prov.modLoc("block/tiki_torch_lower"));
            ModelBuilder tikiUpper = prov.models().torch("tiki_torch_upper", prov.modLoc("block/tiki_torch_upper"));
            prov.getVariantBuilder((Block)ctx.get()).forAllStates(arg_0 -> TropicraftBlocks.lambda$static$203((ModelFile)tikiUpper, (ModelFile)tikiLower, arg_0));
        }).recipe((ctx, prov) -> ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get())).pattern("Y").pattern("X").pattern("X").define(Character.valueOf('X'), (ItemLike)TropicraftItems.BAMBOO_STICK.get()).define(Character.valueOf('Y'), ItemTags.COALS).unlockedBy("has_bamboo_stick", RegistrateRecipeProvider.has((ItemLike)((ItemLike)TropicraftItems.BAMBOO_STICK.get()))).save((RecipeOutput)prov)).item().defaultModel().build()).register();
        BAMBOO_FLOWER_POT = ((BlockBuilder)REGISTRATE.block("bamboo_flower_pot", p -> new FlowerPotBlock(null, () -> Blocks.AIR, p)).properties(p -> p.strength(0.2f, 5.0f).sound(SoundType.BAMBOO).pushReaction(PushReaction.DESTROY)).addLayer(() -> RenderType::cutout).blockstate((ctx, prov) -> TropicraftBlocks.flowerPot((DataGenContext<Block, ? extends FlowerPotBlock>)ctx, prov, (Supplier<? extends Block>)ctx, prov.modLoc("block/bamboo_side"))).recipe((ctx, prov) -> ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get())).pattern("# #").pattern(" # ").define(Character.valueOf('#'), (ItemLike)Items.BAMBOO).unlockedBy("has_bamboo", RegistrateRecipeProvider.has((ItemLike)Items.BAMBOO)).save((RecipeOutput)prov)).item().defaultModel().build()).register();
        COFFEE_BUSH = REGISTRATE.block("coffee_bush", CoffeeBushBlock::new).properties(p -> p.mapColor(MapColor.GRASS).strength(0.15f).sound(SoundType.GRASS).noOcclusion().pushReaction(PushReaction.DESTROY)).loot((loot, block) -> loot.add((Block)block, TropicraftBlocks.coffee(loot, (Block)COFFEE_BUSH.get(), TropicraftItems.RAW_COFFEE_BEAN))).addLayer(() -> RenderType::cutout).blockstate((ctx, prov) -> prov.getVariantBuilder((Block)ctx.get()).forAllStates(state -> {
            int age = (Integer)state.getValue((Property)CoffeeBushBlock.AGE);
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_stage_" + age, prov.modLoc("coffee_bush"))).texture("bush", prov.modLoc("block/" + ctx.getName() + "_stage" + age));
            return ConfiguredModel.builder().modelFile((ModelFile)model).build();
        })).register();
        GOLDEN_LEATHER_FERN = ((BlockBuilder)REGISTRATE.block("small_golden_leather_fern", p -> new GrowableSinglePlantBlock((BlockBehaviour.Properties)p, () -> TALL_GOLDEN_LEATHER_FERN)).initialProperties(() -> Blocks.FERN).properties(p -> p.offsetType(BlockBehaviour.OffsetType.XZ)).addLayer(() -> RenderType::cutout).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().cross(ctx.getName(), prov.modLoc("block/small_golden_leather_fern")))).lang("Golden Leather Fern").item().model((ctx, prov) -> prov.generated((NonNullSupplier)ctx, new ResourceLocation[]{prov.modLoc("item/golden_leather_fern")})).build()).register();
        TALL_GOLDEN_LEATHER_FERN = REGISTRATE.block("tall_golden_leather_fern", p -> new GrowableDoublePlantBlock((BlockBehaviour.Properties)p, () -> LARGE_GOLDEN_LEATHER_FERN).setPickItem(() -> GOLDEN_LEATHER_FERN)).initialProperties(() -> Blocks.LARGE_FERN).loot((loot, block) -> loot.dropOther((Block)block, (ItemLike)GOLDEN_LEATHER_FERN.get())).addLayer(() -> RenderType::cutout).blockstate(TropicraftBlocks::doublePlant).register();
        LARGE_GOLDEN_LEATHER_FERN = REGISTRATE.block("golden_leather_fern", p -> new HugePlantBlock((BlockBehaviour.Properties)p).setPickItem(() -> GOLDEN_LEATHER_FERN)).properties(p -> p.mapColor(MapColor.PLANT).noOcclusion().noCollission().instabreak().sound(SoundType.GRASS).pushReaction(PushReaction.DESTROY)).loot((loot, block) -> loot.dropOther((Block)block, (ItemLike)GOLDEN_LEATHER_FERN.get())).addLayer(() -> RenderType::cutout).blockstate((ctx, prov) -> {
            BlockModelBuilder cross = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName(), prov.modLoc("block/huge_cross"))).texture("cross", prov.modLoc("block/large_golden_leather_fern"))).texture("particle", prov.blockTexture((Block)GOLDEN_LEATHER_FERN.get()));
            ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)cross).addModel()).condition(HugePlantBlock.TYPE, (Comparable[])new HugePlantBlock.Type[]{HugePlantBlock.Type.CENTER});
        }).lang("Large Golden Leather Fern").register();
        FLOWERING_LILY_PAD = ((BlockBuilder)REGISTRATE.block("flowering_lily_pad", WaterlilyBlock::new).properties(p -> p.mapColor(MapColor.PLANT).noOcclusion().instabreak().sound(SoundType.LILY_PAD).pushReaction(PushReaction.DESTROY)).addLayer(() -> RenderType::cutout).blockstate((ctx, prov) -> {
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName(), prov.modLoc("block/water_lily_with_flower"))).texture("flower", prov.modLoc("block/flowering_lily_pad"))).texture("texture", prov.mcLoc("block/lily_pad"))).texture("particle", prov.mcLoc("block/lily_pad"));
            prov.simpleBlock((Block)ctx.get(), ConfiguredModel.allYRotations((ModelFile)model, (int)0, (boolean)false));
        }).tag(new TagKey[]{BlockTags.SWORD_EFFICIENT, BlockTags.INSIDE_STEP_SOUND_BLOCKS, BlockTags.FROG_PREFER_JUMP_TO}).color(NonNullSupplier.of(() -> () -> (blockState, blockAndTintGetter, blockPos, i) -> blockAndTintGetter != null && blockPos != null ? -14647248 : -9321636)).item(PlaceOnWaterBlockItem::new).model((ctx, prov) -> prov.generated((NonNullSupplier)ctx, new ResourceLocation[]{prov.modLoc("block/flowering_lily_pad")})).build()).register();
        DUCKWEED = ((BlockBuilder)REGISTRATE.block("duckweed", DuckweedBlock::new).properties(p -> p.mapColor(MapColor.PLANT).noCollission().noOcclusion().instabreak().sound(SoundType.LILY_PAD).pushReaction(PushReaction.DESTROY)).addLayer(() -> RenderType::cutout).blockstate((ctx, prov) -> {
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName(), prov.mcLoc("block/carpet"))).texture("wool", prov.modLoc("block/duckweed"))).texture("particle", prov.modLoc("block/duckweed"));
            prov.simpleBlock((Block)ctx.get(), (ModelFile)model);
        }).tag(new TagKey[]{BlockTags.SWORD_EFFICIENT}).item(PlaceOnWaterBlockItem::new).model((ctx, prov) -> prov.generated((NonNullSupplier)ctx, new ResourceLocation[]{prov.modLoc("block/duckweed")})).build()).register();
        EEL_GRASS = TropicraftBlocks.seagrass("eel_grass", "Enhalus acoroides", () -> TALL_EEL_GRASS).register();
        TALL_EEL_GRASS = TropicraftBlocks.tallSeagrass("tall_eel_grass", "Enhalus acoroides", EEL_GRASS).register();
        FLOWERING_EEL_GRASS = TropicraftBlocks.seagrass("flowering_eel_grass", "Enhalus acoroides", () -> FLOWERING_TALL_EEL_GRASS).register();
        FLOWERING_TALL_EEL_GRASS = TropicraftBlocks.tallSeagrass("flowering_tall_eel_grass", "Enhalus acoroides", FLOWERING_EEL_GRASS).register();
        MATTED_EEL_GRASS = TropicraftBlocks.mattedSeagrassBlock("matted_eel_grass", "Enhalus acoroides").register();
        EEL_GRASS_BLOCK = TropicraftBlocks.seagrassBlock("eel_grass", "Enhalus acoroides").register();
        FERN_SEAGRASS = TropicraftBlocks.seagrass("fern_seagrass", "Halophila spinulosa", () -> TALL_FERN_SEAGRASS).register();
        TALL_FERN_SEAGRASS = TropicraftBlocks.tallSeagrass("tall_fern_seagrass", "Halophila spinulosa", FERN_SEAGRASS).register();
        MATTED_FERN_SEAGRASS = TropicraftBlocks.mattedSeagrassBlock("matted_fern_seagrass", "Halophila spinulosa").register();
        FERN_SEAGRASS_BLOCK = TropicraftBlocks.seagrassBlock("fern_seagrass", "Halophila spinulosa").register();
        SICKLE_SEAGRASS = TropicraftBlocks.seagrass("sickle_seagrass", "Thalassodendron ciliatum", () -> TALL_SICKLE_SEAGRASS).register();
        TALL_SICKLE_SEAGRASS = TropicraftBlocks.tallSeagrass("tall_sickle_seagrass", "Thalassodendron ciliatum", SICKLE_SEAGRASS).register();
        MATTED_SICKLE_SEAGRASS = TropicraftBlocks.mattedSeagrassBlock("matted_sickle_seagrass", "Thalassodendron ciliatum").register();
        SICKLE_SEAGRASS_BLOCK = TropicraftBlocks.seagrassBlock("sickle_seagrass", "Thalassodendron ciliatum").register();
        NOODLE_SEAGRASS = TropicraftBlocks.seagrass("noodle_seagrass", "Syringodium isoetifolium", null).register();
        MATTED_NOODLE_SEAGRASS = TropicraftBlocks.mattedSeagrassBlock("matted_noodle_seagrass", "Syringodium isoetifolium").register();
        NOODLE_SEAGRASS_BLOCK = TropicraftBlocks.seagrassBlock("noodle_seagrass", "Syringodium isoetifolium").register();
        POTTABLE_PLANTS = ImmutableSet.builder().add((Object[])new BlockEntry[]{PALM_SAPLING, MAHOGANY_SAPLING, GRAPEFRUIT_SAPLING, LEMON_SAPLING, LIME_SAPLING, ORANGE_SAPLING}).add(IRIS).addAll(FLOWERS.values()).build();
        BAMBOO_POTTED_TROPICS_PLANTS = POTTABLE_PLANTS.stream().map(plant -> TropicraftBlocks.bambooPot("bamboo_potted_" + plant.getId().getPath(), (Supplier<? extends Block>)plant)).toList();
        VANILLA_POTTED_TROPICS_PLANTS = POTTABLE_PLANTS.stream().map(plant -> TropicraftBlocks.vanillaPot("potted_" + plant.getId().getPath(), (Supplier<? extends Block>)plant)).toList();
        BAMBOO_POTTED_VANILLA_PLANTS = Stream.of(Blocks.OAK_SAPLING, Blocks.SPRUCE_SAPLING, Blocks.BIRCH_SAPLING, Blocks.JUNGLE_SAPLING, Blocks.ACACIA_SAPLING, Blocks.DARK_OAK_SAPLING, Blocks.FERN, Blocks.DANDELION, Blocks.POPPY, Blocks.BLUE_ORCHID, Blocks.ALLIUM, Blocks.AZURE_BLUET, Blocks.RED_TULIP, Blocks.ORANGE_TULIP, Blocks.WHITE_TULIP, Blocks.PINK_TULIP, Blocks.OXEYE_DAISY, Blocks.CORNFLOWER, Blocks.LILY_OF_THE_VALLEY, Blocks.WITHER_ROSE, Blocks.RED_MUSHROOM, Blocks.BROWN_MUSHROOM, Blocks.DEAD_BUSH, Blocks.CACTUS).map(plant -> TropicraftBlocks.bambooPot("bamboo_potted_" + TropicraftBlocks.name((ItemLike)plant), () -> plant)).toList();
        ALL_POTTED_PLANTS = ImmutableList.builder().addAll(BAMBOO_POTTED_TROPICS_PLANTS).addAll(VANILLA_POTTED_TROPICS_PLANTS).addAll(BAMBOO_POTTED_VANILLA_PLANTS).build();
        JIGARBOV_WALL_TORCHES = (Map)Arrays.stream(JigarbovTorchType.values()).collect(ImmutableMap.toImmutableMap(Function.identity(), type -> REGISTRATE.block("jigarbov_" + type.getName() + "_wall_torch", p -> new RedstoneWallTorchBlock((BlockBehaviour.Properties)p){

            public String getDescriptionId() {
                return Util.makeDescriptionId((String)"block", (ResourceLocation)BuiltInRegistries.BLOCK.getKey((Object)this));
            }

            public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader world, BlockPos pos, Player player) {
                return new ItemStack((ItemLike)Items.REDSTONE_TORCH);
            }
        }).initialProperties(() -> Blocks.REDSTONE_WALL_TORCH).addLayer(() -> RenderType::cutoutMipped).blockstate((ctx, prov) -> {
            ResourceLocation parent = prov.modLoc("block/jigarbov_wall_torch");
            ResourceLocation etchTexture = prov.modLoc("block/jigarbov/" + type.getName());
            BlockModelBuilder modelLit = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName(), parent)).texture("torch", prov.mcLoc("block/redstone_torch"))).texture("jigarbov", etchTexture);
            BlockModelBuilder modelOff = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_off", parent)).texture("torch", prov.mcLoc("block/redstone_torch_off"))).texture("jigarbov", etchTexture);
            prov.getVariantBuilder((Block)ctx.get()).forAllStates(state -> {
                boolean lit = (Boolean)state.getValue((Property)RedstoneTorchBlock.LIT);
                Direction facing = (Direction)state.getValue((Property)RedstoneWallTorchBlock.FACING);
                int angle = ((int)facing.toYRot() + 90) % 360;
                return ConfiguredModel.builder().modelFile((ModelFile)(lit ? modelLit : modelOff)).rotationY(angle).build();
            });
        }).loot((loot, block) -> loot.dropOther((Block)block, (ItemLike)Items.REDSTONE_TORCH)).register()));
    }
}

