/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.tropicraft.core.common.block.TropicraftBlocks;

public class PineappleBlock
extends TallFlowerBlock
implements BonemealableBlock {
    public static final int TOTAL_GROW_TICKS = 7;
    public static final IntegerProperty STAGE = BlockStateProperties.AGE_7;

    public PineappleBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)super.defaultBlockState().setValue((Property)STAGE, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HALF, STAGE});
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState blockState) {
        return blockState.is(TropicraftBlocks.PINEAPPLE) && blockState.getValue((Property)HALF) == DoubleBlockHalf.LOWER && level.getBlockState(pos.above()).isAir();
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        int currentStage = (Integer)state.getValue((Property)STAGE);
        if (currentStage < 7) {
            BlockState growthState = (BlockState)state.setValue((Property)STAGE, (Comparable)Integer.valueOf(currentStage + 1));
            world.setBlock(pos, growthState, 4);
        } else {
            BlockState above = world.getBlockState(pos.above());
            if (above.is((Block)this)) {
                return;
            }
            if (state.getValue((Property)HALF) == DoubleBlockHalf.UPPER) {
                return;
            }
            BlockState fullGrowth = (BlockState)state.setValue((Property)HALF, (Comparable)DoubleBlockHalf.UPPER);
            world.setBlock(pos.above(), fullGrowth, 3);
        }
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (pos.getY() > world.getMaxBuildHeight() - 2) {
            return;
        }
        int growth = (Integer)state.getValue((Property)STAGE);
        if (state.is((Block)this) && growth <= 7 && world.isEmptyBlock(pos.above()) && state.getValue((Property)HALF) == DoubleBlockHalf.LOWER) {
            if (growth >= 6) {
                BlockState growthState = (BlockState)state.setValue((Property)STAGE, (Comparable)Integer.valueOf(7));
                world.setBlock(pos, growthState, 7);
                BlockState fullGrowth = (BlockState)growthState.setValue((Property)HALF, (Comparable)DoubleBlockHalf.UPPER);
                world.setBlock(pos.above(), fullGrowth, 3);
            } else {
                BlockState growthState = (BlockState)state.setValue((Property)STAGE, (Comparable)Integer.valueOf(growth + 1));
                world.setBlock(pos, growthState, 7);
            }
        }
    }

    public BlockState playerWillDestroy(Level worldIn, BlockPos pos, BlockState state, Player player) {
        if (state.getValue((Property)HALF) == DoubleBlockHalf.LOWER) {
            return super.playerWillDestroy(worldIn, pos, state, player);
        }
        worldIn.levelEvent(player, 2001, pos, PineappleBlock.getId((BlockState)state));
        PineappleBlock.dropResources((BlockState)state, (Level)worldIn, (BlockPos)pos, null, (Entity)player, (ItemStack)player.getMainHandItem());
        return state;
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (this.canSurvive(stateIn, (LevelReader)worldIn, currentPos)) {
            return stateIn;
        }
        return Blocks.AIR.defaultBlockState();
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        if (state.getValue((Property)HALF) == DoubleBlockHalf.UPPER) {
            return level.getBlockState(pos.below()).is(TropicraftBlocks.PINEAPPLE);
        }
        return super.canSurvive(state, level, pos);
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
    }
}

