/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.tropicraft.core.common.TropicraftTags;
import net.tropicraft.core.common.block.ReedsBlock;
import net.tropicraft.core.common.block.TropicraftBlocks;

public final class MudBlock
extends Block
implements BonemealableBlock {
    public static final MapCodec<MudBlock> CODEC = MudBlock.simpleCodec(MudBlock::new);
    private static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);

    public MudBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<MudBlock> codec() {
        return CODEC;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape getBlockSupportShape(BlockState state, BlockGetter world, BlockPos pos) {
        return Shapes.block();
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.block();
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    @Deprecated
    @OnlyIn(value=Dist.CLIENT)
    public float getShadeBrightness(BlockState state, BlockGetter world, BlockPos pos) {
        return 0.2f;
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return level.getBlockState(pos.above()).isAir();
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        block0: for (int i = 0; i < 96; ++i) {
            BlockPos blockpos1 = pos.above();
            for (int j = 0; j < i / 16; ++j) {
                if (!level.getBlockState((blockpos1 = blockpos1.offset(random.nextInt(3) - 1, (random.nextInt(3) - 1) * random.nextInt(3) / 2, random.nextInt(3) - 1)).below()).is(TropicraftTags.Blocks.MUD) || level.getBlockState(blockpos1).isCollisionShapeFullBlock((BlockGetter)level, blockpos1)) continue block0;
            }
            BlockState blockstate1 = level.getBlockState(blockpos1);
            if (blockstate1.is(TropicraftTags.Blocks.MUD) && random.nextInt(10) == 0) {
                ((BonemealableBlock)TropicraftBlocks.MUD.get()).performBonemeal(level, random, blockpos1, blockstate1);
                continue;
            }
            if (!blockstate1.isAir() || random.nextInt(2) != 0) continue;
            level.setBlock(blockpos1, ((ReedsBlock)((Object)TropicraftBlocks.REEDS.get())).defaultBlockState(), 3);
        }
    }
}

