/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Reference2ByteMap;
import it.unimi.dsi.fastutil.objects.Reference2ByteOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tropicraft.core.common.block.TropicraftBlocks;

public final class MangroveRootsBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final MapCodec<MangroveRootsBlock> CODEC = MangroveRootsBlock.simpleCodec(MangroveRootsBlock::new);
    private static final Reference2ByteMap<BlockState> STATE_TO_KEY = new Reference2ByteOpenHashMap();
    private static final VoxelShape[] SHAPE_TABLE = MangroveRootsBlock.buildShapeTable();
    private static final int PIANGUA_GROW_CHANCE = 80;
    private static final int PIANGUA_RADIUS = 1;
    public static final BooleanProperty TALL = BooleanProperty.create((String)"tall");
    public static final BooleanProperty GROUNDED = BooleanProperty.create((String)"grounded");
    public static final EnumProperty<Connection> NORTH = EnumProperty.create((String)"north", Connection.class);
    public static final EnumProperty<Connection> EAST = EnumProperty.create((String)"east", Connection.class);
    public static final EnumProperty<Connection> SOUTH = EnumProperty.create((String)"south", Connection.class);
    public static final EnumProperty<Connection> WEST = EnumProperty.create((String)"west", Connection.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final Direction[] DIRECTIONS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    public static final EnumProperty<Connection>[] CONNECTIONS = new EnumProperty[]{NORTH, EAST, SOUTH, WEST};

    public MangroveRootsBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)TALL, (Comparable)Boolean.valueOf(true))).setValue((Property)GROUNDED, (Comparable)Boolean.valueOf(false))).setValue(NORTH, (Comparable)((Object)Connection.NONE))).setValue(EAST, (Comparable)((Object)Connection.NONE))).setValue(SOUTH, (Comparable)((Object)Connection.NONE))).setValue(WEST, (Comparable)((Object)Connection.NONE))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<MangroveRootsBlock> codec() {
        return CODEC;
    }

    private static VoxelShape[] buildShapeTable() {
        VoxelShape[] table = new VoxelShape[32];
        for (int key = 0; key < table.length; ++key) {
            boolean tall = (key & 1) != 0;
            boolean north = (key >> 1 & 1) != 0;
            boolean east = (key >> 2 & 1) != 0;
            boolean south = (key >> 3 & 1) != 0;
            boolean west = (key >> 4 & 1) != 0;
            table[key] = MangroveRootsBlock.computeShapeFor(tall, north, east, south, west);
        }
        return table;
    }

    private static VoxelShape computeShapeFor(boolean tall, boolean north, boolean east, boolean south, boolean west) {
        double height = tall ? 16.0 : 10.0;
        VoxelShape shape = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)height, (double)10.0);
        if (north) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Block.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)height, (double)6.0));
        }
        if (east) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Block.box((double)10.0, (double)0.0, (double)6.0, (double)16.0, (double)height, (double)10.0));
        }
        if (south) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Block.box((double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)height, (double)16.0));
        }
        if (west) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Block.box((double)0.0, (double)0.0, (double)6.0, (double)6.0, (double)height, (double)10.0));
        }
        return shape;
    }

    private static int shapeKey(BlockState state) {
        return ((Boolean)state.getValue((Property)TALL) != false ? 1 : 0) | (((Connection)((Object)state.getValue(NORTH))).exists() ? 2 : 0) | (((Connection)((Object)state.getValue(EAST))).exists() ? 4 : 0) | (((Connection)((Object)state.getValue(SOUTH))).exists() ? 8 : 0) | (((Connection)((Object)state.getValue(WEST))).exists() ? 16 : 0);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        byte key = STATE_TO_KEY.computeByteIfAbsent((Object)state, MangroveRootsBlock::shapeKey);
        return SHAPE_TABLE[key];
    }

    public VoxelShape getBlockSupportShape(BlockState state, BlockGetter reader, BlockPos pos) {
        return super.getBlockSupportShape(state, reader, pos);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.getConnectedState((LevelReader)context.getLevel(), context.getClickedPos());
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return this.getConnectedState((LevelReader)world, currentPos);
    }

    private BlockState getConnectedState(LevelReader world, BlockPos pos) {
        BlockState state = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(pos).is(FluidTags.WATER)))).setValue((Property)GROUNDED, (Comparable)Boolean.valueOf(this.isGrounded((BlockGetter)world, pos)));
        if (!this.isTall(state = (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH, (Comparable)((Object)this.getConnectionFor(world, pos, Direction.NORTH)))).setValue(EAST, (Comparable)((Object)this.getConnectionFor(world, pos, Direction.EAST)))).setValue(SOUTH, (Comparable)((Object)this.getConnectionFor(world, pos, Direction.SOUTH)))).setValue(WEST, (Comparable)((Object)this.getConnectionFor(world, pos, Direction.WEST)))) && !this.canConnectUp(world, pos.above())) {
            state = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)TALL, (Comparable)Boolean.valueOf(false))).setValue(NORTH, (Comparable)((Object)((Connection)((Object)state.getValue(NORTH))).shorten()))).setValue(EAST, (Comparable)((Object)((Connection)((Object)state.getValue(EAST))).shorten()))).setValue(SOUTH, (Comparable)((Object)((Connection)((Object)state.getValue(SOUTH))).shorten()))).setValue(WEST, (Comparable)((Object)((Connection)((Object)state.getValue(WEST))).shorten()));
        }
        return state;
    }

    private Connection getConnectionFor(LevelReader world, BlockPos pos, Direction direction) {
        BlockPos adjacentPos = pos.relative(direction);
        BlockState adjacentState = world.getBlockState(adjacentPos);
        if (this.canConnectTo(adjacentState, (BlockGetter)world, adjacentPos, direction)) {
            if (world.getBlockState(pos.above()).is((Block)this) && this.canConnectTo((BlockGetter)world, adjacentPos.above(), direction)) {
                return Connection.NONE;
            }
            if (adjacentState.is((Block)this)) {
                boolean tall = this.isAdjacentTall(world, adjacentPos, direction.getOpposite());
                return tall ? Connection.HIGH : Connection.LOW;
            }
            return Connection.HIGH;
        }
        return Connection.NONE;
    }

    private boolean isAdjacentTall(LevelReader world, BlockPos pos, Direction sourceDirection) {
        if (this.canConnectUp(world, pos.above())) {
            return true;
        }
        for (Direction direction : DIRECTIONS) {
            if (direction == sourceDirection || !this.canConnectTo((BlockGetter)world, pos.relative(direction), direction)) continue;
            return true;
        }
        return false;
    }

    private boolean isTall(BlockState state) {
        int count = 0;
        if (((Connection)((Object)state.getValue(NORTH))).exists()) {
            ++count;
        }
        if (((Connection)((Object)state.getValue(EAST))).exists()) {
            ++count;
        }
        if (((Connection)((Object)state.getValue(SOUTH))).exists()) {
            ++count;
        }
        if (((Connection)((Object)state.getValue(WEST))).exists()) {
            ++count;
        }
        return count > 1;
    }

    private boolean canConnectTo(BlockGetter world, BlockPos pos, Direction direction) {
        return this.canConnectTo(world.getBlockState(pos), world, pos, direction);
    }

    private boolean canConnectTo(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        return (state.is((Block)this) || state.isFaceSturdy(world, pos, direction)) && !FenceBlock.isExceptionForConnection((BlockState)state) && !(state.getBlock() instanceof TrapDoorBlock);
    }

    private boolean canConnectUp(LevelReader world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        return (state.is((Block)this) || Block.canSupportCenter((LevelReader)world, (BlockPos)pos, (Direction)Direction.DOWN)) && !(state.getBlock() instanceof TrapDoorBlock);
    }

    private boolean isGrounded(BlockGetter world, BlockPos pos) {
        BlockPos groundPos = pos.below();
        return world.getBlockState(groundPos).isFaceSturdy(world, groundPos, Direction.UP);
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.getValue((Property)WATERLOGGED) == false;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return switch (rotation) {
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH, (Comparable)((Object)((Connection)((Object)state.getValue(SOUTH)))))).setValue(EAST, (Comparable)((Object)((Connection)((Object)state.getValue(WEST)))))).setValue(SOUTH, (Comparable)((Object)((Connection)((Object)state.getValue(NORTH)))))).setValue(WEST, (Comparable)((Object)((Connection)((Object)state.getValue(EAST)))));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH, (Comparable)((Object)((Connection)((Object)state.getValue(EAST)))))).setValue(EAST, (Comparable)((Object)((Connection)((Object)state.getValue(SOUTH)))))).setValue(SOUTH, (Comparable)((Object)((Connection)((Object)state.getValue(WEST)))))).setValue(WEST, (Comparable)((Object)((Connection)((Object)state.getValue(NORTH)))));
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH, (Comparable)((Object)((Connection)((Object)state.getValue(WEST)))))).setValue(EAST, (Comparable)((Object)((Connection)((Object)state.getValue(NORTH)))))).setValue(SOUTH, (Comparable)((Object)((Connection)((Object)state.getValue(EAST)))))).setValue(WEST, (Comparable)((Object)((Connection)((Object)state.getValue(SOUTH)))));
            default -> state;
        };
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return switch (mirror) {
            case Mirror.LEFT_RIGHT -> (BlockState)((BlockState)state.setValue(NORTH, (Comparable)((Object)((Connection)((Object)state.getValue(SOUTH)))))).setValue(SOUTH, (Comparable)((Object)((Connection)((Object)state.getValue(NORTH)))));
            case Mirror.FRONT_BACK -> (BlockState)((BlockState)state.setValue(EAST, (Comparable)((Object)((Connection)((Object)state.getValue(WEST)))))).setValue(WEST, (Comparable)((Object)((Connection)((Object)state.getValue(EAST)))));
            default -> super.mirror(state, mirror);
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TALL, GROUNDED, NORTH, EAST, SOUTH, WEST, WATERLOGGED});
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    public boolean isRandomlyTicking(BlockState state) {
        return (Boolean)state.getValue((Property)GROUNDED) != false && (Boolean)state.getValue((Property)TALL) != false;
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (random.nextInt(80) == 0) {
            this.tryGrowPianguas(world, pos, random);
        }
    }

    private void tryGrowPianguas(ServerLevel world, BlockPos pos, RandomSource random) {
        BlockPos soilPos = pos.below();
        if (!world.getBlockState(soilPos).is(TropicraftBlocks.MUD)) {
            return;
        }
        BlockPos growPos = soilPos.offset(random.nextInt(3) - 1, -random.nextInt(2), random.nextInt(3) - 1);
        BlockState growIn = world.getBlockState(growPos);
        if (growIn.is(TropicraftBlocks.MUD) && !world.getBlockState(growPos.above()).canOcclude() && !this.hasNearPianguas(world, growPos)) {
            world.setBlockAndUpdate(growPos, ((Block)TropicraftBlocks.MUD_WITH_PIANGUAS.get()).defaultBlockState());
        }
    }

    private boolean hasNearPianguas(ServerLevel world, BlockPos source) {
        Block mudWithPianguas = (Block)TropicraftBlocks.MUD_WITH_PIANGUAS.get();
        BlockPos minSpacingPos = source.offset(-1, -1, -1);
        BlockPos maxSpacingPos = source.offset(1, 0, 1);
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)minSpacingPos, (BlockPos)maxSpacingPos)) {
            if (!world.getBlockState(pos).is(mudWithPianguas)) continue;
            return true;
        }
        return false;
    }

    public static enum Connection implements StringRepresentable
    {
        NONE("none"),
        HIGH("high"),
        LOW("low");

        private final String key;

        private Connection(String key) {
            this.key = key;
        }

        public boolean exists() {
            return this != NONE;
        }

        public String getSerializedName() {
            return this.key;
        }

        public Connection shorten() {
            return this == HIGH ? LOW : this;
        }
    }
}

