/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SeagrassBlock;
import net.minecraft.world.level.block.TallSeagrassBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public final class CustomSeagrassBlock
extends SeagrassBlock {
    private final String scientificName;
    @Nullable
    private final Supplier<? extends TallSeagrassBlock> tall;

    public CustomSeagrassBlock(BlockBehaviour.Properties properties, String scientificName, @Nullable Supplier<? extends TallSeagrassBlock> tall) {
        super(properties);
        this.scientificName = scientificName;
        this.tall = tall;
    }

    public MapCodec<SeagrassBlock> codec() {
        throw new UnsupportedOperationException();
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.literal((String)this.scientificName).withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        if (this.tall == null) {
            return;
        }
        BlockState bottomState = this.tall.get().defaultBlockState();
        BlockState topState = (BlockState)bottomState.setValue((Property)TallSeagrassBlock.HALF, (Comparable)DoubleBlockHalf.UPPER);
        BlockPos topPos = pos.above();
        if (level.getBlockState(topPos).is(Blocks.WATER)) {
            level.setBlock(pos, bottomState, 2);
            level.setBlock(topPos, topState, 2);
        }
    }
}

