/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BlockTropicraftSand
extends FallingBlock {
    public static final MapCodec<BlockTropicraftSand> CODEC = BlockTropicraftSand.simpleCodec(BlockTropicraftSand::new);
    public static final BooleanProperty UNDERWATER = BooleanProperty.create((String)"underwater");
    private final int dustColor;

    public BlockTropicraftSand(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)UNDERWATER, (Comparable)Boolean.valueOf(false)));
        this.dustColor = this.defaultMapColor().col | 0xFF000000;
    }

    protected MapCodec<? extends BlockTropicraftSand> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{UNDERWATER});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState upState = context.getLevel().getFluidState(context.getClickedPos().above());
        return (BlockState)this.defaultBlockState().setValue((Property)UNDERWATER, (Comparable)Boolean.valueOf(!upState.isEmpty()));
    }

    @Deprecated
    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos pos2, boolean isMoving) {
        FluidState upState = world.getFluidState(pos.above());
        boolean underwater = upState.getType().isSame((Fluid)Fluids.WATER);
        if (underwater != (Boolean)state.getValue((Property)UNDERWATER)) {
            world.setBlock(pos, (BlockState)state.setValue((Property)UNDERWATER, (Comparable)Boolean.valueOf(underwater)), 2);
        }
        super.neighborChanged(state, world, pos, block, pos2, isMoving);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getDustColor(BlockState state, BlockGetter reader, BlockPos pos) {
        return this.dustColor;
    }
}

