/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.block.tileentity.AirCompressorBlockEntity;

public final class AirCompressorBlock
extends BaseEntityBlock {
    public static final MapCodec<AirCompressorBlock> CODEC = AirCompressorBlock.simpleCodec(AirCompressorBlock::new);
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;

    public AirCompressorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue(FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<AirCompressorBlock> codec() {
        return CODEC;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return AirCompressorBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)TropicraftBlocks.AIR_COMPRESSOR_ENTITY.get()), AirCompressorBlockEntity::compressTick);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add((Component)Component.translatable((String)(this.getDescriptionId() + ".desc")).withStyle(ChatFormatting.GRAY));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof AirCompressorBlockEntity)) {
            return InteractionResult.FAIL;
        }
        AirCompressorBlockEntity compressor = (AirCompressorBlockEntity)blockEntity;
        if (compressor.isDoneCompressing()) {
            compressor.ejectTank();
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof AirCompressorBlockEntity)) {
            return ItemInteractionResult.FAIL;
        }
        AirCompressorBlockEntity compressor = (AirCompressorBlockEntity)blockEntity;
        if (compressor.isDoneCompressing()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        ItemStack ingredientStack = stack.copyWithCount(1);
        if (compressor.addTank(ingredientStack)) {
            player.getInventory().removeItem(player.getInventory().selected, 1);
        }
        return ItemInteractionResult.CONSUME;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!world.isClientSide) {
            AirCompressorBlockEntity te = (AirCompressorBlockEntity)world.getBlockEntity(pos);
            te.ejectTank();
        }
        super.onRemove(state, world, pos, newState, isMoving);
    }

    public BlockEntity newBlockEntity(BlockPos p, BlockState s) {
        return new AirCompressorBlockEntity((BlockEntityType<AirCompressorBlockEntity>)((BlockEntityType)TropicraftBlocks.AIR_COMPRESSOR_ENTITY.get()), p, s);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState ret = super.getStateForPlacement(context);
        return (BlockState)ret.setValue(FACING, (Comparable)context.getHorizontalDirection());
    }
}

