/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.tileentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.tropicraft.core.client.entity.model.MachineModel;
import net.tropicraft.core.common.block.tileentity.IMachineBlock;

public abstract class MachineRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private final Block block;
    protected final MachineModel model;

    public MachineRenderer(BlockEntityRendererProvider.Context context, Block block, MachineModel model) {
        this.block = block;
        this.model = model;
    }

    public void render(T te, float partialTicks, PoseStack stack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        stack.pushPose();
        stack.translate(0.5f, 1.5f, 0.5f);
        stack.mulPose(Axis.XP.rotationDegrees(180.0f));
        if (te == null || te.getLevel() == null) {
            stack.mulPose(Axis.YP.rotationDegrees(-90.0f));
        } else {
            BlockState state = te.getLevel().getBlockState(te.getBlockPos());
            Direction facing = state.getBlock() != this.block ? Direction.NORTH : ((IMachineBlock)te).getDirection(state);
            stack.mulPose(Axis.YP.rotationDegrees(facing.toYRot() + 90.0f));
        }
        if (te != null && ((IMachineBlock)te).isActive()) {
            this.animationTransform(te, stack, partialTicks);
        }
        RenderType renderType = this.model.renderType(this.getMaterial().texture());
        this.model.renderToBuffer(stack, buffer.getBuffer(renderType), combinedLightIn, combinedOverlayIn);
        if (te != null) {
            this.renderIngredients(te, stack, buffer, combinedLightIn, combinedOverlayIn);
        }
        stack.popPose();
    }

    protected abstract Material getMaterial();

    protected void animationTransform(T te, PoseStack stack, float partialTicks) {
        float angle = Mth.sin((float)((float)(157.07963267948966 * (double)((IMachineBlock)te).getProgress(partialTicks)))) * 15.0f;
        stack.mulPose(Axis.YP.rotationDegrees(angle));
    }

    protected abstract void renderIngredients(T var1, PoseStack var2, MultiBufferSource var3, int var4, int var5);

    public AABB getRenderBoundingBox(T blockEntity) {
        BlockPos pos = blockEntity.getBlockPos();
        return new AABB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)pos.getX() + 1.0, (double)pos.getY() + 2.0, (double)pos.getZ() + 1.0);
    }
}

