/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.tileentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.level.block.Block;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.client.TropicraftRenderLayers;
import net.tropicraft.core.client.entity.model.EIHMachineModel;
import net.tropicraft.core.client.scuba.ModelScubaGear;
import net.tropicraft.core.client.tileentity.MachineRenderer;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.block.tileentity.AirCompressorBlockEntity;
import net.tropicraft.core.common.item.scuba.ScubaArmorItem;

public class AirCompressorRenderer
extends MachineRenderer<AirCompressorBlockEntity> {
    private static final Material MATERIAL = new Material(TextureAtlas.LOCATION_BLOCKS, Tropicraft.location("textures/block/te/drink_mixer.png"));
    private final ModelScubaGear tankModel;

    public AirCompressorRenderer(BlockEntityRendererProvider.Context context) {
        super(context, (Block)TropicraftBlocks.AIR_COMPRESSOR.get(), new EIHMachineModel(Minecraft.getInstance().getEntityModels().bakeLayer(TropicraftRenderLayers.AIRCOMPRESSOR_LAYER)));
        this.tankModel = new ModelScubaGear(context.bakeLayer(TropicraftRenderLayers.CHEST_SCUBA_LAYER), EquipmentSlot.CHEST);
    }

    @Override
    protected Material getMaterial() {
        return MATERIAL;
    }

    @Override
    protected void animationTransform(AirCompressorBlockEntity te, PoseStack stack, float partialTicks) {
        float progress = te.getBreatheProgress(partialTicks);
        float sin = 1.0f + Mth.cos((float)progress);
        float sc = 1.0f + 0.05f * sin;
        stack.translate(0.0f, 1.5f, 0.0f);
        stack.scale(sc, sc, sc);
        stack.translate(0.0f, -1.5f, 0.0f);
        if ((double)progress < Math.PI) {
            float shake = Mth.sin((float)(te.getBreatheProgress(partialTicks) * 10.0f)) * 8.0f;
            stack.mulPose(Axis.YP.rotationDegrees(shake));
        }
    }

    @Override
    protected void renderIngredients(AirCompressorBlockEntity te, PoseStack stack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        if (te.isActive()) {
            stack.pushPose();
            stack.translate(-0.5f, 0.5f, 0.0f);
            stack.mulPose(Axis.YP.rotationDegrees(90.0f));
            VertexConsumer builder = ItemRenderer.getFoilBuffer((MultiBufferSource)buffer, (RenderType)RenderType.entityCutoutNoCull((ResourceLocation)ScubaArmorItem.getArmorTexture(te.getTank().getScubaType())), (boolean)true, (boolean)false);
            this.tankModel.showChest = true;
            this.tankModel.renderScubaGear(stack, builder, combinedLightIn, combinedOverlayIn, false);
            stack.popPose();
        }
    }
}

