/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.player.Player;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.client.entity.TropicraftSpecialRenderHelper;
import net.tropicraft.core.client.entity.model.TropicraftFishModel;
import net.tropicraft.core.common.entity.underdasea.IAtlasFish;

public class TropicraftFishRenderer<T extends AbstractFish>
extends MobRenderer<T, TropicraftFishModel<T>> {
    private static final ResourceLocation TEXTURE = Tropicraft.location("textures/entity/tropical_fish.png");
    private final TropicraftSpecialRenderHelper renderHelper = new TropicraftSpecialRenderHelper();

    public TropicraftFishRenderer(EntityRendererProvider.Context context, TropicraftFishModel<T> modelbase, float f) {
        super(context, modelbase, f);
    }

    public void render(T entity, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        boolean shouldRender;
        boolean isVisible = this.isBodyVisible((LivingEntity)entity);
        boolean bl = shouldRender = !isVisible && !entity.isInvisibleTo((Player)Minecraft.getInstance().player);
        if (isVisible || shouldRender) {
            boolean glowing = Minecraft.getInstance().shouldEntityAppearGlowing(entity);
            this.renderFishy(entity, partialTicks, matrixStackIn, bufferIn.getBuffer(this.getRenderType((LivingEntity)entity, isVisible, shouldRender, glowing)), packedLightIn, TropicraftFishRenderer.getOverlayCoords(entity, (float)this.getWhiteOverlayProgress((LivingEntity)entity, partialTicks)));
        }
        super.render(entity, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    protected void renderFishy(T entity, float partialTicks, PoseStack stack, VertexConsumer buffer, int light, int overlay) {
        stack.pushPose();
        stack.mulPose(Axis.YP.rotationDegrees(-90.0f));
        stack.mulPose(Axis.YP.rotationDegrees(-Mth.lerp((float)partialTicks, (float)((AbstractFish)entity).yHeadRotO, (float)((AbstractFish)entity).yHeadRot)));
        stack.mulPose(Axis.XP.rotationDegrees(180.0f));
        stack.scale(0.3f, 0.3f, 0.5f);
        stack.translate(0.85f, -0.3f, 0.0f);
        int fishTex = 0;
        if (entity instanceof IAtlasFish) {
            fishTex = ((IAtlasFish)entity).getAtlasSlot() * 2;
        }
        this.renderHelper.renderFish(stack, buffer, fishTex, light, overlay);
        stack.translate(-1.7f, 0.0f, 0.0f);
        stack.translate(0.85f, 0.0f, 0.025f);
        stack.mulPose(Axis.YP.rotation(((TropicraftFishModel)this.model).tail.yRot));
        stack.translate(-0.85f, 0.0f, -0.025f);
        this.renderHelper.renderFish(stack, buffer, fishTex + 1, light, overlay);
        stack.popPose();
    }

    protected void scale(T entity, PoseStack stack, float partialTickTime) {
        stack.scale(0.75f, 0.2f, 0.2f);
    }

    public ResourceLocation getTextureLocation(T entity) {
        return TEXTURE;
    }
}

