/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.client.TropicraftRenderLayers;
import net.tropicraft.core.client.entity.model.SharkModel;
import net.tropicraft.core.common.entity.underdasea.SharkEntity;

public class SharkRenderer
extends MobRenderer<SharkEntity, SharkModel> {
    public static final ResourceLocation BASIC_SHARK_TEXTURE = Tropicraft.location("textures/entity/shark/hammerhead1.png");
    public static final ResourceLocation BOSS_SHARK_TEXTURE = Tropicraft.location("textures/entity/shark/hammerhead4.png");

    public SharkRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new SharkModel(context.bakeLayer(TropicraftRenderLayers.HAMMERHEAD_LAYER)), 1.0f);
    }

    public ResourceLocation getTextureLocation(SharkEntity sharkEntity) {
        if (sharkEntity.isBoss()) {
            return BOSS_SHARK_TEXTURE;
        }
        return BASIC_SHARK_TEXTURE;
    }

    public void render(SharkEntity shark, float yaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int light) {
        stack.pushPose();
        stack.translate(0.0f, -1.0f, 0.0f);
        super.render((LivingEntity)shark, yaw, partialTicks, stack, buffer, light);
        stack.popPose();
    }

    protected void scale(SharkEntity shark, PoseStack stack, float partialTickTime) {
        float scale = 1.0f;
        if (shark.isBoss()) {
            scale = 1.5f;
            stack.translate(0.0f, 0.3f, 0.0f);
        }
        stack.scale(scale, scale, scale);
    }
}

