/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.client.TropicraftRenderLayers;
import net.tropicraft.core.client.entity.model.SeahorseModel;
import net.tropicraft.core.common.entity.underdasea.SeahorseEntity;

public class SeahorseRenderer
extends MobRenderer<SeahorseEntity, SeahorseModel> {
    public SeahorseRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new SeahorseModel(context.bakeLayer(TropicraftRenderLayers.SEAHORSE_LAYER)), 0.5f);
        this.shadowStrength = 0.5f;
    }

    public void render(SeahorseEntity seahorse, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        matrixStackIn.pushPose();
        matrixStackIn.translate(0.0f, -1.0f, 0.0f);
        matrixStackIn.scale(0.5f, 0.5f, 0.5f);
        super.render((LivingEntity)seahorse, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        matrixStackIn.popPose();
    }

    public ResourceLocation getTextureLocation(SeahorseEntity seahorseEntity) {
        return Tropicraft.location("textures/entity/seahorse/" + seahorseEntity.getTexture() + ".png");
    }
}

