/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.client.TropicraftRenderLayers;
import net.tropicraft.core.client.entity.model.SeaTurtleModel;
import net.tropicraft.core.common.entity.SeaTurtleEntity;

public class SeaTurtleRenderer
extends MobRenderer<SeaTurtleEntity, SeaTurtleModel> {
    public SeaTurtleRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new SeaTurtleModel(context.bakeLayer(TropicraftRenderLayers.SEA_TURTLE_LAYER)), 0.7f);
        this.shadowRadius = 0.5f;
        this.shadowStrength = 0.5f;
    }

    public void render(SeaTurtleEntity turtle, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource bufferIn, int packedLightIn) {
        float scale = 0.3f;
        float existingTime = (float)turtle.tickCount / 4000.0f;
        if (turtle.tickCount < 30) {
            this.shadowStrength = 0.5f;
            this.shadowRadius = 0.2f + existingTime;
            if (this.shadowRadius > 0.5f) {
                this.shadowRadius = 0.5f;
            }
        } else {
            scale = 0.3f + existingTime;
            if (scale > 1.0f) {
                scale = 1.0f;
            }
        }
        if (turtle.isMature()) {
            scale = 1.0f;
        }
        stack.pushPose();
        stack.scale(scale, scale, scale);
        super.render((LivingEntity)turtle, entityYaw, partialTicks, stack, bufferIn, packedLightIn);
        stack.popPose();
    }

    public ResourceLocation getTextureLocation(SeaTurtleEntity seaTurtleEntity) {
        return Tropicraft.location("textures/entity/turtle/sea_turtle" + seaTurtleEntity.getTurtleType() + ".png");
    }
}

