/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.Items;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.tropicraft.core.common.entity.passive.EntityKoaBase;
import net.tropicraft.core.common.entity.passive.FishingBobberEntity;

@OnlyIn(value=Dist.CLIENT)
public class FishingBobberEntityRenderer
extends EntityRenderer<FishingBobberEntity> {
    private static final ResourceLocation TEXTURE_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/fishing_hook.png");
    private static final RenderType RENDER_TYPE = RenderType.entityCutout((ResourceLocation)TEXTURE_LOCATION);

    public FishingBobberEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(FishingBobberEntity entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        float handOffset;
        EntityKoaBase koa = entity.getAngler();
        if (koa == null) {
            return;
        }
        poseStack.pushPose();
        poseStack.scale(0.5f, 0.5f, 0.5f);
        poseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        PoseStack.Pose pose = poseStack.last();
        VertexConsumer consumer = bufferSource.getBuffer(RENDER_TYPE);
        FishingBobberEntityRenderer.vertex(consumer, pose, packedLight, 0.0f, 0, 0, 1);
        FishingBobberEntityRenderer.vertex(consumer, pose, packedLight, 1.0f, 0, 1, 1);
        FishingBobberEntityRenderer.vertex(consumer, pose, packedLight, 1.0f, 1, 1, 0);
        FishingBobberEntityRenderer.vertex(consumer, pose, packedLight, 0.0f, 1, 0, 0);
        poseStack.popPose();
        float f = handOffset = koa.getMainArm() == HumanoidArm.RIGHT ? 0.35f : -0.35f;
        if (!koa.getMainHandItem().is(Items.FISHING_ROD)) {
            handOffset = -handOffset;
        }
        float yBodyRot = Mth.lerp((float)partialTicks, (float)koa.yBodyRotO, (float)koa.yBodyRot) * ((float)Math.PI / 180);
        float sin = Mth.sin((float)yBodyRot);
        float cos = Mth.cos((float)yBodyRot);
        double rodX = Mth.lerp((double)partialTicks, (double)koa.xo, (double)koa.getX()) - (double)(cos * handOffset) - (double)sin * 0.8;
        double rodY = koa.yo + (double)koa.getEyeHeight() + (koa.getY() - koa.yo) * (double)partialTicks - 0.45;
        double rodZ = Mth.lerp((double)partialTicks, (double)koa.zo, (double)koa.getZ()) - (double)(sin * handOffset) + (double)cos * 0.8;
        float offset = koa.isCrouching() ? -0.1875f : 0.0f;
        double bobberX = Mth.lerp((double)partialTicks, (double)entity.xo, (double)entity.getX());
        double bobberY = Mth.lerp((double)partialTicks, (double)entity.yo, (double)entity.getY()) + 0.25;
        double bobberZ = Mth.lerp((double)partialTicks, (double)entity.zo, (double)entity.getZ());
        float deltaX = (float)(rodX - bobberX);
        float deltaY = (float)(rodY - bobberY) + offset;
        float deltaZ = (float)(rodZ - bobberZ);
        VertexConsumer line = bufferSource.getBuffer(RenderType.lineStrip());
        for (int i = 0; i <= 16; ++i) {
            FishingBobberEntityRenderer.stringVertex(deltaX, deltaY, deltaZ, line, poseStack.last(), (float)i / 16.0f, (float)(i + 1) / 16.0f);
        }
        super.render((Entity)entity, yaw, partialTicks, poseStack, bufferSource, packedLight);
    }

    private static void vertex(VertexConsumer consumer, PoseStack.Pose pose, int p_114715_, float p_114716_, int p_114717_, int p_114718_, int p_114719_) {
        consumer.addVertex(pose, p_114716_ - 0.5f, (float)p_114717_ - 0.5f, 0.0f).setColor(-1).setUv((float)p_114718_, (float)p_114719_).setOverlay(OverlayTexture.NO_OVERLAY).setLight(p_114715_).setNormal(pose, 0.0f, 1.0f, 0.0f);
    }

    private static void stringVertex(float deltaX, float deltaY, float deltaZ, VertexConsumer consumer, PoseStack.Pose pose, float start, float end) {
        float x = deltaX * start;
        float y = deltaY * (start * start + start) * 0.5f + 0.25f;
        float z = deltaZ * start;
        float normalX = deltaX * end - x;
        float normalY = deltaY * (end * end + end) * 0.5f + 0.25f - y;
        float normalZ = deltaZ * end - z;
        float length = Mth.sqrt((float)(normalX * normalX + normalY * normalY + normalZ * normalZ));
        consumer.addVertex(pose, x, y, z).setColor(-16777216).setNormal(pose, normalX /= length, normalY /= length, normalZ /= length);
    }

    public ResourceLocation getTextureLocation(FishingBobberEntity pEntity) {
        return TEXTURE_LOCATION;
    }
}

